/////////////////////////////////////////////////////////////////////////////
// Name:        wxmachapp.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     13/02/2012 22:20:38
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _WXMACHAPP_H_
#define _WXMACHAPP_H_


/*!
 * Includes
 */

////@begin includes
#include "wx/image.h"
////@end includes
#include <wx/cmdline.h>
#include <wx/debugrpt.h>
/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
////@end control identifiers
class splashThread;
class wxSingleInstanceChecker;
class wxTranslationHelper;
class wxMachS;

/*!
 * wxMachApp class declaration
 */

class wxMachApp: public wxApp
{    
    DECLARE_CLASS( wxMachApp )
    DECLARE_EVENT_TABLE()

public:
    /// Constructor
    wxMachApp();
	~wxMachApp();

    void Init();

    /// Initialises the application
    virtual bool OnInit();
	virtual void OnFatalException();
    /// Called on exit
    virtual int OnExit();

	void GenerateReport(wxDebugReport::Context ctx);
////@begin wxMachApp event handler declarations

	/// wxEVT_IDLE event handler for ID_UNIDENTIFIED
	void OnIdle( wxIdleEvent& event );

////@end wxMachApp event handler declarations

////@begin wxMachApp member function declarations

	bool GetFirsttime() const { return m_firsttime ; }
	void SetFirsttime(bool value) { m_firsttime = value ; }

	bool GetSelDone() const { return m_selDone ; }
	void SetSelDone(bool value) { m_selDone = value ; }

////@end wxMachApp member function declarations
	virtual void OnInitCmdLine(wxCmdLineParser& parser);
	virtual bool OnCmdLineParsed(wxCmdLineParser& parser);
	void SplashThread(wxWindow *parent, splashThread *th);
	void RestartGUI(void);
	bool SelectLanguage(void);

////@begin wxMachApp member variables
protected:
	bool m_firsttime;
	bool m_selDone;
////@end wxMachApp member variables
	wxString m_cmdLine;
	wxString m_profileName;
	bool m_debug;
	wxSingleInstanceChecker *m_checker;
	wxString m_installPackage;
	wxString m_removePackage;
	wxTranslationHelper *m_TranslationHelper;
	wxMachS* m_mainWindow;
};

/*!
 * Application instance declaration 
 */

////@begin declare app
DECLARE_APP(wxMachApp)
////@end declare app

#endif
    // _WXMACHAPP_H_
