/////////////////////////////////////////////////////////////////////////////
// Name:        wxmachapp.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     13/02/2012 22:20:38
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes
#include "wxmachapp.h"
#include "Splash.h"
#include "SelectProfile.h"
#include "wxMachs.h"
#include <wx/thread.h>
#include <wx/splash.h>
#include "wxTranslationHelper.h"

////@begin XPM images
////@end XPM images
#include "splashgcode.xpm"

class wxMachApp;

class splashThread : public wxThread
{
public:
    splashThread(wxMachApp *app, wxWindow *mainWindow)
    {
		m_app = app;
		m_mainWindow = mainWindow;
        Create();
    }

    virtual ExitCode Entry()
    {
		m_app->SplashThread(m_mainWindow, this);
        return(0);
    }

private:
	wxMachApp *m_app;
	wxWindow *m_mainWindow;
};

/*
 * Application instance implementation
 */

////@begin implement app
IMPLEMENT_APP( wxMachApp )
////@end implement app


/*
 * wxMachApp type definition
 */

IMPLEMENT_CLASS( wxMachApp, wxApp )


/*
 * wxMachApp event table definition
 */

BEGIN_EVENT_TABLE( wxMachApp, wxApp )

////@begin wxMachApp event table entries
	EVT_IDLE( wxMachApp::OnIdle )
////@end wxMachApp event table entries

END_EVENT_TABLE()


/*
 * Constructor for wxMachApp
 */
wxMachApp::~wxMachApp()
{
	int g=0;
	wxUnusedVar(g);
}
wxMachApp::wxMachApp()
{
    Init();
}


/*
 * Member initialisation
 */

void wxMachApp::Init()
{
////@begin wxMachApp member initialisation
	m_firsttime = true;;
	m_selDone = false;
////@end wxMachApp member initialisation
	m_debug = false;
	m_cmdLine = wxEmptyString;
	m_profileName = wxEmptyString;
	m_checker = NULL;
	m_mainWindow = NULL;
}

/*
 * Initialisation for wxMachApp
 */

bool wxMachApp::OnInit()
{    
	if (!wxApp::OnInit()) {
		return(false);
	}

	const wxString name = wxT("MachGUI");
    m_checker = new wxSingleInstanceChecker(name);
    if (m_checker->IsAnotherRunning()) {
		wxMessageBox(_("There is another instance of Mach already running."), _("Mach Error!"));
        return (false);
    }

////@begin wxMachApp initialisation
	// Remove the comment markers above and below this block
	// to make permanent changes to the code.

#if wxUSE_XPM
	wxImage::AddHandler(new wxXPMHandler);
#endif
#if wxUSE_LIBPNG
	wxImage::AddHandler(new wxPNGHandler);
#endif
#if wxUSE_LIBJPEG
	wxImage::AddHandler(new wxJPEGHandler);
#endif
#if wxUSE_GIF
	wxImage::AddHandler(new wxGIFHandler);
#endif
////@end wxMachApp initialisation
	wxFileName fn(argv[0]);
	wxString cwd = wxGetCwd();
	wxString machDir = fn.GetPath();
	wxString langDir = cwd + wxFILE_SEP_PATH + "Lang";

	m_TranslationHelper = new wxTranslationHelper(*this, langDir, false);
	m_TranslationHelper->Load();

#ifdef DEFINE_FOR_TESTING_INSTALL_AND_REMOVE
	if (!machDir.EndsWith(wxT("Mach"))) {
		machDir = cwd;
	}
#endif
	if (m_installPackage != wxEmptyString) {
		wxSetWorkingDirectory(machDir);
		mcPluginInstall(wxToChar(m_installPackage));
		wxSetWorkingDirectory(cwd);
		return(false);
	}
	if (m_removePackage != wxEmptyString) {
		wxSetWorkingDirectory(machDir);
		mcPluginRemove(wxToChar(m_removePackage));
		wxSetWorkingDirectory(cwd);
		return(false);
	}
	if (m_profileName == wxEmptyString) {
		SelectProfile *sp = new SelectProfile(NULL);
		int rc = sp->ShowModal();
		if (rc == wxID_OK) {
			m_profileName = sp->GetProfileName();
		}
		sp->Destroy();
	}
	if (m_profileName == wxEmptyString) {
		return(false);
	}
	m_selDone = true;

#if 0
	splashThread *st = new splashThread(this, mainWindow);
	st->Run();
#endif
#ifdef RELEASE
	wxBitmap bitmap(spalshgcode_xpm);
	wxSplashScreen* splash = new wxSplashScreen(bitmap, wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
		6000, NULL, -1, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER|wxSTAY_ON_TOP);
	wxUnusedVar(splash);
	//splash->Show();
#endif
	RestartGUI();
	m_firsttime = false;
	return true;
}

void wxMachApp::RestartGUI(void)
{
	if (m_mainWindow) {
		wxCloseEvent evt;
		m_mainWindow->OnCloseWindow(evt);
        SetTopWindow(NULL);
    }

	m_mainWindow = new wxMachS();
	wxYield();
	m_mainWindow->SetProfileName(m_profileName);
	m_mainWindow->SetName(wxT("wxMach"));
	m_mainWindow->Create(NULL);
	m_mainWindow->Show(true);
	wxInitDialogEvent event;
	m_mainWindow->OnInitDialog(event);
}

bool wxMachApp::SelectLanguage(void)
{
	wxArrayString names;
	wxArrayLong identifiers;
	m_TranslationHelper->GetInstalledLanguages(names, identifiers);
	bool rc = m_TranslationHelper->AskUserForLanguage(names, identifiers);
	if (rc) {
		m_TranslationHelper->Save();
	}
	return rc;
}

void wxMachApp::OnInitCmdLine(wxCmdLineParser& parser)
{
	wxCmdLineEntryDesc cmdLineDesc[] =
	{
		{ wxCMD_LINE_SWITCH, "d", wxToChar(_("debug")), wxToChar(_("Turn on debugging code")) },
		{ wxCMD_LINE_OPTION, "p", wxToChar(_("profile")), wxToChar(_("Profile Name (No extension)")) },
		{ wxCMD_LINE_OPTION, "i", wxToChar(_("install")), wxToChar(_("Plugin Package Path")) },
		{ wxCMD_LINE_OPTION, "r", wxToChar(_("remove")), wxToChar(_("Plugin Package Name (No extension)")) },
		{ wxCMD_LINE_NONE }
	};

	parser.SetDesc(cmdLineDesc);
	for (int idx = 0; idx < this->argc; idx++) {
		m_cmdLine.Append(this->argv[idx]);
		m_cmdLine.Append(wxT(" "));
	}
	m_cmdLine.RemoveLast();
	return;
}

bool wxMachApp::OnCmdLineParsed(wxCmdLineParser& parser)
{
	m_debug = parser.Found(wxT("d"));
	parser.Found(wxT("p"), &m_profileName);
	parser.Found(wxT("i"), &m_installPackage);
	parser.Found(wxT("r"), &m_removePackage);
	return(true);
}

/*
 * Cleanup for wxMachApp
 */

int wxMachApp::OnExit()
{    
	if (m_checker) {
		delete m_checker;
	}
////@begin wxMachApp cleanup
	return wxApp::OnExit();
////@end wxMachApp cleanup
}


/*
 * wxEVT_IDLE event handler
 */

void wxMachApp::OnIdle( wxIdleEvent& event )
{
	if (m_firsttime && m_selDone) {
	}
	event.Skip();
}

void wxMachApp::SplashThread(wxWindow *parent, splashThread *th)
{
	wxUnusedVar(th);
	Splash *splash = new Splash(parent);
	splash->ShowModal();
	splash->Destroy();
}

void wxMachApp::OnFatalException()
{
    GenerateReport(wxDebugReport::Context_Exception);
}

void wxMachApp::GenerateReport(wxDebugReport::Context ctx)
{
    wxDebugReportCompress *report = new wxDebugReportCompress;

    // add all standard files: currently this means just a minidump and an
    // XML file with system info and stack trace
    report->AddAll(ctx);
#if 0
    // you can also call report->AddFile(...) with your own log files, files
    // created using wxRegKey::Export() and so on, here we just add a test
    // file containing the date of the crash
    wxFileName fn(report->GetDirectory(), _T("timestamp.my"));
    wxFile file(fn.GetFullPath(), _T("w"));
    if ( file.IsOpened() )
    {
        wxDateTime dt = wxDateTime::Now();
        file.Write(dt.FormatISODate() + _T(' ') + dt.FormatISOTime());
        file.Close();
    }

    report->AddFile(fn.GetFullName(), _T("timestamp of this report"));

    // can also add an existing file directly, it will be copied
    // automatically
#ifdef __WXMSW__
    report->AddFile(_T("c:\\autoexec.bat"), _T("DOS startup file"));
#else
    report->AddFile(_T("/etc/motd"), _T("Message of the day"));
#endif
#endif
    // calling Show() is not mandatory, but is more polite
    if ( wxDebugReportPreviewStd().Show(*report) )
    {
        if ( report->Process() )
        {
            wxLogMessage(_T("Report generated in \"%s\"."), report->GetCompressedFileName().c_str());
            report->Reset();
        }
    }
    //else: user cancelled the report

    delete report;
}

