/////////////////////////////////////////////////////////////////////////////
// Name:        wxMachs.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     13/02/2012 22:26:03
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _WXMACHS_H_
#define _WXMACHS_H_

#include <MachAPI.h>
//#include "wxlua/include/wxlstate.h"
#include "mcDroEvent.h"

#define MAXMRU 10

BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(wxEVT_GUI_MSG, -1)
END_DECLARE_EVENT_TYPES()

class wxGuiMsgEvent: public wxEvent
{
public:
    wxGuiMsgEvent(wxEventType commandType = wxEVT_GUI_MSG, int id = wxID_ANY);
	virtual wxEvent *Clone() const { return new wxGuiMsgEvent(*this); }

	long GetMsg(void) { return(m_msg); }
	long GetParam1(void) { return(m_param1); }
	long GetParam2(void) { return(m_param2); }
	MINSTANCE GetInst(void) { return(m_inst); }
	void SetMsg(long msg) { m_msg = msg; }
	void SetParam1(long param) { m_param1 = param; }
	void SetParam2(long param) { m_param2 = param; }
	void SetInst(MINSTANCE inst) { m_inst = inst; }

protected:
	long   m_msg;
	long   m_param1;
	long   m_param2;
	MINSTANCE m_inst;
};

struct JogKey 
{
	//Struct to show what the KB jog was doing .. 
	bool inc_move;
	bool jogging;
};
typedef void (wxEvtHandler::*wxGuiMsgEventFunction)(wxGuiMsgEvent&);
#define wxGuiMsgEventHandler(func) \
    (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent(wxGuiMsgEventFunction, &func)
#define EVT_GUI_MSG(func)  wx__DECLARE_EVT0(wxEVT_GUI_MSG, wxGuiMsgEventHandler(func))

/*!
 * Includes
 */

////@begin includes
#include "data.h"
#include "wx/frame.h"
#include "wx/notebook.h"
#include "wx/htmllbox.h"
#include "wx/spinctrl.h"
#include "wx/valtext.h"
#include "wx/tglbtn.h"
////@end includes
#include "wx/socket.h"
#include "wx/process.h"

/*!
 * Forward declarations
 */
class FixtureOffsets;
class ToolOffsets;

////@begin forward declarations
class wxMenu;
class mcStatusBar;
class wxNotebook;
class wxGcodeList;
class mcDro;
class wxLed;
class wxSpinCtrl;
class wxToggleButton;
////@end forward declarations
class mcLog;
class mcInformation;

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_WXMACHS 10000
#define ID_FILE_OPEN 10002
#define ID_FILE_CLOSE 10003
#define ID_FILE_EXIT 10004
#define ID_SELDEV 10005
#define ID_CONF_PLUGINS 10006
#define ID_CONFIG_MACH 10007
#define ID_CONFIG_EDIT_PLC 10008
#define ID_OP_AUTO_CALC 10009
#define ID_MENUITEM4 10010
#define ID_MENUEFIXTUREOFFSET 10011
#define ID_MENUTOOLOFFSETS 10012
#define ID_OP_LOG 10013
#define ID_OP_SELECT_LANGUAGE 10173
#define ID_MENU 10014
#define ID_SUPPORT 10210
#define ID_PACKAGE_PROFILE 10211
#define ID_EMAIL_PROFILE 10212
#define ID_INFO 10001
#define ID_ABOUTMACH 10015
#define ID_PANEL 10019
#define ID_NOTEBOOK 10020
#define ID_PANEL10 10021
#define ID_PR_GCODELIST 10022
#define ID_BUTTON46 10023
#define ID_BUTTON47 10024
#define ID_PANEL24 10025
#define ID_RUN_DRO0 10026
#define ID_BUTTON51 10027
#define ID_PANEL23 10028
#define ID_RUN_DRO1 10029
#define ID_BUTTON52 10030
#define ID_PANEL25 10031
#define ID_RUN_DRO2 10032
#define ID_BUTTON53 10033
#define ID_PANEL27 10034
#define ID_RUN_DRO3 10035
#define ID_PANEL3 10091
#define ID_LED10 10036
#define ID_PANEL4 10158
#define ID_LED56 10037
#define ID_PANEL12 10168
#define ID_LED12 10038
#define ID_BUTTON8 10039
#define ID_BTN_DIST_TOGO 10040
#define ID_BTN_MACHINEPOS 10041
#define ID_BUTTON11 10042
#define ID_BUTTON48 10043
#define ID_BUTTON49 10044
#define ID_BUTTON50 10045
#define ID_BUTTON54 10046
#define ID_PANEL11 10047
#define ID_REGEN_TP 10048
#define ID_DISPLAY_MODE 10049
#define ID_JOG_FOLLOW 10050
#define ID_PANEL1 10051
#define ID_BUTTON1 10052
#define ID_BUTTON2 10053
#define ID_PANEL32 10054
#define ID_MDI_DRO0 10055
#define ID_BUTTON3 10056
#define ID_PANEL33 10057
#define ID_MDI_DRO1 10058
#define ID_BUTTON4 10059
#define ID_PANEL34 10060
#define ID_MDI_DRO2 10061
#define ID_BUTTON5 10062
#define ID_PANEL35 10063
#define ID_MDI_DRO3 10064
#define ID_LED55 10065
#define ID_LED57 10066
#define ID_DEREFALL 10067
#define ID_BTN_DIST_TOGO2 10068
#define ID_BTN_MACHINEPOS2 10069
#define ID_VERIFY 10070
#define ID_PANEL8 10071
#define ID_MDI_UP 10072
#define ID_MDI_DOWN 10073
#define ID_MDI_TEXT 10074
#define ID_PANEL2 10075
#define ID_TP_DRO0 10077
#define ID_TP_DRO1 10078
#define ID_TP_DRO2 10079
#define ID_TP_DRO3 10080
#define ID_PANEL7 10081
#define ID_PANEL26 10082
#define ID_LED11 10083
#define ID_LED13 10084
#define ID_LED14 10085
#define ID_LED15 10086
#define ID_LED16 10087
#define ID_LED17 10088
#define ID_LED18 10089
#define ID_LED19 10090
#define ID_LED20 10092
#define ID_LED21 10093
#define ID_LED22 10094
#define ID_LED23 10095
#define ID_LED24 10096
#define ID_LED25 10097
#define ID_LED26 10098
#define ID_LED27 10099
#define ID_LED28 10100
#define ID_LED29 10101
#define ID_LED30 10102
#define ID_LED31 10103
#define ID_LED32 10104
#define ID_LED33 10105
#define ID_LED34 10106
#define ID_LED35 10107
#define ID_LED36 10108
#define ID_LED37 10109
#define ID_LED38 10110
#define ID_LED39 10111
#define ID_LED40 10112
#define ID_LED41 10113
#define ID_LED42 10114
#define ID_LED43 10115
#define ID_LED44 10116
#define ID_LED45 10117
#define ID_LED46 10118
#define ID_LED47 10119
#define ID_LED48 10120
#define ID_LED49 10121
#define ID_LED50 10122
#define ID_LED5 10123
#define ID_LED9 10124
#define ID_LED51 10125
#define ID_LED52 10126
#define ID_LED53 10127
#define ID_LED_DWELL 10128
#define ID_BUTTON30 10129
#define ID_PANEL28 10130
#define ID_BUTTON31 10131
#define ID_PANEL29 10132
#define ID_BUTTON32 10133
#define ID_PANEL30 10134
#define ID_BUTTON33 10135
#define ID_PANEL31 10136
#define ID_SPINCTRL 10137
#define ID_TESTREG0 10138
#define ID_TESTREG1 10139
#define ID_TESTREG2 10140
#define ID_TESTREG3 10141
#define ID_TESTREG4 10142
#define ID_TESTREG5 10143
#define ID_TESTREG6 10144
#define ID_TESTREG7 10145
#define ID_TESTREG8 10146
#define ID_TESTREG9 10147
#define ID_TEXT_STATE 10148
#define ID_TEXT_MODALS 10149
#define ID_CYCLESTART 10150
#define ID_FEEDHOLD 10151
#define ID_STOP 10152
#define ID_RESET 10153
#define ID_ENABLE 10154
#define ID_NOTEBOOK1 10155
#define ID_PANEL6 10156
#define ID_BUTTON17 10157
#define ID_BUTTON22 10159
#define ID_BUTTON23 10160
#define ID_BUTTON24 10161
#define ID_BUTTON25 10162
#define ID_BUTTON27 10163
#define ID_LINENUM_TEXT 10164
#define ID_PANEL5 10165
#define ID_BUTTON16 10166
#define ID_BTN_SINGLE_BLOCK 10167
#define ID_CUSTOM 10169
#define ID_BUTTON18 10170
#define ID_LED 10172
#define ID_BUTTON20 10175
#define ID_LED2 10176
#define ID_BUTTON21 10177
#define ID_LED3 10178
#define ID_LED1 10174
#define ID_BSKIP0 10190
#define ID_BSKIP1 10196
#define ID_BSKIP2 10200
#define ID_BSKIP3 10209
#define ID_PANEL9 10179
#define ID_REGEN_TP2 10180
#define ID_DISPLAYBUTTON 10181
#define ID_BTN_JOG_FOLLOW 10182
#define ID_PANEL13 10183
#define ID_JOG_APOS 10184
#define ID_JOG_ANEG 10185
#define ID_JOG_YPOS 10186
#define ID_JOG_XNEG 10187
#define ID_JOG_XPOS 10188
#define ID_JOG_YNEG 10189
#define ID_JOG_ZPOS 10191
#define ID_JOG_ZNEG 10192
#define ID_JOG_RATE 10193
#define ID_JOG_RATE_TEXT 10194
#define ID_BTN_CYCLE_JOG_STEP 10195
#define ID_BUTTON6 10197
#define ID_LED7 10198
#define ID_LED8 10199
#define ID_JOGFOCUSBUTTON 10201
#define ID_TOOL_NUM 10202
#define ID_LED4 10203
#define ID_TEXTCTRL3 10204
#define ID_TEXTCTRL4 10205
#define ID_BUTTON26 10206
#define ID_REMEMBER_BUTTON 10207
#define ID_RETURN_BUTTON 10208
#define ID_LED6 10171
#define ID_SLIDER 10213
#define ID_SLIDER1 10216
#define ID_SLIDER2 10217
#define ID_SPINDLE_CW 10218
#define ID_LED54 10219
#define SYMBOL_WXMACHS_STYLE wxDEFAULT_FRAME_STYLE|wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX
#define SYMBOL_WXMACHS_TITLE _("Mach")
#define SYMBOL_WXMACHS_IDNAME ID_WXMACHS
#define SYMBOL_WXMACHS_SIZE wxSize(1024, 768)
#define SYMBOL_WXMACHS_POSITION wxDefaultPosition
////@end control identifiers
#define ID_GCODELIST1 10092
#define ID_HTMLLISTBOX1 10004
#define ID_CONFPLUGINS  30000
#define ID_DIAGPLUGINS  32000
#define ID_TIMER	500
#define ID_ENABLE_TIMER	501
#define UNDEFINED   1.0e-20
#define ID_MRUS 31000
#define NUMBJOGINCS 10

/*!
 * wxMachS class declaration
 */



class wxMachS: public wxFrame
{    
	DECLARE_CLASS( wxMachS )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	wxMachS();
	wxMachS( wxWindow* parent, wxWindowID id = SYMBOL_WXMACHS_IDNAME, const wxString& caption = SYMBOL_WXMACHS_TITLE, const wxPoint& pos = SYMBOL_WXMACHS_POSITION, const wxSize& size = SYMBOL_WXMACHS_SIZE, long style = SYMBOL_WXMACHS_STYLE );

	bool Create( wxWindow* parent, wxWindowID id = SYMBOL_WXMACHS_IDNAME, const wxString& caption = SYMBOL_WXMACHS_TITLE, const wxPoint& pos = SYMBOL_WXMACHS_POSITION, const wxSize& size = SYMBOL_WXMACHS_SIZE, long style = SYMBOL_WXMACHS_STYLE );

	/// Destructor
	~wxMachS();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

	/// Transfer data to the window
	virtual bool TransferDataToWindow();

	/// Transfer data from the window
	virtual bool TransferDataFromWindow();

	virtual void OnInitDialog(wxInitDialogEvent &event); 

////@begin wxMachS event handler declarations

	/// wxEVT_CLOSE_WINDOW event handler for ID_WXMACHS
	void OnCloseWindow( wxCloseEvent& event );

	/// wxEVT_CREATE event handler for ID_WXMACHS
	void OnCreate( wxWindowCreateEvent& event );

	/// wxEVT_KEY_DOWN event handler for ID_WXMACHS
	void OnKeyDown( wxKeyEvent& event );

	/// wxEVT_KEY_UP event handler for ID_WXMACHS
	void OnKeyUp( wxKeyEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_FILE_OPEN
	void OnFileOpen( wxCommandEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_FILE_CLOSE
	void OnFileClose( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_FILE_CLOSE
	void OnFileCloseUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_FILE_EXIT
	void OnFileExitClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_SELDEV
	void OnConfigureSeldev( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_SELDEV
	void OnCofigureSeldevUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_CONF_PLUGINS
	void OnConfPluginsClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_CONF_PLUGINS
	void OnConfPluginsUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_CONFIG_MACH
	void OnConfigureMach( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_CONFIG_MACH
	void OnConfigureMachUpdate( wxUpdateUIEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_CONFIG_EDIT_PLC
	void OnConfigEditPlcClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_CONFIG_EDIT_PLC
	void OnConfigEditPlcUpdate( wxUpdateUIEvent& event );

#endif
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_AUTO_CALC
	void OnOpAutoCalcClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_OP_AUTO_CALC
	void OnOpAutoCalcUpdate( wxUpdateUIEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM4
	void OnOperatorEditScript( wxCommandEvent& event );

#endif
#if defined(MACHPRO)
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUEFIXTUREOFFSET
	void OnMenuefixtureoffsetClick( wxCommandEvent& event );

#endif
#if defined(MACHPRO)
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUTOOLOFFSETS
	void OnMenutooloffsetsClick( wxCommandEvent& event );

#endif
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_LOG
	void OnOpLogClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_SELECT_LANGUAGE
	void OnOpSelectLanguageClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_PACKAGE_PROFILE
	void OnPackageProfileClick( wxCommandEvent& event );

#if defined(__WXMSW__)
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_EMAIL_PROFILE
	void OnEmailProfileClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_EMAIL_PROFILE
	void OnEmailProfileUpdate( wxUpdateUIEvent& event );

#endif
	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_INFO
	void OnInfoClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_MENU_SELECTED event handler for ID_ABOUTMACH
	void OnAboutmachClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_LISTBOX_SELECTED event handler for ID_PR_GCODELIST
	void OnGcodelistSelected( wxCommandEvent& event );

	/// wxEVT_COMMAND_LISTBOX_DOUBLECLICKED event handler for ID_PR_GCODELIST
	void OnGcodelistDoubleClicked( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON46
	void OnBtnRefAll( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_BUTTON46
	void OnBtnRefAllUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON47
	void OnBtnZeroX( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON51
	void OnBtnZeroY( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON52
	void OnBtnZeroZ( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON53
	void OnBtnZeroA( wxCommandEvent& event );

#endif
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON8
	void OnGotoZeroClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_DIST_TOGO
	void OnBtnDistTogoClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_MACHINEPOS
	void OnBtnMachineposClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON11
	void OnBtnSoftlimitClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON48
	void OnButtonLoadWizradsClick( wxCommandEvent& event );

	/// wxEVT_SIZE event handler for ID_BUTTON48
	void OnSize( wxSizeEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON49
	void OnNFSWizardsClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON50
	void OnButtonLastWiszardClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON54
	void OnButton54Click( wxCommandEvent& event );

	/// wxEVT_CREATE event handler for ID_PANEL11
	void Onm_runTPCreate( wxWindowCreateEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_REGEN_TP
	void OnRegenTpClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_REGEN_TP
	void OnRegenTpUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_DISPLAY_MODE
	void OnDisplayModeClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_JOG_FOLLOW
	void OnBtnJogFollowClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_DEREFALL
	void OnDerefAll( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_MDI_UP
	void OnMdiUpButtonClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_MDI_DOWN
	void OnMdiDownButtonClick( wxCommandEvent& event );

	/// wxEVT_CHAR event handler for ID_MDI_TEXT
	void OnMdiTextChar( wxKeyEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON30
	void OnRefX( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_BUTTON30
	void OnRefUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON31
	void OnRefY( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON32
	void OnRefZ( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON33
	void OnRefA( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_BUTTON33
	void OnRefAUpdate( wxUpdateUIEvent& event );

#endif
	/// wxEVT_COMMAND_SPINCTRL_UPDATED event handler for ID_SPINCTRL
	void OnSpinctrlUpdated( wxSpinEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_CYCLESTART
	void OnCycleStartClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_CYCLESTART
	void OnButtonUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_FEEDHOLD
	void OnFeedHoldClick( wxCommandEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_FEEDHOLD
	void OnFeedHoldClickDown( wxMouseEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_STOP
	void OnStop( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_RESET
	void OnReset( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_ENABLE
	void OnEnable( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_ENABLE
	void OnEnableUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON17
	void OnBtnEditGcode( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON22
	void OnRecentFileClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON23
	void OnButtonCloseGcodeClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON24
	void OnButtonLoadGcodeClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON27
	void OnButtonRunFromHere( wxCommandEvent& event );

	/// wxEVT_COMMAND_TEXT_UPDATED event handler for ID_LINENUM_TEXT
	void OnLinenumTextTextUpdated( wxCommandEvent& event );

	/// wxEVT_COMMAND_TEXT_ENTER event handler for ID_LINENUM_TEXT
	void OnLinenumTextEnter( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON16
	void OnButtonRewindClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_SINGLE_BLOCK
	void OnBtnSingleBlockClick( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON18
	void OnButtonRevRunClick( wxCommandEvent& event );

#endif
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON20
	void OnButtonOptStopClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON21
	void OnFloodClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_CHECKBOX_CLICKED event handler for ID_BSKIP0
	void OnBskipClick( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_UPDATE_UI event handler for ID_JOG_APOS
	void OnJogUpdateUIPro( wxUpdateUIEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_APOS
	void OnLeftDownAPos( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_APOS
	void OnLeftUpAPos( wxMouseEvent& event );

#endif
#if defined(MACHPRO)
	/// wxEVT_LEFT_DOWN event handler for ID_JOG_ANEG
	void OnLeftDownANeg( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_ANEG
	void OnLeftUpANeg( wxMouseEvent& event );

#endif
	/// wxEVT_UPDATE_UI event handler for ID_JOG_YPOS
	void OnJogUpdateUI( wxUpdateUIEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_YPOS
	void OnLeftDownYPos( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_YPOS
	void OnLeftUpYPos( wxMouseEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_XNEG
	void OnLeftDownXNeg( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_XNEG
	void OnLeftUpXneg( wxMouseEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_XPOS
	void OnLeftDownXPos( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_XPOS
	void OnLeftUpXPos( wxMouseEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_YNEG
	void OnLeftDownYNeg( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_YNEG
	void OnLeftUpYNeg( wxMouseEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_ZPOS
	void OnLeftDownZPos( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_ZPOS
	void OnLeftUpZPos( wxMouseEvent& event );

	/// wxEVT_LEFT_DOWN event handler for ID_JOG_ZNEG
	void OnLeftDownZNeg( wxMouseEvent& event );

	/// wxEVT_LEFT_UP event handler for ID_JOG_ZNEG
	void OnLeftUpZNeg( wxMouseEvent& event );

	/// wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_JOG_RATE
	void OnJogRateUpdated( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_JOG_RATE
	void OnJogRateUpdate( wxUpdateUIEvent& event );

	/// wxEVT_COMMAND_TEXT_UPDATED event handler for ID_JOG_RATE_TEXT
	void OnJogRateTextTextUpdated( wxCommandEvent& event );

	/// wxEVT_COMMAND_TEXT_ENTER event handler for ID_JOG_RATE_TEXT
	void OnJogRateTextEnter( wxCommandEvent& event );

	/// wxEVT_KILL_FOCUS event handler for ID_JOG_RATE_TEXT
	void OnJogRateTextKillFocus( wxFocusEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_CYCLE_JOG_STEP
	void OnBtnCycleJogStepClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON6
	void OnButtonJogModeClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_JOGFOCUSBUTTON
	void OnJogfocusbuttonClick( wxCommandEvent& event );

	/// wxEVT_SET_FOCUS event handler for ID_JOGFOCUSBUTTON
	void OnSetFocus( wxFocusEvent& event );

	/// wxEVT_KILL_FOCUS event handler for ID_JOGFOCUSBUTTON
	void OnKillFocus( wxFocusEvent& event );

	/// wxEVT_COMMAND_TEXT_UPDATED event handler for ID_TOOL_NUM
	void OnToolNumTextUpdated( wxCommandEvent& event );

	/// wxEVT_COMMAND_TEXT_ENTER event handler for ID_TOOL_NUM
	void OnToolNumEnter( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON26
	void OnAutoToolZeroClick( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_REMEMBER_BUTTON
	void OnToolRememberClick( wxCommandEvent& event );

#endif
#if defined(MACHPRO)
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_RETURN_BUTTON
	void OnToolReturnClick( wxCommandEvent& event );

#endif
	/// wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER
	void OnSliderRROUpdated( wxCommandEvent& event );

	/// wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER1
	void OnSliderFROUpdated( wxCommandEvent& event );

#if defined(MACHPRO)
	/// wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER2
	void OnSpindleOverideSliderUpdated( wxCommandEvent& event );

#endif
	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_SPINDLE_CW
	void OnSpindleToggle( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for ID_SPINDLE_CW
	void OnSpindleCwUpdate( wxUpdateUIEvent& event );

////@end wxMachS event handler declarations

	void OnDroEvent( mcDroEvent& event );
	void OnDroEventA( mcDroEvent& event );
	void OnTimer(wxTimerEvent& event);
	void OnEnableTimer(wxTimerEvent& event);
	void OnPlcTimer(wxTimerEvent& event);
	void DoToolPath(void);
	void LoadGcodeFromPath(wxString path,int mInst);
	void OnGuiMsg(wxGuiMsgEvent &event);
	void MoveToRFHStart(void);
	void DoRunFromHere(void);
	void DoFileOpen(void);
	void DoFileClose(void);
	void GetJogIncs(void);
	void SetJogIncs(void);
	void DisplayJogInc(void);
	void GetDefaultModes(void);
	void GetSpindleDelays(void);
	void GetMRU(void);
	void SetMRU(void);
	bool CreateMruMenu(void);
	wxMenuItem *m_mruItems[MAXMRU];
	void OnMruItem(wxCommandEvent& event);
	wxMenu *m_recentMenu;
	wxMenu *m_plugins;
	wxMenu *m_diags;
	void DoJogRate(int rate);
	void DoJogRate(double rate);
	void DoGetLastError(void);
	bool IsApiOk(void) { return(m_apiInit); }
	void ExecuteMdi(void);
	bool ConfigOpen(bool setRecordDefaults = false);
	bool ConfigClose(void);
	void ConfigRestoreFramePosition(wxFrame *window, const wxString &windowName);
	void ConfigSaveFramePosition(wxFrame *window, const wxString &windowName);
	void ConfigRestoreWindowSize(wxWindow *window, const wxString &windowName);
	void ConfigSaveWindowSize(wxWindow *window, const wxString &windowName);
	void ConfigGetExitDontAsk(void);
	void ConfigSetExitDontAsk(void);
	void doGetLicenseData(void);
	wxString m_supportEmail;
	wxString m_supportHttp;
	wxString m_oemProductName;
	wxString m_oemCompanyName;
	wxBitmap m_oemLogo;


////@begin wxMachS member function declarations

	bool GetAutoCalcEnable() const { return m_autoCalcEnable ; }
	void SetAutoCalcEnable(bool value) { m_autoCalcEnable = value ; }

	bool GetEnabled() const { return m_enabled ; }
	void SetEnabled(bool value) { m_enabled = value ; }

	bool GetMdevSelected() const { return m_mdevSelected ; }
	void SetMdevSelected(bool value) { m_mdevSelected = value ; }

	wxString GetProfileName() const { return m_profileName ; }
	void SetProfileName(wxString value) { m_profileName = value ; }

	wxArrayString GetRecentFiles() const { return m_recentFiles ; }
	void SetRecentFiles(wxArrayString value) { m_recentFiles = value ; }

	wxArrayString GetStatusArray() const { return m_statusArray ; }
	void SetStatusArray(wxArrayString value) { m_statusArray = value ; }

	/// Data access
	data& GetData() { return m_data; }
	const data& GetData() const { return m_data; }
	void SetData(const data& data) { m_data = data; }

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end wxMachS member function declarations

	static wxMachS *FindGui(wxWindow *parent);

	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin wxMachS member variables
	wxMenu* m_fileMenu;
	wxMenu* m_ConfigMenu;
	mcStatusBar* m_StatusBar;
	wxNotebook* m_opTabs;
	wxGcodeList* m_PrListBox;
	wxPanel* m_xHomed;
	mcDro* m_RunDRO0;
	wxPanel* m_yHomed;
	mcDro* m_RunDRO1;
	wxPanel* m_zHomed;
	mcDro* m_RunDRO2;
#if defined(MACHPRO)
	wxPanel* m_aHomed;
#endif
#if defined(MACHPRO)
	mcDro* m_RunDRO3;
#endif
	wxLed* m_ledDistToGO;
	wxLed* m_ledMachCoords;
	wxLed* m_ledSoftLimit;
	wxButton* m_btn_Dist_TOGO;
	wxStaticText* m_currentFile;
	wxButton* m_btnLoadWizards;
	wxButton* m_btnNFSWizards;
	wxButton* m_btnLastWizard;
	wxPanel* m_runTP;
	wxButton* m_btnRegenToolpath;
	wxPanel* m_xHomed3;
	mcDro* m_mdiDRO0;
	wxPanel* m_yHomed3;
	mcDro* m_mdiDRO1;
	wxPanel* m_zHomed3;
	mcDro* m_mdiDRO2;
#if defined(MACHPRO)
	wxPanel* m_aHomed3;
#endif
#if defined(MACHPRO)
	mcDro* m_mdiDRO3;
#endif
	wxLed* m_ledDistToGO2;
	wxLed* m_ledMachCoords2;
	wxPanel* m_mdiTP;
	wxTextCtrl* m_MdiCmds;
	wxGcodeList* m_TpListBox;
	mcDro* m_tpDRO0;
	mcDro* m_tpDRO1;
	mcDro* m_tpDRO2;
#if defined(MACHPRO)
	mcDro* m_tpDRO3;
#endif
	wxPanel* m_tpTP;
#if defined(MACHPRO)
	wxLed* m_ledInput1;
#endif
	wxLed* m_ledXpos;
	wxLed* m_ledXneg;
	wxLed* m_ledHomeX;
#if defined(MACHPRO)
	wxLed* m_ledInput2;
#endif
	wxLed* m_ledYpos;
	wxLed* m_ledYneg;
	wxLed* m_ledHomeY;
#if defined(MACHPRO)
	wxLed* m_ledInput3;
#endif
	wxLed* m_ledZpos;
	wxLed* m_ledZneg;
	wxLed* m_ledHomeZ;
#if defined(MACHPRO)
	wxLed* m_ledInput4;
#endif
#if defined(MACHPRO)
	wxLed* m_ledApos;
#endif
#if defined(MACHPRO)
	wxLed* m_ledAneg;
#endif
#if defined(MACHPRO)
	wxLed* m_ledHomeA;
#endif
	wxLed* m_ledDigitize;
#if defined(MACHPRO)
	wxLed* m_ledBpos;
#endif
#if defined(MACHPRO)
	wxLed* m_ledBneg;
#endif
#if defined(MACHPRO)
	wxLed* m_ledHomeB;
#endif
	wxLed* m_ledLimitOverride;
#if defined(MACHPRO)
	wxLed* m_ledCpos;
#endif
#if defined(MACHPRO)
	wxLed* m_ledCneg;
#endif
#if defined(MACHPRO)
	wxLed* m_ledHomeC;
#endif
	wxLed* m_ledEmergency;
#if defined(MACHPRO)
	wxLed* m_ledTiming;
#endif
#if defined(MACHPRO)
	wxLed* m_ledIndex;
#endif
	wxLed* m_ledEnable1;
	wxLed* m_ledEnable2;
	wxLed* m_ledEnable3;
	wxLed* m_ledEnable4;
#if defined(MACHPRO)
	wxLed* m_ledEnable5;
#endif
#if defined(MACHPRO)
	wxLed* m_ledEnable6;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput1;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput2;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput3;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput4;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput5;
#endif
#if defined(MACHPRO)
	wxLed* m_ledOutput6;
#endif
	wxLed* m_ledSpindleOn;
	wxLed* m_ledSpindleFwd;
	wxLed* m_ledSpindleRev;
	wxLed* m_ledCoolantOn;
#if defined(MACHPRO)
	wxLed* m_ledMistOn;
#endif
	wxLed* m_ledDwell;
	wxButton* m_refX;
	wxPanel* m_xHomed2;
	wxButton* m_refY;
	wxPanel* m_yHomed2;
	wxButton* m_refZ;
	wxPanel* m_zHomed2;
#if defined(MACHPRO)
	wxButton* m_refA;
#endif
#if defined(MACHPRO)
	wxPanel* m_aHomed2;
#endif
	wxSpinCtrl* m_spinrange;
	wxTextCtrl* m_testReg0;
	wxTextCtrl* m_testReg1;
	wxTextCtrl* m_testReg2;
	wxTextCtrl* m_testReg3;
	wxTextCtrl* m_testReg4;
	wxTextCtrl* m_testReg5;
	wxTextCtrl* m_testReg6;
	wxTextCtrl* m_testReg7;
	wxTextCtrl* m_testReg8;
	wxTextCtrl* m_testReg9;
	wxTextCtrl* m_machState;
	wxTextCtrl* m_modals;
	wxButton* m_enableControl;
	wxButton* m_btnLoadGcode;
	wxTextCtrl* m_line_number;
	wxPanel* m_runOps;
	wxButton* m_btnSingleBlock;
	wxLed* m_ledSingleBlock;
#if defined(MACHPRO)
	wxLed* m_ledRevRun;
#endif
	wxButton* m_btnOptStop;
	wxLed* m_ledOptStop;
	wxLed* m_ledFlood;
	wxLed* m_ledBlockDelete;
	wxToggleButton* m_blockSkip0;
	wxToggleButton* m_blockSkip1;
	wxToggleButton* m_blockSkip2;
	wxToggleButton* m_blockSkip3;
	wxButton* m_btnOpRegenToolpath;
	wxSlider* m_jogRate;
	wxTextCtrl* m_jogRateText;
	wxButton* m_btnJogMode;
	wxStaticText* m_JogInc;
	wxLed* m_ledJogCont;
	wxLed* m_ledJogStep;
	wxButton* m_jogfocusbutton;
	wxStaticBox* m_toolInfo;
	wxStaticBoxSizer* m_toolInfoS;
	wxTextCtrl* m_tool_num;
	wxLed* m_ledToolChange;
	wxTextCtrl* m_toolDiameter;
	wxTextCtrl* m_toolHeight;
	wxLed* m_ledFeedHold;
	wxSlider* m_RRO_Slider;
	wxSlider* m_FRO_Slider;
#if defined(MACHPRO)
	wxSlider* m_Spindle_Slider;
#endif
	wxButton* m_spindleCW;
	wxLed* m_ledSpindleOn2;
public:
	wxString m_profileName; // The name of the current profile.
	wxArrayString m_statusArray;
private:
	bool m_autoCalcEnable;
	bool m_mdevSelected; // Has a motion device been selected?
protected:
	bool m_enabled;
	wxArrayString m_recentFiles; // Holds the recently opened files.
	/// The data edited by this window
	data m_data;
////@end wxMachS member variables

	wxFileDialog* m_fileDialog;
	wxTimer* m_timer;
	wxTimer* m_enableTimer;
	wxTimer* m_plcTimer;
	wxArrayDouble m_JogIncArray;
	int m_JogIndex;
	int m_Grid_ID;
	wxArrayString m_MdiCmdsArray;
	size_t m_MdiCmdsIndex;
	bool Exit();
	bool CreatePluginMenu(void);
	int ProcessSignal(long sig, long state);
	void OnPluginConfigItem(wxCommandEvent& event);
	void OnPluginConfigItemUpdate(wxUpdateUIEvent& event );
	bool CreateDiagMenu(void);
	void OnPluginDiagItem(wxCommandEvent& event);
	void OnPluginDiagItemUpdate(wxUpdateUIEvent& event );
	void OnLua( wxLuaEvent &event );
	bool ReadPlcScript(const wxString &filename);

	wxArrayInt m_plugIds;
	wxArrayString m_initStrings;
	double m_spindleDelay;
	double m_coolantDelay;
	wxString m_fileExtensions;
	long m_plcInterval;
#ifdef MACHPRO
	double m_mistDelay;
#endif
	double m_remberpos[2];
	bool m_KB_joggingEnabled;
	JogKey m_KBJog[6];
	bool m_estop;
	bool m_enabling;
	wxString m_machDir;
	wxLuaState m_wxlState;
	wxString m_lastWizard;
	FixtureOffsets *m_fixtureOffsets;
	ToolOffsets *m_toolOffsets;
	mcLog *m_log;
	mcState m_state;
	bool m_killPlcTimer;
	wxString m_lastLuaError;
	int m_lastLuaErrorCode;
	wxString m_luaPlcScript;
	bool m_plcScriptDone;
	bool m_apiInit;
	mcInformation *m_infoWindow;
	wxFileConfig  *m_config;
	bool m_exitDontAsk;
};

// This is the handler for process termination events
class MyProcess : public wxProcess
{
public:
	MyProcess(wxWindow *parent, const wxString& cmd, int Inst)
		: wxProcess(parent), m_cmd(cmd)
	{
		m_parent = parent;
		m_Inst = Inst;
	}

	// instead of overriding this virtual function we might as well process the
	// event from it in the frame class - this might be more convenient in some
	// cases
	virtual void OnTerminate(int pid, int status);

protected:
	wxWindow *m_parent;
	int m_Inst;
	wxString m_cmd;
};


#endif
	// _WXMACHS_H_
