/////////////////////////////////////////////////////////////////////////////
// Name:        wxMachs.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     13/02/2012 22:26:03
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".

#ifdef __BORLANDC__
	#pragma hdrstop
#endif

#ifndef WX_PRECOMP
	#endif

////@begin includes
#include "SelDev.h"
#include "mcStatusbar.h"
#include "wx/imaglist.h"
#include "wxgcodelist.h"
#include "ToolPathProgress.h"
////@end includes
#include "runfromhere.h"
#include "wxMachs.h"
#include "led.h"
#include "IoConf.h"
#include "about.h"
#include <mcInformation.h>
#include <ConfigurePlugins.h>
#include <mcLoadWizards.h>
#include "RecentFile.h"
#include "fixtureoffsets.h"
#include "tooloffsets.h"
#include "mcLog.h"
#include "mcDro.h"
#include "ExitConfirm.h"
#include "wxmachapp.h"
#include "ProfileTool.h"

////@begin XPM images
#include "MachGroupLogoOnly-32.xpm"
#include "up.xpm"
#include "down.xpm"
////@end XPM images

#ifdef WIN32
//#include <vld.h>
#endif
#include <minwindef.h>
#include <malloc.h>
#include <tchar.h>
#include <cmath>
#include <cstdio>
#include <cstring>
#include <wxbinddefs.h>
#include <wxlua/wxlstate.h>
#include <wx/anybutton.h>
#include <wx/bookctrl.h>
#include <wx/chartype.h>
#include <wx/colour.h>
#include <wx/defs.h>
#include <wx/event.h>
#include <wx/file.h>
#include <wx/fileconf.h>
#include <wx/filedlg.h>
#include <wx/filefn.h>
#include <wx/filename.h>
#include <wx/font.h>
#include <wx/gdicmn.h>
#include <wx/htmllbox.h>
#include <wx/msgdlg.h>
#include <wx/msw/bitmap.h>
#include <wx/msw/bmpbuttn.h>
#include <wx/msw/button.h>
#include <wx/msw/colour.h>
#include <wx/msw/cursor.h>
#include <wx/msw/filedlg.h>
#include <wx/msw/font.h>
#include <wx/msw/frame.h>
#include <wx/msw/icon.h>
#include <wx/msw/menu.h>
#include <wx/msw/menuitem.h>
#include <wx/msw/notebook.h>
#include <wx/msw/panel.h>
#include <wx/msw/slider.h>
#include <wx/msw/spinctrl.h>
#include <wx/msw/statbox.h>
#include <wx/msw/stattext.h>
#include <wx/msw/textctrl.h>
#include <wx/msw/tglbtn.h>
#include <wx/msw/window.h>
#include <wx/object.h>
#include <wx/platform.h>
#include <wx/process.h>
#include <wx/sizer.h>
#include <wx/slider.h>
#include <wx/socket.h>
#include <wx/spinbutt.h>
#include <wx/spinctrl.h>
#include <wx/stattext.h>
#include <wx/statusbr.h>
#include <wx/string.h>
#include <wx/stringimpl.h>
#include <wx/textctrl.h>
#include <wx/tglbtn.h>
#include <wx/thread.h>
#include <wx/timer.h>
#include <wx/tokenzr.h>
#include <wx/translation.h>
#include <wx/utils.h>
#include <wx/valtext.h>
#include "mcDroEvent.h"
#include <MachAPI.h>
#include <mc_bind.h>

#if defined(_WIN32) || defined(_WIN64)
#ifdef _DEBUG
	#ifndef DBG_NEW
		#define DBG_NEW new ( _NORMAL_BLOCK , __FILE__ , __LINE__ )
		#define new DBG_NEW
	#endif
#endif  // _DEBUG
#endif

static void ConvertUnits(double* value)
{
	int Ival;
	mcCntlGetUnitsDefault(0, &Ival);
	if(Ival == 200) {
		mcCntlGetUnitsCurrent(0, &Ival);
		if(Ival == 210) {
			*value *= 25.4;
		}
	} else {
		mcCntlGetUnitsCurrent(0, &Ival);
		if(Ival == 200) {
			*value /= 25.4;
		}
	}
}

wxGuiMsgEvent::wxGuiMsgEvent( wxEventType commandType, int id )
    : wxEvent( commandType, id )
{
	SetEventType(commandType);
	m_msg = 0;
    m_param1 = 0;
    m_param2 = 0;
	m_inst = 0;
}


/*
 * wxMachS type definition
 */
wxSocketClient *wxSc;
DEFINE_EVENT_TYPE(wxEVT_GUI_MSG)

IMPLEMENT_CLASS( wxMachS, wxFrame )

/*
 * wxMachS event table definition
 */
BEGIN_EVENT_TABLE( wxMachS, wxFrame )

    EVT_LUA_PRINT       (wxID_ANY, wxMachS::OnLua)
    EVT_LUA_ERROR       (wxID_ANY, wxMachS::OnLua)

////@begin wxMachS event table entries
	EVT_CLOSE( wxMachS::OnCloseWindow )
	EVT_WINDOW_CREATE( wxMachS::OnCreate )
	EVT_KEY_DOWN( wxMachS::OnKeyDown )
	EVT_KEY_UP( wxMachS::OnKeyUp )
	EVT_MENU( ID_FILE_OPEN, wxMachS::OnFileOpen )
	EVT_MENU( ID_FILE_CLOSE, wxMachS::OnFileClose )
	EVT_UPDATE_UI( ID_FILE_CLOSE, wxMachS::OnFileCloseUpdate )
	EVT_MENU( ID_FILE_EXIT, wxMachS::OnFileExitClick )
	EVT_MENU( ID_SELDEV, wxMachS::OnConfigureSeldev )
	EVT_UPDATE_UI( ID_SELDEV, wxMachS::OnCofigureSeldevUpdate )
	EVT_MENU( ID_CONF_PLUGINS, wxMachS::OnConfPluginsClick )
	EVT_UPDATE_UI( ID_CONF_PLUGINS, wxMachS::OnConfPluginsUpdate )
	EVT_MENU( ID_CONFIG_MACH, wxMachS::OnConfigureMach )
	EVT_UPDATE_UI( ID_CONFIG_MACH, wxMachS::OnConfigureMachUpdate )
#if defined(MACHPRO)
	EVT_MENU( ID_CONFIG_EDIT_PLC, wxMachS::OnConfigEditPlcClick )
	EVT_UPDATE_UI( ID_CONFIG_EDIT_PLC, wxMachS::OnConfigEditPlcUpdate )
#endif

	EVT_MENU( ID_OP_AUTO_CALC, wxMachS::OnOpAutoCalcClick )
	EVT_UPDATE_UI( ID_OP_AUTO_CALC, wxMachS::OnOpAutoCalcUpdate )
#if defined(MACHPRO)
	EVT_MENU( ID_MENUITEM4, wxMachS::OnOperatorEditScript )
#endif

#if defined(MACHPRO)
	EVT_MENU( ID_MENUEFIXTUREOFFSET, wxMachS::OnMenuefixtureoffsetClick )
#endif

#if defined(MACHPRO)
	EVT_MENU( ID_MENUTOOLOFFSETS, wxMachS::OnMenutooloffsetsClick )
#endif

	EVT_MENU( ID_OP_LOG, wxMachS::OnOpLogClick )
	EVT_MENU( ID_OP_SELECT_LANGUAGE, wxMachS::OnOpSelectLanguageClick )
	EVT_MENU( ID_PACKAGE_PROFILE, wxMachS::OnPackageProfileClick )
#if defined(__WXMSW__)
	EVT_MENU( ID_EMAIL_PROFILE, wxMachS::OnEmailProfileClick )
	EVT_UPDATE_UI( ID_EMAIL_PROFILE, wxMachS::OnEmailProfileUpdate )
#endif

	EVT_MENU( ID_INFO, wxMachS::OnInfoClick )
	EVT_MENU( ID_ABOUTMACH, wxMachS::OnAboutmachClick )
	EVT_LISTBOX( ID_PR_GCODELIST, wxMachS::OnGcodelistSelected )
	EVT_LISTBOX_DCLICK( ID_PR_GCODELIST, wxMachS::OnGcodelistDoubleClicked )
	EVT_BUTTON( ID_BUTTON46, wxMachS::OnBtnRefAll )
	EVT_UPDATE_UI( ID_BUTTON46, wxMachS::OnBtnRefAllUpdate )
	EVT_BUTTON( ID_BUTTON47, wxMachS::OnBtnZeroX )
	EVT_BUTTON( ID_BUTTON51, wxMachS::OnBtnZeroY )
	EVT_BUTTON( ID_BUTTON52, wxMachS::OnBtnZeroZ )
#if defined(MACHPRO)
	EVT_BUTTON( ID_BUTTON53, wxMachS::OnBtnZeroA )
#endif

	EVT_BUTTON( ID_BUTTON8, wxMachS::OnGotoZeroClick )
	EVT_UPDATE_UI( ID_BUTTON8, wxMachS::OnBtnRefAllUpdate )
	EVT_BUTTON( ID_BTN_DIST_TOGO, wxMachS::OnBtnDistTogoClick )
	EVT_BUTTON( ID_BTN_MACHINEPOS, wxMachS::OnBtnMachineposClick )
	EVT_BUTTON( ID_BUTTON11, wxMachS::OnBtnSoftlimitClick )
	EVT_BUTTON( ID_BUTTON48, wxMachS::OnButtonLoadWizradsClick )
	EVT_BUTTON( ID_BUTTON49, wxMachS::OnNFSWizardsClick )
	EVT_BUTTON( ID_BUTTON50, wxMachS::OnButtonLastWiszardClick )
	EVT_BUTTON( ID_BUTTON54, wxMachS::OnButton54Click )
	EVT_BUTTON( ID_REGEN_TP, wxMachS::OnRegenTpClick )
	EVT_UPDATE_UI( ID_REGEN_TP, wxMachS::OnRegenTpUpdate )
	EVT_BUTTON( ID_DISPLAY_MODE, wxMachS::OnDisplayModeClick )
	EVT_BUTTON( ID_JOG_FOLLOW, wxMachS::OnBtnJogFollowClick )
	EVT_BUTTON( ID_BUTTON1, wxMachS::OnBtnRefAll )
	EVT_UPDATE_UI( ID_BUTTON1, wxMachS::OnBtnRefAllUpdate )
	EVT_BUTTON( ID_BUTTON2, wxMachS::OnBtnZeroX )
	EVT_BUTTON( ID_BUTTON3, wxMachS::OnBtnZeroY )
	EVT_BUTTON( ID_BUTTON4, wxMachS::OnBtnZeroZ )
#if defined(MACHPRO)
	EVT_BUTTON( ID_BUTTON5, wxMachS::OnBtnZeroA )
#endif

	EVT_BUTTON( ID_DEREFALL, wxMachS::OnDerefAll )
	EVT_BUTTON( ID_BTN_DIST_TOGO2, wxMachS::OnBtnDistTogoClick )
	EVT_BUTTON( ID_BTN_MACHINEPOS2, wxMachS::OnBtnMachineposClick )
	EVT_BUTTON( ID_MDI_UP, wxMachS::OnMdiUpButtonClick )
	EVT_BUTTON( ID_MDI_DOWN, wxMachS::OnMdiDownButtonClick )
	EVT_LISTBOX( ID_TP_GCODELIST, wxMachS::OnGcodelistSelected )
	EVT_LISTBOX_DCLICK( ID_TP_GCODELIST, wxMachS::OnGcodelistDoubleClicked )
	EVT_BUTTON( ID_BUTTON30, wxMachS::OnRefX )
	EVT_UPDATE_UI( ID_BUTTON30, wxMachS::OnRefUpdate )
	EVT_BUTTON( ID_BUTTON31, wxMachS::OnRefY )
	EVT_UPDATE_UI( ID_BUTTON31, wxMachS::OnRefUpdate )
	EVT_BUTTON( ID_BUTTON32, wxMachS::OnRefZ )
	EVT_UPDATE_UI( ID_BUTTON32, wxMachS::OnRefUpdate )
#if defined(MACHPRO)
	EVT_BUTTON( ID_BUTTON33, wxMachS::OnRefA )
	EVT_UPDATE_UI( ID_BUTTON33, wxMachS::OnRefAUpdate )
#endif

	EVT_SPINCTRL( ID_SPINCTRL, wxMachS::OnSpinctrlUpdated )
	EVT_BUTTON( ID_CYCLESTART, wxMachS::OnCycleStartClick )
	EVT_UPDATE_UI( ID_CYCLESTART, wxMachS::OnButtonUpdate )
	EVT_BUTTON( ID_FEEDHOLD, wxMachS::OnFeedHoldClick )
	EVT_UPDATE_UI( ID_FEEDHOLD, wxMachS::OnButtonUpdate )
	EVT_BUTTON( ID_STOP, wxMachS::OnStop )
	EVT_UPDATE_UI( ID_STOP, wxMachS::OnButtonUpdate )
	EVT_BUTTON( ID_RESET, wxMachS::OnReset )
	EVT_UPDATE_UI( ID_RESET, wxMachS::OnButtonUpdate )
	EVT_BUTTON( ID_ENABLE, wxMachS::OnEnable )
	EVT_UPDATE_UI( ID_ENABLE, wxMachS::OnEnableUpdate )
	EVT_BUTTON( ID_BUTTON17, wxMachS::OnBtnEditGcode )
	EVT_BUTTON( ID_BUTTON22, wxMachS::OnRecentFileClick )
	EVT_BUTTON( ID_BUTTON23, wxMachS::OnButtonCloseGcodeClick )
	EVT_BUTTON( ID_BUTTON24, wxMachS::OnButtonLoadGcodeClick )
	EVT_BUTTON( ID_BUTTON27, wxMachS::OnButtonRunFromHere )
	EVT_TEXT( ID_LINENUM_TEXT, wxMachS::OnLinenumTextTextUpdated )
	EVT_TEXT_ENTER( ID_LINENUM_TEXT, wxMachS::OnLinenumTextEnter )
	EVT_BUTTON( ID_BUTTON16, wxMachS::OnButtonRewindClick )
	EVT_BUTTON( ID_BTN_SINGLE_BLOCK, wxMachS::OnBtnSingleBlockClick )
#if defined(MACHPRO)
	EVT_BUTTON( ID_BUTTON18, wxMachS::OnButtonRevRunClick )
#endif

	EVT_BUTTON( ID_BUTTON20, wxMachS::OnButtonOptStopClick )
	EVT_BUTTON( ID_BUTTON21, wxMachS::OnFloodClick )
	EVT_TOGGLEBUTTON( ID_BSKIP0, wxMachS::OnBskipClick )
	EVT_TOGGLEBUTTON( ID_BSKIP1, wxMachS::OnBskipClick )
	EVT_TOGGLEBUTTON( ID_BSKIP2, wxMachS::OnBskipClick )
	EVT_TOGGLEBUTTON( ID_BSKIP3, wxMachS::OnBskipClick )
	EVT_BUTTON( ID_REGEN_TP2, wxMachS::OnRegenTpClick )
	EVT_UPDATE_UI( ID_REGEN_TP2, wxMachS::OnRegenTpUpdate )
	EVT_BUTTON( ID_DISPLAYBUTTON, wxMachS::OnDisplayModeClick )
	EVT_BUTTON( ID_BTN_JOG_FOLLOW, wxMachS::OnBtnJogFollowClick )
#if defined(MACHPRO)
	EVT_UPDATE_UI( ID_JOG_APOS, wxMachS::OnJogUpdateUIPro )
#endif

#if defined(MACHPRO)
	EVT_UPDATE_UI( ID_JOG_ANEG, wxMachS::OnJogUpdateUIPro )
#endif

	EVT_UPDATE_UI( ID_JOG_YPOS, wxMachS::OnJogUpdateUI )
	EVT_UPDATE_UI( ID_JOG_XNEG, wxMachS::OnJogUpdateUI )
	EVT_UPDATE_UI( ID_JOG_XPOS, wxMachS::OnJogUpdateUI )
	EVT_UPDATE_UI( ID_JOG_YNEG, wxMachS::OnJogUpdateUI )
	EVT_UPDATE_UI( ID_JOG_ZPOS, wxMachS::OnJogUpdateUI )
	EVT_UPDATE_UI( ID_JOG_ZNEG, wxMachS::OnJogUpdateUI )
	EVT_SLIDER( ID_JOG_RATE, wxMachS::OnJogRateUpdated )
	EVT_UPDATE_UI( ID_JOG_RATE, wxMachS::OnJogRateUpdate )
	EVT_TEXT( ID_JOG_RATE_TEXT, wxMachS::OnJogRateTextTextUpdated )
	EVT_TEXT_ENTER( ID_JOG_RATE_TEXT, wxMachS::OnJogRateTextEnter )
	EVT_BUTTON( ID_BTN_CYCLE_JOG_STEP, wxMachS::OnBtnCycleJogStepClick )
	EVT_BUTTON( ID_BUTTON6, wxMachS::OnButtonJogModeClick )
	EVT_BUTTON( ID_JOGFOCUSBUTTON, wxMachS::OnJogfocusbuttonClick )
	EVT_TEXT( ID_TOOL_NUM, wxMachS::OnToolNumTextUpdated )
	EVT_TEXT_ENTER( ID_TOOL_NUM, wxMachS::OnToolNumEnter )
	EVT_BUTTON( ID_BUTTON26, wxMachS::OnAutoToolZeroClick )
#if defined(MACHPRO)
	EVT_BUTTON( ID_REMEMBER_BUTTON, wxMachS::OnToolRememberClick )
#endif

#if defined(MACHPRO)
	EVT_BUTTON( ID_RETURN_BUTTON, wxMachS::OnToolReturnClick )
#endif

	EVT_SLIDER( ID_SLIDER, wxMachS::OnSliderRROUpdated )
	EVT_SLIDER( ID_SLIDER1, wxMachS::OnSliderFROUpdated )
#if defined(MACHPRO)
	EVT_SLIDER( ID_SLIDER2, wxMachS::OnSpindleOverideSliderUpdated )
#endif

	EVT_BUTTON( ID_SPINDLE_CW, wxMachS::OnSpindleToggle )
	EVT_UPDATE_UI( ID_SPINDLE_CW, wxMachS::OnSpindleCwUpdate )
////@end wxMachS event table entries
	EVT_GUI_MSG(wxMachS::OnGuiMsg)
END_EVENT_TABLE()

wxMachS *gui = NULL;

static wxMutex s_MutextLockingTheMsgHandler;
// Function to handle messages from the core.
MCP_API int MCP_APIENTRY mcGUIMsg(MINSTANCE mInst, long msg, MCPARAM param1, MCPARAM param2)
{
//	wxString dbg;
//	dbg.Printf(wxT("In mcGUIMsg() Id: %d, State: %d"), wparam, lparam);
//	wxMessageBox(dbg, wxT("I/O test"));
	wxMutexLocker lock(s_MutextLockingTheMsgHandler);
	wxUnusedVar(mInst);
	if (gui == NULL) {
		return(0);
	}
	
	wxGuiMsgEvent event;
	event.SetMsg(msg);
	event.SetParam1(param1);
	event.SetParam2(param2);
	event.SetInst(mInst);
#define MSG_USES_EVENTS
#ifdef MSG_USES_EVENTS
	gui->GetEventHandler()->AddPendingEvent(event);
#else
	gui->OnGuiMsg(event);
#endif
	return(0);
}

/*
 * wxMachS constructors
 */
wxMachS::wxMachS()
{
	Init();
}

wxMachS::wxMachS( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create( parent, id, caption, pos, size, style );
}

/*
 * wxMachS creator
 */
bool wxMachS::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin wxMachS creation
	wxFrame::Create( parent, id, caption, pos, size, style );

	this->SetBackgroundColour(wxColour(230, 230, 230));
	CreateControls();
	SetIcon(GetIconResource(wxT("MachGroupLogoOnly-32.xpm")));
	Centre();
////@end wxMachS creation
#ifdef INDUSTRIAL
	SetIcon(GetIconResource(wxT("Mach_Industrial-32.xpm")));
#endif

	if (ConfigOpen(true)) {
		ConfigRestoreFramePosition(this, wxT("MainFrame"));
		ConfigGetExitDontAsk();
		ConfigClose();
	}
	return(true);
}

bool wxMachS::CreateMruMenu(void)
{
	static int firsttime = true;
	if (firsttime && m_recentFiles.GetCount() > 0) {
		m_recentMenu = new wxMenu();
		m_fileMenu->Insert(1, wxID_ANY, _("Recent Files"), m_recentMenu, wxEmptyString);
		firsttime = false;
		for (int idx = 0; idx < MAXMRU; idx++) {
			m_mruItems[idx] = NULL;
		}
	}
	for (int idx = 0; idx < MAXMRU; idx++) {
		if (m_mruItems[idx] != NULL) {
			Disconnect(ID_MRUS + idx, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(wxMachS::OnMruItem));
			m_recentMenu->Remove(m_mruItems[idx]);
			delete m_mruItems[idx];
			m_mruItems[idx] = NULL;
		}
	}
	for (size_t idx = 0; idx < m_recentFiles.GetCount(); idx++) {
		wxString fn = m_recentFiles[idx];
		m_mruItems[idx] = m_recentMenu->Append(ID_MRUS + idx, fn, wxEmptyString, wxITEM_NORMAL);
		Connect(ID_MRUS + idx, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(wxMachS::OnMruItem));
	}
	return(true);
}

void wxMachS::OnMruItem(wxCommandEvent& event)
{
	int id = event.GetId();
	wxMenuItem *mi = m_mruItems[id - ID_MRUS];
	wxString fp = mi->GetItemLabelText();
	DoFileClose();
	LoadGcodeFromPath(fp, 0);

	wxUnusedVar(event);
}

bool wxMachS::CreatePluginMenu(void)
{
	HMCPLUG hPlug = 0;
	pluginfo_t pluginf;
	int rc = 0;
	bool found = false;

	m_plugins = new wxMenu;

	while (mcPluginGetNextHandle(PLUG_TYPE_CONFIG, hPlug, &hPlug) == MERROR_NOERROR) {
		rc = mcPluginGetInfoStruct(hPlug, &pluginf);
		if (rc == MERROR_NOERROR) {
			found = true;
			m_plugins->Append(ID_CONFPLUGINS + pluginf.plugId, wxString::FromUTF8(pluginf.plugDesc), wxEmptyString, wxITEM_NORMAL);
			Connect(ID_CONFPLUGINS + pluginf.plugId, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(wxMachS::OnPluginConfigItem));
			Connect(ID_CONFPLUGINS + pluginf.plugId, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(wxMachS::OnPluginConfigItemUpdate));
		}
	}
	
	if (found) {
		m_ConfigMenu->Append(ID_CONFPLUGINS + 999, _("&Plugins..."), m_plugins);
	} else {
		delete m_plugins;
		m_plugins = NULL;
	}
	
	return(true);
}

bool wxMachS::CreateDiagMenu(void)
{
	HMCPLUG hPlug = 0;
	pluginfo_t pluginf;
	int rc = 0;
	bool found = false;

	m_diags = new wxMenu;

	while (mcPluginGetNextHandle(PLUG_TYPE_DIAG, hPlug, &hPlug) == MERROR_NOERROR) {
		rc = mcPluginGetInfoStruct(hPlug, &pluginf);
		if (rc == MERROR_NOERROR) {
			found = true;
			if (pluginf.plugEnabled != 0) {
				m_diags->Append(ID_DIAGPLUGINS + pluginf.plugId, wxString::FromUTF8(pluginf.plugDesc), wxEmptyString, wxITEM_NORMAL);
				Connect(ID_DIAGPLUGINS + pluginf.plugId, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(wxMachS::OnPluginDiagItem));
				Connect(ID_DIAGPLUGINS + pluginf.plugId, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(wxMachS::OnPluginDiagItemUpdate));
			}
		}
	}
	
	if (found) {
		this->GetMenuBar()->Insert(2, m_diags, _("&Diagnostic"));
	} else {
		delete m_diags;
		m_diags = NULL;
	}
	
	return(true);
}

/*
 * wxMachS destructor
 */
wxMachS::~wxMachS()
{
	m_killPlcTimer = true;
	if (m_timer != NULL) {
		delete m_timer;
	}
	if (m_enableTimer != NULL) {
		delete m_enableTimer;
	}
	while (!m_plcScriptDone) {
		wxMilliSleep(10);
	}
	if (m_plcTimer != NULL) {
		delete m_plcTimer;
	}

	if (m_config) {
		m_config->Flush();
		delete m_config;
	}


#if 0 // Don't think I have to delete these...
	if (m_fixtureOffsets) {
		m_fixtureOffsets->Destroy();
	}

	for (int idx = 0; idx < MAXMRU; idx++) {
		if (this->m_mruItems[idx] != NULL) {
			delete m_mruItems[idx];
			m_mruItems[idx] = NULL;
		}
	}
#endif
}

bool wxMachS::Exit()
{
	if (!m_exitDontAsk) {
		ExitConfirm *ec = new ExitConfirm(this);
		int rc = ec->ShowModal();
		if (rc == wxID_NO) {
			ec->Destroy();
			return(false);
		}
		m_exitDontAsk = ec->GetDontShow();
		ec->Destroy();
	}		
	if (ConfigOpen()) {
		ConfigSetExitDontAsk();
		ConfigSaveFramePosition(this, wxT("MainFrame"));
		ConfigClose();
	}
	mcCntlEnable(0, false);
	mcToolSaveFile(0);
	mcFixtureSaveFile(0);
	SetMRU();
	SetJogIncs();
	mcProfileWriteString(0, "Preferences", "LastWizard", wxToChar(m_lastWizard));
	// Operator Auto Calc
	mcProfileWriteInt(0, "Preferences", "AutoCalc",  GetAutoCalcEnable() ? 1 : 0);

	Hide();
	m_timer->Stop();
	m_enableTimer->Stop();
	mcCntlCleanup(0);
	return(true);
}

int wxMachS::ProcessSignal(long sig, long state)
{
	wxString dbg;
	dbg.Printf(wxT("In wxMach::ProcessSignal() #1 Id:%d, State:%d"), sig, state);
	switch (sig) {
	case OSIG_XLIMITPLUS:
		this->m_ledXpos->Enable(state == 1 ? true : false);
		break;
	case OSIG_XLIMITMINUS:
		this->m_ledXneg->Enable(state == 1 ? true : false);
		break;
	case OSIG_XHOME:
		this->m_ledHomeX->Enable(state == 1 ? true : false);
		break;
	case OSIG_YLIMITPLUS:
		this->m_ledYpos->Enable(state == 1 ? true : false);
		break;
	case OSIG_YLIMITMINUS:
		this->m_ledYneg->Enable(state == 1 ? true : false);
		break;
	case OSIG_YHOME:
		this->m_ledHomeY->Enable(state == 1 ? true : false);
		break;
	case OSIG_ZLIMITPLUS:
		this->m_ledZpos->Enable(state == 1 ? true : false);
		break;
	case OSIG_ZLIMITMINUS:
		this->m_ledZneg->Enable(state == 1 ? true : false);
		break;
	case OSIG_ZHOME:
		this->m_ledHomeZ->Enable(state == 1 ? true : false);
		break;
	case OSIG_ALIMITPLUS:
#ifdef MACHPRO
		this->m_ledApos->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_ALIMITMINUS:
#ifdef MACHPRO
		this->m_ledAneg->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_AHOME:
#ifdef MACHPRO
		this->m_ledHomeA->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_BLIMITPLUS:
#ifdef MACHPRO
		this->m_ledBpos->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_BLIMITMINUS:
#ifdef MACHPRO
		this->m_ledBneg->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_BHOME:
#ifdef MACHPRO
		this->m_ledHomeB->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_CLIMITPLUS:
#ifdef MACHPRO
		this->m_ledCpos->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_CLIMITMINUS:
#ifdef MACHPRO
		this->m_ledCneg->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_CHOME:
#ifdef MACHPRO
		this->m_ledHomeC->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_INPUT0:
		dbg.Printf(wxT("In wxMach::ProcessSignal() #2 Id:%d, State:%d"), sig, state);
#ifdef MACHPRO
		this->m_ledInput1->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_INPUT1:
#ifdef MACHPRO
		this->m_ledInput2->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_INPUT2:
#ifdef MACHPRO
		this->m_ledInput3->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_INPUT3:
#ifdef MACHPRO
		this->m_ledInput4->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_PROBE:
	case ISIG_PROBE1:
	case ISIG_PROBE2:
	case ISIG_PROBE3:
	case ISIG_PROBE4:
	case ISIG_PROBE5:
	case ISIG_PROBE6:
	case ISIG_PROBE7:
	case ISIG_PROBE8:
	case ISIG_PROBE9:
		this->m_ledDigitize->Enable(state == 1 ? true : false);
		break;
	case ISIG_INDEX:
#ifdef MACHPRO
		this->m_ledIndex->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_LIMITOVER:
		this->m_ledLimitOverride->Enable(state == 1 ? true : false);
		break;
	case ISIG_EMERGENCY:
		m_estop = (state == 1) ? true : false;
		this->m_ledEmergency->Enable(m_estop);
		if (m_estop) {
			wxString msg = _("E-Stop is in effect.  Clear the E-Stop condition.");
			mcCntlSetLastError(0, wxToChar(msg));
		}
		break;
	case ISIG_THCON:
	case ISIG_THCUP:
	case ISIG_THCDOWN:
	case ISIG_TIMING:
#ifdef MACHPRO
		this->m_ledTiming->Enable(state == 1 ? true : false);
#endif
		break;
	case ISIG_JOGXP:
	case ISIG_JOGXN:
	case ISIG_JOGYP:
	case ISIG_JOGYN:
	case ISIG_JOGZP:
	case ISIG_JOGZN:
	case ISIG_JOGAP:
	case ISIG_JOGAN:
	case ISIG_JOGOB1P:
	case ISIG_JOGOB1N:
	case ISIG_JOGOB2P:
	case ISIG_JOGOB2N:
	case ISIG_JOGOB3P:
	case ISIG_JOGOB3N:
	case ISIG_JOGOB4P:
	case ISIG_JOGOB4N:
	case ISIG_JOGOB5P:
	case ISIG_JOGOB5N:
	case ISIG_JOGOB6P:
	case ISIG_JOGOB6N:
	case ISIG_SPINDLE_AT_SPEED:
	case ISIG_SPINDLE_AT_ZERO:
		break;
		// Outputs
	case OSIG_BLOCK_DELETE:
		this->m_ledBlockDelete->Enable(state == 1 ? true : false);
		break;
	case OSIG_FEEDHOLD:
		this->m_ledFeedHold->Enable(state == 1 ? true : false);
		break;
	case OSIG_DIGTRIGGER:
		break;
	case OSIG_ENABLE0:
		this->m_ledEnable1->Enable(state == 1 ? true : false);
		break;
	case OSIG_ENABLE1:
		this->m_ledEnable2->Enable(state == 1 ? true : false);
		break;
	case OSIG_ENABLE2:
		this->m_ledEnable3->Enable(state == 1 ? true : false);
		break;
	case OSIG_ENABLE3:
		this->m_ledEnable4->Enable(state == 1 ? true : false);
		break;
	case OSIG_ENABLE4:
#ifdef MACHPRO
		this->m_ledEnable5->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_ENABLE5:
#ifdef MACHPRO
		this->m_ledEnable6->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT0:
#ifdef MACHPRO
		this->m_ledOutput1->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT1:
#ifdef MACHPRO
		this->m_ledOutput2->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT2:
#ifdef MACHPRO
		this->m_ledOutput3->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT3:
#ifdef MACHPRO
		this->m_ledOutput4->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT4:
#ifdef MACHPRO
		this->m_ledOutput5->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_OUTPUT5:
#ifdef MACHPRO
		this->m_ledOutput6->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_CHARGE:
	case OSIG_CHARGE2:
	case OSIG_CURRENTHILOW:
	case OSIG_OUTPUT7:
	case OSIG_OUTPUT8:
	case OSIG_OUTPUT9:
	case OSIG_OUTPUT10:
	case OSIG_OUTPUT11:
	case OSIG_OUTPUT12:
	case OSIG_OUTPUT13:
	case OSIG_OUTPUT14:
	case OSIG_OUTPUT15:
	case OSIG_OUTPUT16:
	case OSIG_OUTPUT17:
	case OSIG_OUTPUT18:
	case OSIG_OUTPUT19:
	case OSIG_OUTPUT20:
		break;
	case OSIG_SPINDLEON:
		this->m_ledSpindleOn->Enable(state == 1 ? true : false);
		this->m_ledSpindleOn2->Enable(state == 1 ? true : false);
		break;
	case OSIG_SPINDLEFWD:
		this->m_ledSpindleFwd->Enable(state == 1 ? true : false);
		this->m_ledSpindleOn2->Enable(state == 1 ? true : false);
		break;
	case OSIG_SPINDLEREV:
		this->m_ledSpindleRev->Enable(state == 1 ? true : false);
		this->m_ledSpindleOn2->Enable(state == 1 ? true : false);
		break;
	case OSIG_COOLANTON:
		this->m_ledCoolantOn->Enable(state == 1 ? true : false);
		this->m_ledFlood->Enable(state == 1 ? true : false);
		break;
	case OSIG_MISTON:
#ifdef MACHPRO
		this->m_ledMistOn->Enable(state == 1 ? true : false);
#endif
		break;
	case OSIG_SINGLE_BLOCK:
		m_ledSingleBlock->Enable(state == 1 ? true : false);
		break;
	case OSIG_MACHINE_ENABLED:
		break;
	case OSIG_DWELL:
		m_ledDwell->Enable(state == 1 ? true : false);
		break;
	case OSIG_HOMED_X:
		m_xHomed->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_xHomed->Refresh();
		m_xHomed2->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_xHomed2->Refresh();
		m_xHomed3->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_xHomed3->Refresh();
		break;
	case OSIG_HOMED_Y:
		m_yHomed->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_yHomed->Refresh();
		m_yHomed2->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_yHomed2->Refresh();
		m_yHomed3->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_yHomed3->Refresh();
		break;
	case OSIG_HOMED_Z:
		m_zHomed->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_zHomed->Refresh();
		m_zHomed2->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_zHomed2->Refresh();
		m_zHomed3->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_zHomed3->Refresh();
		break;
	case OSIG_HOMED_A:
#ifdef MACHPRO
		m_aHomed->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_aHomed->Refresh();
		m_aHomed2->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_aHomed2->Refresh();
		m_aHomed3->SetBackgroundColour(state == 1 ? wxColor(wxT("#00C000")) : wxColor(wxT("#FF0000")));
		m_aHomed3->Refresh();
#endif
		break;
	case OSIG_HOMED_B:
	case OSIG_HOMED_C:
		break;

	}
	return(0);
}

/*
 * Member initialisation
 */
void wxMachS::Init()
{
////@begin wxMachS member initialisation
	m_StatusBar = NULL;
	m_opTabs = NULL;
	m_PrListBox = NULL;
	m_RunDRO0 = NULL;
	m_RunDRO1 = NULL;
	m_RunDRO2 = NULL;
#ifdef MACHPRO
	m_RunDRO3 = NULL;
#endif
	m_currentFile = NULL;
	m_btnLoadWizards = NULL;
	m_btnNFSWizards = NULL;
	m_btnLastWizard = NULL;
	m_runTP = NULL;
	m_btnRegenToolpath = NULL;
	m_mdiDRO0 = NULL;
	m_mdiDRO1 = NULL;
	m_mdiDRO2 = NULL;
#ifdef MACHPRO
	m_mdiDRO3 = NULL;
#endif
	m_ledMachCoords = NULL;
	m_mdiTP = NULL;
	m_MdiCmds = NULL;
	m_TpListBox = NULL;
	m_tpDRO0 = NULL;
	m_tpDRO1 = NULL;
	m_tpDRO2 = NULL;
#ifdef MACHPRO
	m_tpDRO3 = NULL;
#endif
	m_tpTP = NULL;
	m_runOps = NULL;
	m_btnSingleBlock = NULL;
	m_ledSingleBlock = NULL;
#ifdef MACHPRO
	m_ledRevRun = NULL;
#endif
	m_ledBlockDelete = NULL;
	m_btnOptStop = NULL;
	m_ledOptStop = NULL;
	m_ledFlood = NULL;
	m_btnLoadGcode = NULL;
	m_btnOpRegenToolpath = NULL;
	m_btnJogMode = NULL;
	m_JogInc = NULL;
	m_ledJogCont    =    NULL;
	m_ledJogStep = NULL;
	m_RRO_Slider = NULL;
	m_FRO_Slider = NULL;
////@end wxMachS member initialization
	m_apiInit = false;
	m_fileDialog = NULL;
	m_timer = NULL;
	m_enableTimer = NULL;
	m_JogIndex = 0;
	m_Grid_ID = 0;
	m_MdiCmdsIndex = 0;
	m_spindleDelay = 0;
	m_coolantDelay = 0;
	m_plcInterval = 0;
	m_enabled = false;
#ifdef MACHPRO
	m_mistDelay = 0;
#endif
	m_remberpos[0] = 0;
	m_remberpos[1] = 0;
	m_KB_joggingEnabled = false;
	m_state = (mcState) 0;
	m_killPlcTimer = false;
	m_lastLuaErrorCode = 0;
	m_plcScriptDone = true;
	m_infoWindow = NULL;

	m_fixtureOffsets = NULL;
	m_toolOffsets = NULL;
	m_estop = false;
	m_enabling = false;
	m_plcTimer = NULL;
	gui = this;
	m_JogIndex = 0;
	m_config = NULL;
	for (int idx = 0; idx < MAXMRU; idx++) {
		m_mruItems[idx] = NULL;
	}
	for (int i=0; i<6; i++) {
		m_KBJog[i].jogging = false;
		m_KBJog[i].inc_move = false;
	}

#if 1
	WXLUA_IMPLEMENT_BIND_ALL;
	wxLuaBinding_mc_init();

    // When this function returns wxApp:MainLoop() will be called by wxWidgets
    // and so we want the Lua code wx.wxGetApp:MainLoop() to not
    // prematurely start it.
    //wxLuaState::sm_wxAppMainLoop_will_run = true;
	
	m_wxlState = wxLuaState(this, wxID_ANY);

	if (!m_wxlState.Ok()) {
        return;
	}
#endif

}

/*
 * Control creation for wxMachS
 */
void wxMachS::CreateControls()
{    
////@begin wxMachS content construction
	wxMachS* itemFrame1 = this;

	wxMenuBar* menuBar = new wxMenuBar;
	m_fileMenu = new wxMenu;
	m_fileMenu->Append(ID_FILE_OPEN, _("&Open"), wxEmptyString, wxITEM_NORMAL);
	m_fileMenu->Append(ID_FILE_CLOSE, _("&Close"), wxEmptyString, wxITEM_NORMAL);
	m_fileMenu->AppendSeparator();
	m_fileMenu->Append(ID_FILE_EXIT, _("E&xit"), wxEmptyString, wxITEM_NORMAL);
	menuBar->Append(m_fileMenu, _("&File"));
	m_ConfigMenu = new wxMenu;
	m_ConfigMenu->Append(ID_SELDEV, _("&Set Motion Device..."), wxEmptyString, wxITEM_NORMAL);
	m_ConfigMenu->Append(ID_CONF_PLUGINS, _("&Plugins..."), wxEmptyString, wxITEM_NORMAL);
	m_ConfigMenu->Append(ID_CONFIG_MACH, _("&Mach..."), wxEmptyString, wxITEM_NORMAL);
#if defined(MACHPRO)
	m_ConfigMenu->Append(ID_CONFIG_EDIT_PLC, _("&Edit PLC script..."), wxEmptyString, wxITEM_NORMAL);
#endif
	menuBar->Append(m_ConfigMenu, _("Configure"));
	wxMenu* itemMenu13 = new wxMenu;
	itemMenu13->Append(ID_OP_AUTO_CALC, _("DRO &Auto Calc"), wxEmptyString, wxITEM_CHECK);
	itemMenu13->AppendSeparator();
#if defined(MACHPRO)
	itemMenu13->Append(ID_MENUITEM4, _("&Edit/Debug Script"), wxEmptyString, wxITEM_NORMAL);
#endif
#if defined(MACHPRO)
	itemMenu13->Append(ID_MENUEFIXTUREOFFSET, _("Fixture Offsets"), wxEmptyString, wxITEM_NORMAL);
#endif
#if defined(MACHPRO)
	itemMenu13->Append(ID_MENUTOOLOFFSETS, _("Tool Offsets"), wxEmptyString, wxITEM_NORMAL);
#endif
	itemMenu13->Append(ID_OP_LOG, _("Logging..."), wxEmptyString, wxITEM_NORMAL);
	itemMenu13->Append(ID_OP_SELECT_LANGUAGE, _("Select &Language..."), wxEmptyString, wxITEM_NORMAL);
	menuBar->Append(itemMenu13, _("&Operator"));
	wxMenu* itemMenu21 = new wxMenu;
	wxMenu* itemMenu22 = new wxMenu;
	itemMenu22->Append(ID_PACKAGE_PROFILE, _("Package Current Profile..."), wxEmptyString, wxITEM_NORMAL);
#if defined(__WXMSW__)
	itemMenu22->Append(ID_EMAIL_PROFILE, _("Email Current Profile..."), wxEmptyString, wxITEM_NORMAL);
#endif
	itemMenu21->Append(ID_SUPPORT, _("Menu"), itemMenu22);
	itemMenu21->AppendSeparator();
	itemMenu21->Append(ID_INFO, _("&System Information"), wxEmptyString, wxITEM_NORMAL);
	itemMenu21->AppendSeparator();
	itemMenu21->Append(ID_ABOUTMACH, _("About"), wxEmptyString, wxITEM_NORMAL);
	menuBar->Append(itemMenu21, _("Help"));
	itemFrame1->SetMenuBar(menuBar);

	m_StatusBar = new mcStatusBar( itemFrame1, ID_STATUSBAR, wxST_SIZEGRIP|wxSIMPLE_BORDER );
	m_StatusBar->SetFieldsCount(5);
	m_StatusBar->SetStatusText(wxEmptyString, 0);
	m_StatusBar->SetStatusText(wxEmptyString, 1);
	m_StatusBar->SetStatusText(_("Profile:"), 2);
	m_StatusBar->SetStatusText(_("Feed Rate:"), 3);
	m_StatusBar->SetStatusText(_("RPM:"), 4);
	int m_StatusBarWidths[5];
	m_StatusBarWidths[0] = -2;
	m_StatusBarWidths[1] = -8;
	m_StatusBarWidths[2] = -3;
	m_StatusBarWidths[3] = -2;
	m_StatusBarWidths[4] = -2;
	m_StatusBar->SetStatusWidths(5, m_StatusBarWidths);
	itemFrame1->SetStatusBar(m_StatusBar);

	wxPanel* itemPanel32 = new wxPanel( itemFrame1, ID_PANEL, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER|wxTAB_TRAVERSAL );

	wxBoxSizer* itemBoxSizer33 = new wxBoxSizer(wxVERTICAL);
	itemPanel32->SetSizer(itemBoxSizer33);

	wxBoxSizer* itemBoxSizer34 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer33->Add(itemBoxSizer34, 2, wxGROW|wxALL, 0);

	m_opTabs = new wxNotebook( itemPanel32, ID_NOTEBOOK, wxDefaultPosition, wxSize(100, 100), wxBK_DEFAULT );

	wxPanel* itemPanel36 = new wxPanel( m_opTabs, ID_PANEL10, wxDefaultPosition, wxSize(100, 100), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel36->SetName(wxT("Program Run"));
	itemPanel36->SetBackgroundColour(wxColour(255, 255, 255));
	wxBoxSizer* itemBoxSizer37 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel36->SetSizer(itemBoxSizer37);

	wxBoxSizer* itemBoxSizer38 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer37->Add(itemBoxSizer38, 30, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer39 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer38->Add(itemBoxSizer39, 1, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);
	wxStaticBox* itemStaticBoxSizer40Static = new wxStaticBox(itemPanel36, wxID_ANY, _("G code"));
	wxStaticBoxSizer* itemStaticBoxSizer40 = new wxStaticBoxSizer(itemStaticBoxSizer40Static, wxVERTICAL);
	itemBoxSizer39->Add(itemStaticBoxSizer40, 5, wxGROW|wxLEFT|wxRIGHT, 5);
	m_PrListBox = new wxGcodeList( itemStaticBoxSizer40->GetStaticBox(), ID_PR_GCODELIST, wxDefaultPosition, wxSize(50, 50), wxHLB_DEFAULT_STYLE );
	itemStaticBoxSizer40->Add(m_PrListBox, 1, wxGROW|wxALL|wxFIXED_MINSIZE, 0);

	wxStaticBox* itemStaticBoxSizer42Static = new wxStaticBox(itemPanel36, wxID_ANY, _("Axis Control"));
	wxStaticBoxSizer* itemStaticBoxSizer42 = new wxStaticBoxSizer(itemStaticBoxSizer42Static, wxVERTICAL);
	itemBoxSizer39->Add(itemStaticBoxSizer42, 10, wxGROW, 5);
	wxBoxSizer* itemBoxSizer43 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer42->Add(itemBoxSizer43, 4, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer44 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer43->Add(itemBoxSizer44, 1, wxGROW|wxALL, 2);
	wxButton* itemButton45 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON46, _("Ref\nAll\nHome"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer44->Add(itemButton45, 1, wxGROW|wxTOP|wxBOTTOM, 10);

	wxBoxSizer* itemBoxSizer46 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer43->Add(itemBoxSizer46, 4, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);
	wxBoxSizer* itemBoxSizer47 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer46->Add(itemBoxSizer47, 1, wxGROW|wxALL, 2);
	wxButton* itemButton48 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON47, _("Zero\nX"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer47->Add(itemButton48, 1, wxGROW|wxRIGHT|wxTOP|wxBOTTOM, 2);

	m_xHomed = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL24, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_xHomed->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer47->Add(m_xHomed, 0, wxGROW|wxTOP|wxBOTTOM, 2);

	m_RunDRO0 = new mcDro( itemStaticBoxSizer42->GetStaticBox(), ID_RUN_DRO0, wxDefaultPosition, wxSize(50, 10), wxSUNKEN_BORDER );
	m_RunDRO0->SetForegroundColour(wxColour(0, 255, 0));
	m_RunDRO0->SetBackgroundColour(wxColour(0, 0, 0));
	m_RunDRO0->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer47->Add(m_RunDRO0, 3, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer51 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer46->Add(itemBoxSizer51, 1, wxGROW|wxALL, 2);
	wxButton* itemButton52 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON51, _("Zero\nY"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer51->Add(itemButton52, 1, wxGROW|wxRIGHT|wxTOP|wxBOTTOM, 2);

	m_yHomed = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL23, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_yHomed->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer51->Add(m_yHomed, 0, wxGROW|wxTOP|wxBOTTOM, 2);

	m_RunDRO1 = new mcDro( itemStaticBoxSizer42->GetStaticBox(), ID_RUN_DRO1, wxDefaultPosition, wxSize(50, 10), wxSUNKEN_BORDER );
	m_RunDRO1->SetForegroundColour(wxColour(0, 255, 0));
	m_RunDRO1->SetBackgroundColour(wxColour(0, 0, 0));
	m_RunDRO1->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer51->Add(m_RunDRO1, 3, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer55 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer46->Add(itemBoxSizer55, 1, wxGROW|wxALL, 2);
	wxButton* itemButton56 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON52, _("Zero\nZ"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer55->Add(itemButton56, 1, wxGROW|wxRIGHT|wxTOP|wxBOTTOM, 2);

	m_zHomed = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL25, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_zHomed->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer55->Add(m_zHomed, 0, wxGROW|wxTOP|wxBOTTOM, 2);

	m_RunDRO2 = new mcDro( itemStaticBoxSizer42->GetStaticBox(), ID_RUN_DRO2, wxDefaultPosition, wxSize(50, 10), wxSUNKEN_BORDER );
	m_RunDRO2->SetForegroundColour(wxColour(0, 255, 0));
	m_RunDRO2->SetBackgroundColour(wxColour(0, 0, 0));
	m_RunDRO2->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer55->Add(m_RunDRO2, 3, wxGROW|wxALL, 2);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer59 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer46->Add(itemBoxSizer59, 1, wxGROW|wxALL, 2);
	wxButton* itemButton60 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON53, _("Zero\nA"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer59->Add(itemButton60, 1, wxGROW|wxRIGHT|wxTOP|wxBOTTOM, 2);

	m_aHomed = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL27, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_aHomed->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer59->Add(m_aHomed, 0, wxGROW|wxTOP|wxBOTTOM, 2);

	m_RunDRO3 = new mcDro( itemStaticBoxSizer42->GetStaticBox(), ID_RUN_DRO3, wxDefaultPosition, wxSize(50, 10), wxSUNKEN_BORDER );
	m_RunDRO3->SetForegroundColour(wxColour(0, 255, 0));
	m_RunDRO3->SetBackgroundColour(wxColour(0, 0, 0));
	m_RunDRO3->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer59->Add(m_RunDRO3, 3, wxGROW|wxALL, 2);

#endif

	wxBoxSizer* itemBoxSizer63 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer42->Add(itemBoxSizer63, 1, wxGROW|wxALL, 0);
	wxGridSizer* itemGridSizer64 = new wxGridSizer(1, 4, 0, 0);
	itemBoxSizer63->Add(itemGridSizer64, 0, wxGROW|wxALL, 0);
	itemGridSizer64->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_BOTTOM|wxALL, 5);

	wxPanel* itemPanel66 = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL3, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	itemPanel66->SetBackgroundColour(wxColour(255, 255, 255));
	itemGridSizer64->Add(itemPanel66, 1, wxALIGN_CENTER_HORIZONTAL|wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer67 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel66->SetSizer(itemBoxSizer67);

	m_ledDistToGO = new wxLed( itemPanel66, ID_LED10, wxDefaultPosition, wxSize(16, 16) );
	m_ledDistToGO->SetBackgroundColour(wxColour(255, 255, 255));
	m_ledDistToGO->Enable(false);
	itemBoxSizer67->Add(m_ledDistToGO, 1, wxALIGN_BOTTOM|wxALL, 1);

	wxPanel* itemPanel69 = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL4, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	itemPanel69->SetBackgroundColour(wxColour(255, 255, 255));
	itemGridSizer64->Add(itemPanel69, 1, wxALIGN_CENTER_HORIZONTAL|wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer70 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel69->SetSizer(itemBoxSizer70);

	m_ledMachCoords = new wxLed( itemPanel69, ID_LED56, wxDefaultPosition, wxSize(16, 16) );
	m_ledMachCoords->SetBackgroundColour(wxColour(255, 255, 255));
	m_ledMachCoords->Enable(false);
	itemBoxSizer70->Add(m_ledMachCoords, 1, wxALIGN_BOTTOM|wxALL, 1);

	wxPanel* itemPanel72 = new wxPanel( itemStaticBoxSizer42->GetStaticBox(), ID_PANEL12, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
	itemPanel72->SetBackgroundColour(wxColour(255, 255, 255));
	itemGridSizer64->Add(itemPanel72, 1, wxALIGN_CENTER_HORIZONTAL|wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer73 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel72->SetSizer(itemBoxSizer73);

	m_ledSoftLimit = new wxLed( itemPanel72, ID_LED12, wxDefaultPosition, wxSize(16, 16) );
	m_ledSoftLimit->SetBackgroundColour(wxColour(255, 255, 255));
	m_ledSoftLimit->Enable(false);
	itemBoxSizer73->Add(m_ledSoftLimit, 1, wxALIGN_BOTTOM|wxALL, 1);

	wxBoxSizer* itemBoxSizer75 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer63->Add(itemBoxSizer75, 1, wxGROW|wxALL, 0);
	wxButton* itemButton76 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON8, _("Goto\nZero"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer75->Add(itemButton76, 1, wxGROW|wxALL, 1);

	m_btn_Dist_TOGO = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BTN_DIST_TOGO, _("To Go"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer75->Add(m_btn_Dist_TOGO, 1, wxGROW|wxALL, 1);

	wxButton* itemButton78 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BTN_MACHINEPOS, _("Machine\nCoordinates"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer75->Add(itemButton78, 1, wxGROW|wxALL, 1);

	wxButton* itemButton79 = new wxButton( itemStaticBoxSizer42->GetStaticBox(), ID_BUTTON11, _("Soft\nLimits"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer75->Add(itemButton79, 1, wxGROW|wxALL, 1);

	wxBoxSizer* itemBoxSizer80 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer38->Add(itemBoxSizer80, 0, wxGROW|wxALL, 5);
	wxStaticBox* itemStaticBoxSizer81Static = new wxStaticBox(itemPanel36, wxID_ANY, _("Current File:"));
	wxStaticBoxSizer* itemStaticBoxSizer81 = new wxStaticBoxSizer(itemStaticBoxSizer81Static, wxHORIZONTAL);
	itemBoxSizer80->Add(itemStaticBoxSizer81, 4, wxGROW|wxALL, 5);
	m_currentFile = new wxStaticText( itemStaticBoxSizer81->GetStaticBox(), wxID_STATIC, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxALIGN_LEFT|wxST_NO_AUTORESIZE|wxSUNKEN_BORDER );
	m_currentFile->SetBackgroundColour(wxColour(226, 226, 226));
	itemStaticBoxSizer81->Add(m_currentFile, 1, wxGROW|wxALL|wxFIXED_MINSIZE, 5);

	wxBoxSizer* itemBoxSizer83 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer80->Add(itemBoxSizer83, 1, wxGROW|wxRIGHT|wxTOP, 2);
	m_btnLoadWizards = new wxButton( itemPanel36, ID_BUTTON48, _("Load Wizards"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer83->Add(m_btnLoadWizards, 1, wxGROW|wxALL, 2);

	m_btnNFSWizards = new wxButton( itemPanel36, ID_BUTTON49, _("NFS Wizards"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer83->Add(m_btnNFSWizards, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer86 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer80->Add(itemBoxSizer86, 1, wxGROW|wxRIGHT|wxTOP, 2);
	m_btnLastWizard = new wxButton( itemPanel36, ID_BUTTON50, _("Last Wizard"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer86->Add(m_btnLastWizard, 1, wxGROW|wxALL, 2);

	wxButton* itemButton88 = new wxButton( itemPanel36, ID_BUTTON54, wxEmptyString, wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer86->Add(itemButton88, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer89 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer37->Add(itemBoxSizer89, 12, wxGROW|wxRIGHT|wxBOTTOM, 5);
	wxStaticBox* itemStaticBoxSizer90Static = new wxStaticBox(itemPanel36, wxID_ANY, _("Tool Path"));
	wxStaticBoxSizer* itemStaticBoxSizer90 = new wxStaticBoxSizer(itemStaticBoxSizer90Static, wxVERTICAL);
	itemBoxSizer89->Add(itemStaticBoxSizer90, 6, wxGROW|wxALL, 5);
	m_runTP = new wxPanel( itemStaticBoxSizer90->GetStaticBox(), ID_PANEL11, wxDefaultPosition, wxSize(50, 50), wxTAB_TRAVERSAL );
	m_runTP->SetBackgroundColour(wxColour(0, 0, 0));
	itemStaticBoxSizer90->Add(m_runTP, 1, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer92 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer89->Add(itemBoxSizer92, 1, wxGROW|wxTOP|wxBOTTOM, 5);
	m_btnRegenToolpath = new wxButton( itemPanel36, ID_REGEN_TP, _("Regen\nToolpath"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer92->Add(m_btnRegenToolpath, 1, wxGROW|wxALL, 2);

	itemBoxSizer92->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxButton* itemButton95 = new wxButton( itemPanel36, ID_DISPLAY_MODE, _("Display\nMode"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer92->Add(itemButton95, 1, wxGROW|wxALL, 2);

	itemBoxSizer92->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxButton* itemButton97 = new wxButton( itemPanel36, ID_JOG_FOLLOW, _("Jog\nFollow"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer92->Add(itemButton97, 1, wxGROW|wxALL, 2);

	m_opTabs->AddPage(itemPanel36, _("Program Run"));

	wxPanel* itemPanel98 = new wxPanel( m_opTabs, ID_PANEL1, wxDefaultPosition, wxSize(100, 100), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel98->SetName(wxT("MDI"));
	itemPanel98->SetBackgroundColour(wxColour(255, 255, 255));
	wxBoxSizer* itemBoxSizer99 = new wxBoxSizer(wxVERTICAL);
	itemPanel98->SetSizer(itemBoxSizer99);

	wxBoxSizer* itemBoxSizer100 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer99->Add(itemBoxSizer100, 1, wxGROW|wxALL, 5);
	wxStaticBox* itemStaticBoxSizer101Static = new wxStaticBox(itemPanel98, wxID_ANY, _("Axis Control"));
	wxStaticBoxSizer* itemStaticBoxSizer101 = new wxStaticBoxSizer(itemStaticBoxSizer101Static, wxVERTICAL);
	itemBoxSizer100->Add(itemStaticBoxSizer101, 20, wxGROW, 5);
	wxBoxSizer* itemBoxSizer102 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer101->Add(itemBoxSizer102, 1, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer103 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer102->Add(itemBoxSizer103, 1, wxGROW|wxALL, 5);
	wxButton* itemButton104 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BUTTON1, _("Ref\nAll\nHome"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer103->Add(itemButton104, 1, wxGROW|wxTOP|wxBOTTOM, 2);

	wxBoxSizer* itemBoxSizer105 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer102->Add(itemBoxSizer105, 5, wxGROW|wxTOP|wxBOTTOM, 1);
	wxBoxSizer* itemBoxSizer106 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer105->Add(itemBoxSizer106, 1, wxGROW, 1);
	wxButton* itemButton107 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BUTTON2, _("Zero\nX"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer106->Add(itemButton107, 2, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_xHomed3 = new wxPanel( itemStaticBoxSizer101->GetStaticBox(), ID_PANEL32, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_xHomed3->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer106->Add(m_xHomed3, 0, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_mdiDRO0 = new mcDro( itemStaticBoxSizer101->GetStaticBox(), ID_MDI_DRO0, wxDefaultPosition, wxSize(10, 10), wxSUNKEN_BORDER );
	m_mdiDRO0->SetForegroundColour(wxColour(0, 255, 0));
	m_mdiDRO0->SetBackgroundColour(wxColour(0, 0, 0));
	m_mdiDRO0->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer106->Add(m_mdiDRO0, 8, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer110 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer105->Add(itemBoxSizer110, 1, wxGROW, 1);
	wxButton* itemButton111 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BUTTON3, _("Zero\nY"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer110->Add(itemButton111, 2, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_yHomed3 = new wxPanel( itemStaticBoxSizer101->GetStaticBox(), ID_PANEL33, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_yHomed3->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer110->Add(m_yHomed3, 0, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_mdiDRO1 = new mcDro( itemStaticBoxSizer101->GetStaticBox(), ID_MDI_DRO1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_mdiDRO1->SetForegroundColour(wxColour(0, 255, 0));
	m_mdiDRO1->SetBackgroundColour(wxColour(0, 0, 0));
	m_mdiDRO1->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer110->Add(m_mdiDRO1, 8, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer114 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer105->Add(itemBoxSizer114, 1, wxGROW, 1);
	wxButton* itemButton115 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BUTTON4, _("Zero\nZ"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer114->Add(itemButton115, 2, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_zHomed3 = new wxPanel( itemStaticBoxSizer101->GetStaticBox(), ID_PANEL34, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_zHomed3->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer114->Add(m_zHomed3, 0, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_mdiDRO2 = new mcDro( itemStaticBoxSizer101->GetStaticBox(), ID_MDI_DRO2, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_mdiDRO2->SetForegroundColour(wxColour(0, 255, 0));
	m_mdiDRO2->SetBackgroundColour(wxColour(0, 0, 0));
	m_mdiDRO2->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer114->Add(m_mdiDRO2, 8, wxGROW|wxALL, 5);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer118 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer105->Add(itemBoxSizer118, 1, wxGROW, 1);
	wxButton* itemButton119 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BUTTON5, _("Zero\nA"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer118->Add(itemButton119, 2, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_aHomed3 = new wxPanel( itemStaticBoxSizer101->GetStaticBox(), ID_PANEL35, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_aHomed3->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer118->Add(m_aHomed3, 0, wxGROW|wxLEFT|wxTOP|wxBOTTOM, 5);

	m_mdiDRO3 = new mcDro( itemStaticBoxSizer101->GetStaticBox(), ID_MDI_DRO3, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_mdiDRO3->SetForegroundColour(wxColour(0, 255, 0));
	m_mdiDRO3->SetBackgroundColour(wxColour(0, 0, 0));
	m_mdiDRO3->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer118->Add(m_mdiDRO3, 8, wxGROW|wxALL, 5);

#endif

	wxBoxSizer* itemBoxSizer122 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer101->Add(itemBoxSizer122, 0, wxGROW|wxALL, 0);
	wxFlexGridSizer* itemFlexGridSizer123 = new wxFlexGridSizer(2, 4, 0, 0);
	itemBoxSizer122->Add(itemFlexGridSizer123, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);
	itemFlexGridSizer123->Add(5, 16, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 1);

	m_ledDistToGO2 = new wxLed( itemStaticBoxSizer101->GetStaticBox(), ID_LED55, wxDefaultPosition, wxSize(16, 16) );
	m_ledDistToGO2->Enable(false);
	itemFlexGridSizer123->Add(m_ledDistToGO2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_BOTTOM|wxALL, 1);

	m_ledMachCoords2 = new wxLed( itemStaticBoxSizer101->GetStaticBox(), ID_LED57, wxDefaultPosition, wxSize(16, 16) );
	m_ledMachCoords2->Enable(false);
	itemFlexGridSizer123->Add(m_ledMachCoords2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 1);

	itemFlexGridSizer123->Add(5, 16, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 1);

	wxButton* itemButton128 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_DEREFALL, _("De-Ref\nAll Axes"), wxDefaultPosition, wxSize(-1, 35), 0 );
	itemFlexGridSizer123->Add(itemButton128, 1, wxGROW|wxALL, 2);

	wxButton* itemButton129 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BTN_DIST_TOGO2, _("To Go"), wxDefaultPosition, wxSize(-1, 10), 0 );
	itemFlexGridSizer123->Add(itemButton129, 1, wxGROW|wxALL, 2);

	wxButton* itemButton130 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_BTN_MACHINEPOS2, _("Machine\nCoords."), wxDefaultPosition, wxSize(-1, 10), 0 );
	itemFlexGridSizer123->Add(itemButton130, 1, wxGROW|wxALL, 2);

	wxButton* itemButton131 = new wxButton( itemStaticBoxSizer101->GetStaticBox(), ID_VERIFY, _("Verify"), wxDefaultPosition, wxSize(-1, 10), 0 );
	itemFlexGridSizer123->Add(itemButton131, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer132 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer100->Add(itemBoxSizer132, 30, wxGROW|wxLEFT|wxRIGHT, 5);
	m_mdiTP = new wxPanel( itemPanel98, ID_PANEL8, wxDefaultPosition, wxSize(50, 50), wxTAB_TRAVERSAL );
	m_mdiTP->SetBackgroundColour(wxColour(0, 0, 0));
	itemBoxSizer132->Add(m_mdiTP, 1, wxGROW|wxALL, 5);

	wxStaticBox* itemStaticBoxSizer134Static = new wxStaticBox(itemPanel98, wxID_ANY, _("MDI Commands (Press \"Cycle Start\" to execute) "));
	wxStaticBoxSizer* itemStaticBoxSizer134 = new wxStaticBoxSizer(itemStaticBoxSizer134Static, wxHORIZONTAL);
	itemBoxSizer99->Add(itemStaticBoxSizer134, 0, wxGROW|wxLEFT|wxRIGHT, 5);
	wxBoxSizer* itemBoxSizer135 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer134->Add(itemBoxSizer135, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);
	wxBitmapButton* itemBitmapButton136 = new wxBitmapButton( itemStaticBoxSizer134->GetStaticBox(), ID_MDI_UP, itemFrame1->GetBitmapResource(wxT("up.xpm")), wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW );
	itemBoxSizer135->Add(itemBitmapButton136, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 4);

	wxBitmapButton* itemBitmapButton137 = new wxBitmapButton( itemStaticBoxSizer134->GetStaticBox(), ID_MDI_DOWN, itemFrame1->GetBitmapResource(wxT("down.xpm")), wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW );
	itemBoxSizer135->Add(itemBitmapButton137, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 4);

	wxBoxSizer* itemBoxSizer138 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer134->Add(itemBoxSizer138, 1, wxGROW|wxALL, 0);
	m_MdiCmds = new wxTextCtrl( itemStaticBoxSizer134->GetStaticBox(), ID_MDI_TEXT, wxEmptyString, wxDefaultPosition, wxSize(10, 10), wxTE_MULTILINE|wxWANTS_CHARS );
	itemBoxSizer138->Add(m_MdiCmds, 1, wxGROW|wxALL, 2);

	m_opTabs->AddPage(itemPanel98, _("MDI"));

	wxPanel* itemPanel140 = new wxPanel( m_opTabs, ID_PANEL2, wxDefaultPosition, wxSize(100, 100), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel140->SetName(wxT("Tool Path"));
	itemPanel140->SetBackgroundColour(wxColour(230, 230, 230));
	wxBoxSizer* itemBoxSizer141 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel140->SetSizer(itemBoxSizer141);

	wxBoxSizer* itemBoxSizer142 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer141->Add(itemBoxSizer142, 3, wxGROW|wxALL, 5);
	m_TpListBox = new wxGcodeList( itemPanel140, ID_TP_GCODELIST, wxDefaultPosition, wxSize(50, 50), wxHLB_DEFAULT_STYLE );
	itemBoxSizer142->Add(m_TpListBox, 7, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer144 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer142->Add(itemBoxSizer144, 3, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer145 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer144->Add(itemBoxSizer145, 1, wxGROW|wxALL, 0);
	wxStaticText* itemStaticText146 = new wxStaticText( itemPanel140, wxID_STATIC, _("X"), wxDefaultPosition, wxSize(10, 10), wxALIGN_RIGHT );
	itemStaticText146->SetFont(wxFont(14, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxT("Tahoma")));
	itemBoxSizer145->Add(itemStaticText146, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer147 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer145->Add(itemBoxSizer147, 7, wxGROW|wxALL, 1);
	m_tpDRO0 = new mcDro( itemPanel140, ID_TP_DRO0, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_tpDRO0->SetForegroundColour(wxColour(0, 255, 0));
	m_tpDRO0->SetBackgroundColour(wxColour(0, 0, 0));
	m_tpDRO0->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer147->Add(m_tpDRO0, 1, wxGROW|wxALL, 0);

	wxBoxSizer* itemBoxSizer149 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer144->Add(itemBoxSizer149, 1, wxGROW|wxALL, 0);
	wxStaticText* itemStaticText150 = new wxStaticText( itemPanel140, wxID_STATIC, _("Y"), wxDefaultPosition, wxSize(10, 10), wxALIGN_RIGHT );
	itemStaticText150->SetFont(wxFont(14, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxT("Tahoma")));
	itemBoxSizer149->Add(itemStaticText150, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer151 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer149->Add(itemBoxSizer151, 7, wxGROW|wxALL, 1);
	m_tpDRO1 = new mcDro( itemPanel140, ID_TP_DRO1, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_tpDRO1->SetForegroundColour(wxColour(0, 255, 0));
	m_tpDRO1->SetBackgroundColour(wxColour(0, 0, 0));
	m_tpDRO1->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer151->Add(m_tpDRO1, 1, wxGROW|wxALL, 0);

	wxBoxSizer* itemBoxSizer153 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer144->Add(itemBoxSizer153, 1, wxGROW|wxALL, 0);
	wxStaticText* itemStaticText154 = new wxStaticText( itemPanel140, wxID_STATIC, _("Z"), wxDefaultPosition, wxSize(10, 10), wxALIGN_RIGHT );
	itemStaticText154->SetFont(wxFont(14, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxT("Tahoma")));
	itemBoxSizer153->Add(itemStaticText154, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer155 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer153->Add(itemBoxSizer155, 7, wxGROW|wxALL, 1);
	m_tpDRO2 = new mcDro( itemPanel140, ID_TP_DRO2, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_tpDRO2->SetForegroundColour(wxColour(0, 255, 0));
	m_tpDRO2->SetBackgroundColour(wxColour(0, 0, 0));
	m_tpDRO2->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer155->Add(m_tpDRO2, 1, wxGROW|wxALL, 0);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer157 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer144->Add(itemBoxSizer157, 1, wxGROW|wxALL, 0);
	wxStaticText* itemStaticText158 = new wxStaticText( itemPanel140, wxID_STATIC, _("A"), wxDefaultPosition, wxSize(10, 10), wxALIGN_RIGHT );
	itemStaticText158->SetFont(wxFont(14, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxT("Tahoma")));
	itemBoxSizer157->Add(itemStaticText158, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer159 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer157->Add(itemBoxSizer159, 7, wxGROW|wxALL, 1);
	m_tpDRO3 = new mcDro( itemPanel140, ID_TP_DRO3, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER );
	m_tpDRO3->SetForegroundColour(wxColour(0, 255, 0));
	m_tpDRO3->SetBackgroundColour(wxColour(0, 0, 0));
	m_tpDRO3->SetFont(wxFont(22, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer159->Add(m_tpDRO3, 1, wxGROW|wxALL, 0);

#endif

	m_tpTP = new wxPanel( itemPanel140, ID_PANEL7, wxDefaultPosition, wxSize(50, 50), wxTAB_TRAVERSAL );
	m_tpTP->SetBackgroundColour(wxColour(0, 0, 0));
	itemBoxSizer141->Add(m_tpTP, 10, wxGROW|wxALL, 5);

	m_opTabs->AddPage(itemPanel140, _("Tool Path"));

	wxPanel* itemPanel162 = new wxPanel( m_opTabs, ID_PANEL26, wxDefaultPosition, wxSize(100, 100), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel162->SetName(wxT("Diagnostics"));
	itemPanel162->SetBackgroundColour(wxColour(230, 230, 230));
	wxBoxSizer* itemBoxSizer163 = new wxBoxSizer(wxVERTICAL);
	itemPanel162->SetSizer(itemBoxSizer163);

	wxBoxSizer* itemBoxSizer164 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer163->Add(itemBoxSizer164, 0, wxGROW|wxLEFT|wxRIGHT, 5);
	wxStaticBox* itemStaticBoxSizer165Static = new wxStaticBox(itemPanel162, wxID_ANY, _("I/O Status"));
	wxStaticBoxSizer* itemStaticBoxSizer165 = new wxStaticBoxSizer(itemStaticBoxSizer165Static, wxVERTICAL);
	itemBoxSizer164->Add(itemStaticBoxSizer165, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);
	wxStaticBox* itemStaticBoxSizer166Static = new wxStaticBox(itemStaticBoxSizer165->GetStaticBox(), wxID_ANY, _("Inputs"));
	wxStaticBoxSizer* itemStaticBoxSizer166 = new wxStaticBoxSizer(itemStaticBoxSizer166Static, wxVERTICAL);
	itemStaticBoxSizer165->Add(itemStaticBoxSizer166, 0, wxGROW|wxALL, 2);
	wxFlexGridSizer* itemFlexGridSizer167 = new wxFlexGridSizer(8, 8, 0, 0);
	itemStaticBoxSizer166->Add(itemFlexGridSizer167, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
#if defined(MACHPRO)
	m_ledInput1 = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED11, wxDefaultPosition, wxSize(16, 16) );
	m_ledInput1->Enable(false);
	itemFlexGridSizer167->Add(m_ledInput1, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText169 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Input 0"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText169, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledXpos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED13, wxDefaultPosition, wxSize(16, 16) );
	m_ledXpos->Enable(false);
	itemFlexGridSizer167->Add(m_ledXpos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText171 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("X++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText171, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledXneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED14, wxDefaultPosition, wxSize(16, 16) );
	m_ledXneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledXneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText173 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("X-- Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText173, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledHomeX = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED15, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeX->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeX, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText175 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("X Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText175, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledInput2 = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED16, wxDefaultPosition, wxSize(16, 16) );
	m_ledInput2->Enable(false);
	itemFlexGridSizer167->Add(m_ledInput2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText177 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Input 1"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText177, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledYpos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED17, wxDefaultPosition, wxSize(16, 16) );
	m_ledYpos->Enable(false);
	itemFlexGridSizer167->Add(m_ledYpos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText179 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Y++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText179, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledYneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED18, wxDefaultPosition, wxSize(16, 16) );
	m_ledYneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledYneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText181 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Y-- Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText181, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledHomeY = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED19, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeY->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeY, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText183 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Y Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText183, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledInput3 = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED20, wxDefaultPosition, wxSize(16, 16) );
	m_ledInput3->Enable(false);
	itemFlexGridSizer167->Add(m_ledInput3, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText185 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Input 2"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText185, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledZpos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED21, wxDefaultPosition, wxSize(16, 16) );
	m_ledZpos->Enable(false);
	itemFlexGridSizer167->Add(m_ledZpos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText187 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Z++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText187, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledZneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED22, wxDefaultPosition, wxSize(16, 16) );
	m_ledZneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledZneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText189 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Z-- Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText189, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledHomeZ = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED23, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeZ->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeZ, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText191 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Z Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText191, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledInput4 = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED24, wxDefaultPosition, wxSize(16, 16) );
	m_ledInput4->Enable(false);
	itemFlexGridSizer167->Add(m_ledInput4, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText193 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Input 3"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText193, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledApos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED25, wxDefaultPosition, wxSize(16, 16) );
	m_ledApos->Enable(false);
	itemFlexGridSizer167->Add(m_ledApos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText195 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("A++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText195, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledAneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED26, wxDefaultPosition, wxSize(16, 16) );
	m_ledAneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledAneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText197 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("A-- Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText197, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledHomeA = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED27, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeA->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeA, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText199 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("A Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText199, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledDigitize = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED28, wxDefaultPosition, wxSize(16, 16) );
	m_ledDigitize->Enable(false);
	itemFlexGridSizer167->Add(m_ledDigitize, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText201 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Probe"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText201, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledBpos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED29, wxDefaultPosition, wxSize(16, 16) );
	m_ledBpos->Enable(false);
	itemFlexGridSizer167->Add(m_ledBpos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText203 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("B++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText203, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledBneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED30, wxDefaultPosition, wxSize(16, 16) );
	m_ledBneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledBneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText205 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("B-- Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText205, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledHomeB = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED31, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeB->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeB, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText207 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("B Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText207, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledLimitOverride = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED32, wxDefaultPosition, wxSize(16, 16) );
	m_ledLimitOverride->Enable(false);
	itemFlexGridSizer167->Add(m_ledLimitOverride, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText209 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Limit Override"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText209, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledCpos = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED33, wxDefaultPosition, wxSize(16, 16) );
	m_ledCpos->Enable(false);
	itemFlexGridSizer167->Add(m_ledCpos, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText211 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("C++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText211, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledCneg = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED34, wxDefaultPosition, wxSize(16, 16) );
	m_ledCneg->Enable(false);
	itemFlexGridSizer167->Add(m_ledCneg, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText213 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("C++ Limit"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText213, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledHomeC = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED35, wxDefaultPosition, wxSize(16, 16) );
	m_ledHomeC->Enable(false);
	itemFlexGridSizer167->Add(m_ledHomeC, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText215 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("C Home"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText215, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledEmergency = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED36, wxDefaultPosition, wxSize(16, 16) );
	m_ledEmergency->Enable(false);
	itemFlexGridSizer167->Add(m_ledEmergency, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText217 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Emergency"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText217, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	itemFlexGridSizer167->Add(5, 5, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	itemFlexGridSizer167->Add(5, 5, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledTiming = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED37, wxDefaultPosition, wxSize(16, 16) );
	m_ledTiming->Enable(false);
	itemFlexGridSizer167->Add(m_ledTiming, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText221 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Timing"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText221, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledIndex = new wxLed( itemStaticBoxSizer166->GetStaticBox(), ID_LED38, wxDefaultPosition, wxSize(16, 16) );
	m_ledIndex->Enable(false);
	itemFlexGridSizer167->Add(m_ledIndex, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText223 = new wxStaticText( itemStaticBoxSizer166->GetStaticBox(), wxID_STATIC, _("Index"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer167->Add(itemStaticText223, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	wxStaticBox* itemStaticBoxSizer224Static = new wxStaticBox(itemStaticBoxSizer165->GetStaticBox(), wxID_ANY, _("Outputs"));
	wxStaticBoxSizer* itemStaticBoxSizer224 = new wxStaticBoxSizer(itemStaticBoxSizer224Static, wxVERTICAL);
	itemStaticBoxSizer165->Add(itemStaticBoxSizer224, 0, wxGROW|wxALL, 2);
	wxFlexGridSizer* itemFlexGridSizer225 = new wxFlexGridSizer(8, 8, 0, 0);
	itemStaticBoxSizer224->Add(itemFlexGridSizer225, 0, wxGROW|wxALL, 5);
	m_ledEnable1 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED39, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable1->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable1, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText227 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 0"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText227, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledEnable2 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED40, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable2->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText229 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 1"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText229, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledEnable3 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED41, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable3->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable3, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText231 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 2"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText231, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledEnable4 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED42, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable4->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable4, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText233 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 3"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText233, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledEnable5 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED43, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable5->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable5, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText235 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 4"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText235, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledEnable6 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED44, wxDefaultPosition, wxSize(16, 16) );
	m_ledEnable6->Enable(false);
	itemFlexGridSizer225->Add(m_ledEnable6, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText237 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Enable 5"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText237, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput1 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED45, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput1->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput1, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText239 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 0"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText239, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput2 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED46, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput2->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText241 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 1"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText241, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput3 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED47, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput3->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput3, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText243 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 2"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText243, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput4 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED48, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput4->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput4, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText245 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 3"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText245, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput5 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED49, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput5->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput5, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText247 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 4"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText247, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	m_ledOutput6 = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED50, wxDefaultPosition, wxSize(16, 16) );
	m_ledOutput6->Enable(false);
	itemFlexGridSizer225->Add(m_ledOutput6, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText249 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Output 5"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText249, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledSpindleOn = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED5, wxDefaultPosition, wxSize(16, 16) );
	m_ledSpindleOn->Enable(false);
	itemFlexGridSizer225->Add(m_ledSpindleOn, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText251 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Spindle On"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText251, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledSpindleFwd = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED9, wxDefaultPosition, wxSize(16, 16) );
	m_ledSpindleFwd->Enable(false);
	itemFlexGridSizer225->Add(m_ledSpindleFwd, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText253 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Spindle Fwd."), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText253, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledSpindleRev = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED51, wxDefaultPosition, wxSize(16, 16) );
	m_ledSpindleRev->Enable(false);
	itemFlexGridSizer225->Add(m_ledSpindleRev, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText255 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Spindle Rev."), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText255, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledCoolantOn = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED52, wxDefaultPosition, wxSize(16, 16) );
	m_ledCoolantOn->Enable(false);
	itemFlexGridSizer225->Add(m_ledCoolantOn, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText257 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Coolant On"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText257, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	m_ledMistOn = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED53, wxDefaultPosition, wxSize(16, 16) );
	m_ledMistOn->Enable(false);
	itemFlexGridSizer225->Add(m_ledMistOn, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

#if defined(MACHPRO)
	wxStaticText* itemStaticText259 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Mist On"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText259, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);
#endif

	m_ledDwell = new wxLed( itemStaticBoxSizer224->GetStaticBox(), ID_LED_DWELL, wxDefaultPosition, wxSize(20, 20) );
	m_ledDwell->Enable(false);
	itemFlexGridSizer225->Add(m_ledDwell, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText261 = new wxStaticText( itemStaticBoxSizer224->GetStaticBox(), wxID_STATIC, _("Dwell"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer225->Add(itemStaticText261, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxBoxSizer* itemBoxSizer262 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer164->Add(itemBoxSizer262, 0, wxGROW|wxALL, 0);
	wxStaticBox* itemStaticBoxSizer263Static = new wxStaticBox(itemPanel162, wxID_ANY, _("Homing"));
	wxStaticBoxSizer* itemStaticBoxSizer263 = new wxStaticBoxSizer(itemStaticBoxSizer263Static, wxVERTICAL);
	itemBoxSizer262->Add(itemStaticBoxSizer263, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);
	wxBoxSizer* itemBoxSizer264 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer263->Add(itemBoxSizer264, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
	m_refX = new wxButton( itemStaticBoxSizer263->GetStaticBox(), ID_BUTTON30, _("Ref X"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer264->Add(m_refX, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_xHomed2 = new wxPanel( itemStaticBoxSizer263->GetStaticBox(), ID_PANEL28, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_xHomed2->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer264->Add(m_xHomed2, 1, wxGROW|wxTOP|wxBOTTOM, 5);

	wxBoxSizer* itemBoxSizer267 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer263->Add(itemBoxSizer267, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
	m_refY = new wxButton( itemStaticBoxSizer263->GetStaticBox(), ID_BUTTON31, _("Ref Y"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer267->Add(m_refY, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_yHomed2 = new wxPanel( itemStaticBoxSizer263->GetStaticBox(), ID_PANEL29, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_yHomed2->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer267->Add(m_yHomed2, 1, wxGROW|wxTOP|wxBOTTOM, 5);

	wxBoxSizer* itemBoxSizer270 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer263->Add(itemBoxSizer270, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
	m_refZ = new wxButton( itemStaticBoxSizer263->GetStaticBox(), ID_BUTTON32, _("Ref Z"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer270->Add(m_refZ, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_zHomed2 = new wxPanel( itemStaticBoxSizer263->GetStaticBox(), ID_PANEL30, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_zHomed2->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer270->Add(m_zHomed2, 1, wxGROW|wxTOP|wxBOTTOM, 5);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer273 = new wxBoxSizer(wxHORIZONTAL);
	itemStaticBoxSizer263->Add(itemBoxSizer273, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
	m_refA = new wxButton( itemStaticBoxSizer263->GetStaticBox(), ID_BUTTON33, _("Ref A"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer273->Add(m_refA, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_aHomed2 = new wxPanel( itemStaticBoxSizer263->GetStaticBox(), ID_PANEL31, wxDefaultPosition, wxSize(20, -1), wxRAISED_BORDER|wxTAB_TRAVERSAL );
	m_aHomed2->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer273->Add(m_aHomed2, 1, wxGROW|wxTOP|wxBOTTOM, 5);

#endif

	wxStaticBox* itemStaticBoxSizer276Static = new wxStaticBox(itemPanel162, wxID_ANY, _("Spindle Range"));
	wxStaticBoxSizer* itemStaticBoxSizer276 = new wxStaticBoxSizer(itemStaticBoxSizer276Static, wxVERTICAL);
	itemBoxSizer262->Add(itemStaticBoxSizer276, 0, wxGROW|wxALL, 2);
	m_spinrange = new wxSpinCtrl( itemStaticBoxSizer276->GetStaticBox(), ID_SPINCTRL, wxT("1"), wxDefaultPosition, wxSize(50, -1), wxSP_ARROW_KEYS, 1, 20, 1 );
	itemStaticBoxSizer276->Add(m_spinrange, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticBox* itemStaticBoxSizer278Static = new wxStaticBox(itemPanel162, wxID_ANY, _("Test Registers"));
	wxStaticBoxSizer* itemStaticBoxSizer278 = new wxStaticBoxSizer(itemStaticBoxSizer278Static, wxVERTICAL);
	itemBoxSizer164->Add(itemStaticBoxSizer278, 0, wxALIGN_TOP|wxALL, 2);
	wxFlexGridSizer* itemFlexGridSizer279 = new wxFlexGridSizer(5, 4, 0, 0);
	itemStaticBoxSizer278->Add(itemFlexGridSizer279, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);
	wxStaticText* itemStaticText280 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 0:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText280, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg0 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG0, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg0->Enable(false);
	itemFlexGridSizer279->Add(m_testReg0, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText282 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 1:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText282, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg1 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG1, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg1->Enable(false);
	itemFlexGridSizer279->Add(m_testReg1, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText284 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 2:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText284, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg2 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG2, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg2->Enable(false);
	itemFlexGridSizer279->Add(m_testReg2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText286 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 3:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText286, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg3 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG3, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg3->Enable(false);
	itemFlexGridSizer279->Add(m_testReg3, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText288 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 4:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText288, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg4 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG4, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg4->Enable(false);
	itemFlexGridSizer279->Add(m_testReg4, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText290 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 5:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText290, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg5 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG5, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg5->Enable(false);
	itemFlexGridSizer279->Add(m_testReg5, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText292 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 6:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText292, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg6 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG6, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg6->Enable(false);
	itemFlexGridSizer279->Add(m_testReg6, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText294 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 7:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText294, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg7 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG7, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg7->Enable(false);
	itemFlexGridSizer279->Add(m_testReg7, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText296 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 8:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText296, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg8 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG8, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg8->Enable(false);
	itemFlexGridSizer279->Add(m_testReg8, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticText* itemStaticText298 = new wxStaticText( itemStaticBoxSizer278->GetStaticBox(), wxID_STATIC, _("Reg 9:"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT );
	itemFlexGridSizer279->Add(itemStaticText298, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_testReg9 = new wxTextCtrl( itemStaticBoxSizer278->GetStaticBox(), ID_TESTREG9, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	m_testReg9->Enable(false);
	itemFlexGridSizer279->Add(m_testReg9, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer300 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer163->Add(itemBoxSizer300, 1, wxGROW|wxLEFT|wxRIGHT, 5);
	wxStaticBox* itemStaticBoxSizer301Static = new wxStaticBox(itemPanel162, wxID_ANY, _("Machine Mode"));
	wxStaticBoxSizer* itemStaticBoxSizer301 = new wxStaticBoxSizer(itemStaticBoxSizer301Static, wxHORIZONTAL);
	itemBoxSizer300->Add(itemStaticBoxSizer301, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 2);
	wxStaticText* itemStaticText302 = new wxStaticText( itemStaticBoxSizer301->GetStaticBox(), wxID_STATIC, _("State:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemStaticBoxSizer301->Add(itemStaticText302, 0, wxALIGN_CENTER_VERTICAL|wxLEFT, 6);

	m_machState = new wxTextCtrl( itemStaticBoxSizer301->GetStaticBox(), ID_TEXT_STATE, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	itemStaticBoxSizer301->Add(m_machState, 4, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5);

	wxStaticText* itemStaticText304 = new wxStaticText( itemStaticBoxSizer301->GetStaticBox(), wxID_STATIC, _("Modals:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemStaticBoxSizer301->Add(itemStaticText304, 0, wxALIGN_CENTER_VERTICAL|wxLEFT, 5);

	m_modals = new wxTextCtrl( itemStaticBoxSizer301->GetStaticBox(), ID_TEXT_MODALS, wxEmptyString, wxDefaultPosition, wxDefaultSize, 0 );
	itemStaticBoxSizer301->Add(m_modals, 13, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5);

	m_opTabs->AddPage(itemPanel162, _("Diagnostics"));

	itemBoxSizer34->Add(m_opTabs, 1, wxGROW|wxLEFT|wxRIGHT|wxTOP, 2);

	wxBoxSizer* itemBoxSizer306 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer33->Add(itemBoxSizer306, 1, wxGROW|wxALL, 0);

	wxStaticBox* itemStaticBoxSizer307Static = new wxStaticBox(itemPanel32, wxID_ANY, _("Control"));
	wxStaticBoxSizer* itemStaticBoxSizer307 = new wxStaticBoxSizer(itemStaticBoxSizer307Static, wxHORIZONTAL);
	itemBoxSizer306->Add(itemStaticBoxSizer307, 0, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer308 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer307->Add(itemBoxSizer308, 0, wxGROW|wxALL, 2);

	wxButton* itemButton309 = new wxButton( itemStaticBoxSizer307->GetStaticBox(), ID_CYCLESTART, _("Cycle Start"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemButton309->SetBackgroundColour(wxColour(0, 255, 0));
	itemBoxSizer308->Add(itemButton309, 1, wxGROW|wxALL, 2);

	wxButton* itemButton310 = new wxButton( itemStaticBoxSizer307->GetStaticBox(), ID_FEEDHOLD, _("Feed Hold"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemButton310->SetBackgroundColour(wxColour(255, 255, 0));
	itemBoxSizer308->Add(itemButton310, 1, wxGROW|wxALL, 2);

	wxButton* itemButton311 = new wxButton( itemStaticBoxSizer307->GetStaticBox(), ID_STOP, _("Stop"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemButton311->SetBackgroundColour(wxColour(255, 0, 0));
	itemBoxSizer308->Add(itemButton311, 1, wxGROW|wxALL, 2);

	wxButton* itemButton312 = new wxButton( itemStaticBoxSizer307->GetStaticBox(), ID_RESET, _("Reset"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer308->Add(itemButton312, 1, wxGROW|wxALL, 2);

	m_enableControl = new wxButton( itemStaticBoxSizer307->GetStaticBox(), ID_ENABLE, _("Enable"), wxDefaultPosition, wxSize(75, -1), 0 );
	m_enableControl->SetBackgroundColour(wxColour(0, 255, 0));
	itemBoxSizer308->Add(m_enableControl, 1, wxGROW|wxALL, 2);

	wxNotebook* itemNotebook314 = new wxNotebook( itemPanel32, ID_NOTEBOOK1, wxDefaultPosition, wxSize(50, -1), wxBK_TOP|wxRAISED_BORDER );
	itemNotebook314->SetBackgroundColour(wxColour(230, 230, 230));

	wxPanel* itemPanel315 = new wxPanel( itemNotebook314, ID_PANEL6, wxDefaultPosition, wxSize(10, -1), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	wxBoxSizer* itemBoxSizer316 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel315->SetSizer(itemBoxSizer316);

	wxBoxSizer* itemBoxSizer317 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer316->Add(itemBoxSizer317, 1, wxGROW|wxALL, 2);
	wxButton* itemButton318 = new wxButton( itemPanel315, ID_BUTTON17, _("Edit G Code"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer317->Add(itemButton318, 1, wxGROW|wxALL, 2);

	wxButton* itemButton319 = new wxButton( itemPanel315, ID_BUTTON22, _("Recent File"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer317->Add(itemButton319, 1, wxGROW|wxALL, 2);

	wxButton* itemButton320 = new wxButton( itemPanel315, ID_BUTTON23, _("Close G Code"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer317->Add(itemButton320, 1, wxGROW|wxALL, 2);

	m_btnLoadGcode = new wxButton( itemPanel315, ID_BUTTON24, _("Load G Code"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer317->Add(m_btnLoadGcode, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer322 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer316->Add(itemBoxSizer322, 1, wxGROW|wxALL, 2);
	wxButton* itemButton323 = new wxButton( itemPanel315, ID_BUTTON25, _("Set Next Line"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer322->Add(itemButton323, 1, wxGROW|wxALL, 2);

	wxButton* itemButton324 = new wxButton( itemPanel315, ID_BUTTON27, _("Run From Here"), wxDefaultPosition, wxSize(10, 10), 0 );
	itemBoxSizer322->Add(itemButton324, 1, wxGROW|wxALL, 2);

	itemBoxSizer322->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	itemBoxSizer322->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer327 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer316->Add(itemBoxSizer327, 0, wxGROW|wxALL, 5);
	itemBoxSizer327->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer329 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer327->Add(itemBoxSizer329, 1, wxGROW, 2);
	wxStaticText* itemStaticText330 = new wxStaticText( itemPanel315, wxID_STATIC, _("Line:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer329->Add(itemStaticText330, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_line_number = new wxTextCtrl( itemPanel315, ID_LINENUM_TEXT, wxEmptyString, wxDefaultPosition, wxSize(75, -1), wxTE_PROCESS_ENTER|wxTE_RIGHT|wxSUNKEN_BORDER );
	m_line_number->SetMaxLength(6);
	itemBoxSizer329->Add(m_line_number, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	itemBoxSizer327->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	itemBoxSizer327->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	itemNotebook314->AddPage(itemPanel315, _("File Ops"));

	m_runOps = new wxPanel( itemNotebook314, ID_PANEL5, wxDefaultPosition, wxSize(10, -1), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	m_runOps->SetBackgroundColour(wxColour(230, 230, 230));
	wxBoxSizer* itemBoxSizer335 = new wxBoxSizer(wxHORIZONTAL);
	m_runOps->SetSizer(itemBoxSizer335);

	wxBoxSizer* itemBoxSizer336 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer335->Add(itemBoxSizer336, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 2);
	wxBoxSizer* itemBoxSizer337 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer336->Add(itemBoxSizer337, 1, wxALIGN_LEFT|wxALL, 0);
	wxButton* itemButton338 = new wxButton( m_runOps, ID_BUTTON16, _("Rewind"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer337->Add(itemButton338, 0, wxGROW|wxALL, 2);

	itemBoxSizer337->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer340 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer336->Add(itemBoxSizer340, 1, wxALIGN_LEFT|wxALL, 0);
	m_btnSingleBlock = new wxButton( m_runOps, ID_BTN_SINGLE_BLOCK, _("Single Block"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer340->Add(m_btnSingleBlock, 0, wxGROW|wxALL, 2);

	m_ledSingleBlock = new wxLed( m_runOps, ID_CUSTOM, wxDefaultPosition, wxSize(20, 20) );
	m_ledSingleBlock->Enable(false);
	itemBoxSizer340->Add(m_ledSingleBlock, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer343 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer336->Add(itemBoxSizer343, 1, wxALIGN_LEFT|wxALL, 0);
	wxButton* itemButton344 = new wxButton( m_runOps, ID_BUTTON18, _("Rev. Run"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer343->Add(itemButton344, 0, wxGROW|wxALL, 2);

	m_ledRevRun = new wxLed( m_runOps, ID_LED, wxDefaultPosition, wxSize(20, 20) );
	m_ledRevRun->Enable(false);
	itemBoxSizer343->Add(m_ledRevRun, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

#endif

	wxBoxSizer* itemBoxSizer346 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer335->Add(itemBoxSizer346, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 2);
	wxBoxSizer* itemBoxSizer347 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer346->Add(itemBoxSizer347, 1, wxALIGN_LEFT|wxALL, 0);
	itemBoxSizer347->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer349 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer346->Add(itemBoxSizer349, 1, wxALIGN_LEFT|wxALL, 0);
	m_btnOptStop = new wxButton( m_runOps, ID_BUTTON20, _("M1 Opt Stp"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer349->Add(m_btnOptStop, 0, wxGROW|wxALL, 2);

	m_ledOptStop = new wxLed( m_runOps, ID_LED2, wxDefaultPosition, wxSize(20, 20) );
	m_ledOptStop->Enable(false);
	itemBoxSizer349->Add(m_ledOptStop, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxBoxSizer* itemBoxSizer352 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer346->Add(itemBoxSizer352, 1, wxALIGN_LEFT|wxALL, 0);
	wxButton* itemButton353 = new wxButton( m_runOps, ID_BUTTON21, _("Flood"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer352->Add(itemButton353, 0, wxGROW|wxALL, 2);

	m_ledFlood = new wxLed( m_runOps, ID_LED3, wxDefaultPosition, wxSize(20, 20) );
	m_ledFlood->Enable(false);
	itemBoxSizer352->Add(m_ledFlood, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxBoxSizer* itemBoxSizer355 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer335->Add(itemBoxSizer355, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 2);
	wxBoxSizer* itemBoxSizer356 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer355->Add(itemBoxSizer356, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 0);
	wxStaticText* itemStaticText357 = new wxStaticText( m_runOps, wxID_STATIC, _("Block Skip"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer356->Add(itemStaticText357, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_ledBlockDelete = new wxLed( m_runOps, ID_LED1, wxDefaultPosition, wxSize(20, 20) );
	m_ledBlockDelete->Enable(false);
	itemBoxSizer356->Add(m_ledBlockDelete, 0, wxALIGN_CENTER_VERTICAL|wxALL, 1);

	m_blockSkip0 = new wxToggleButton( m_runOps, ID_BSKIP0, _("Skip /"), wxDefaultPosition, wxDefaultSize, 0 );
	m_blockSkip0->SetValue(false);
	itemBoxSizer355->Add(m_blockSkip0, 1, wxGROW|wxALL, 2);

	m_blockSkip1 = new wxToggleButton( m_runOps, ID_BSKIP1, _("Skip /1"), wxDefaultPosition, wxDefaultSize, 0 );
	m_blockSkip1->SetValue(false);
	itemBoxSizer355->Add(m_blockSkip1, 1, wxGROW|wxALL, 2);

	m_blockSkip2 = new wxToggleButton( m_runOps, ID_BSKIP2, _("Skip /2"), wxDefaultPosition, wxDefaultSize, 0 );
	m_blockSkip2->SetValue(false);
	itemBoxSizer355->Add(m_blockSkip2, 1, wxGROW|wxALL, 2);

	m_blockSkip3 = new wxToggleButton( m_runOps, ID_BSKIP3, _("Skip /3"), wxDefaultPosition, wxDefaultSize, 0 );
	m_blockSkip3->SetValue(false);
	itemBoxSizer355->Add(m_blockSkip3, 1, wxGROW|wxALL, 2);

	itemNotebook314->AddPage(m_runOps, _("Run Ops"));

	wxPanel* itemPanel363 = new wxPanel( itemNotebook314, ID_PANEL9, wxDefaultPosition, wxSize(10, -1), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	wxBoxSizer* itemBoxSizer364 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel363->SetSizer(itemBoxSizer364);

	wxBoxSizer* itemBoxSizer365 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer364->Add(itemBoxSizer365, 0, wxGROW|wxALL, 2);
	m_btnOpRegenToolpath = new wxButton( itemPanel363, ID_REGEN_TP2, _("Regen\nToolpath"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer365->Add(m_btnOpRegenToolpath, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	wxButton* itemButton367 = new wxButton( itemPanel363, ID_DISPLAYBUTTON, _("Display\nMode"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer365->Add(itemButton367, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	wxBoxSizer* itemBoxSizer368 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer364->Add(itemBoxSizer368, 0, wxGROW|wxALL, 2);
	wxButton* itemButton369 = new wxButton( itemPanel363, ID_BTN_JOG_FOLLOW, _("Jog\nFollow"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer368->Add(itemButton369, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	itemNotebook314->AddPage(itemPanel363, _("Tool Path Ops"));

	wxPanel* itemPanel370 = new wxPanel( itemNotebook314, ID_PANEL13, wxDefaultPosition, wxSize(10, -1), wxSUNKEN_BORDER|wxTAB_TRAVERSAL );
	itemPanel370->SetBackgroundColour(wxColour(230, 230, 230));
	wxBoxSizer* itemBoxSizer371 = new wxBoxSizer(wxVERTICAL);
	itemPanel370->SetSizer(itemBoxSizer371);

	wxBoxSizer* itemBoxSizer372 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer371->Add(itemBoxSizer372, 2, wxGROW|wxALL, 5);
#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer373 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer372->Add(itemBoxSizer373, 1, wxGROW|wxALL, 2);
	wxButton* itemButton374 = new wxButton( itemPanel370, ID_JOG_APOS, _("4+"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer373->Add(itemButton374, 1, wxGROW|wxALL, 2);

	itemBoxSizer373->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	wxButton* itemButton376 = new wxButton( itemPanel370, ID_JOG_ANEG, _("4-"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer373->Add(itemButton376, 1, wxGROW|wxALL, 2);

#endif

	wxBoxSizer* itemBoxSizer377 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer372->Add(itemBoxSizer377, 2, wxGROW|wxALL, 2);
	wxBoxSizer* itemBoxSizer378 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer377->Add(itemBoxSizer378, 1, wxGROW|wxALL, 0);
	itemBoxSizer378->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxButton* itemButton380 = new wxButton( itemPanel370, ID_JOG_YPOS, _("Y+"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer378->Add(itemButton380, 2, wxGROW|wxALL, 2);

	itemBoxSizer378->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxBoxSizer* itemBoxSizer382 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer377->Add(itemBoxSizer382, 1, wxGROW|wxALL, 0);
	wxButton* itemButton383 = new wxButton( itemPanel370, ID_JOG_XNEG, _("X-"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer382->Add(itemButton383, 1, wxGROW|wxALL, 2);

	wxButton* itemButton384 = new wxButton( itemPanel370, ID_JOG_XPOS, _("X+"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer382->Add(itemButton384, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer385 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer377->Add(itemBoxSizer385, 1, wxGROW|wxALL, 0);
	itemBoxSizer385->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxButton* itemButton387 = new wxButton( itemPanel370, ID_JOG_YNEG, _("Y-"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer385->Add(itemButton387, 2, wxGROW|wxALL, 2);

	itemBoxSizer385->Add(5, 5, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxBoxSizer* itemBoxSizer389 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer372->Add(itemBoxSizer389, 1, wxGROW|wxALL, 2);
	wxButton* itemButton390 = new wxButton( itemPanel370, ID_JOG_ZPOS, _("Z+"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer389->Add(itemButton390, 1, wxGROW|wxALL, 2);

	itemBoxSizer389->Add(5, 5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	wxButton* itemButton392 = new wxButton( itemPanel370, ID_JOG_ZNEG, _("Z-"), wxDefaultPosition, wxSize(70, 10), 0 );
	itemBoxSizer389->Add(itemButton392, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer393 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer371->Add(itemBoxSizer393, 0, wxGROW|wxALL, 0);
	m_jogRate = new wxSlider( itemPanel370, ID_JOG_RATE, 500, 0, 1000, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL );
	itemBoxSizer393->Add(m_jogRate, 1, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxStaticText* itemStaticText395 = new wxStaticText( itemPanel370, wxID_STATIC, _("Jog Rate"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer393->Add(itemStaticText395, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5);

	m_jogRateText = new wxTextCtrl( itemPanel370, ID_JOG_RATE_TEXT, wxEmptyString, wxDefaultPosition, wxSize(40, -1), wxTE_PROCESS_ENTER );
	itemBoxSizer393->Add(m_jogRateText, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 5);

	wxStaticText* itemStaticText397 = new wxStaticText( itemPanel370, wxID_STATIC, _("%"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer393->Add(itemStaticText397, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT, 2);

	wxBoxSizer* itemBoxSizer398 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer371->Add(itemBoxSizer398, 1, wxGROW|wxALL, 0);
	wxBoxSizer* itemBoxSizer399 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer398->Add(itemBoxSizer399, 0, wxGROW|wxALL, 2);
	wxButton* itemButton400 = new wxButton( itemPanel370, ID_BTN_CYCLE_JOG_STEP, _("Cycle Jog Step"), wxDefaultPosition, wxSize(-1, 10), 0 );
	itemBoxSizer399->Add(itemButton400, 1, wxGROW|wxALL, 2);

	m_btnJogMode = new wxButton( itemPanel370, ID_BUTTON6, _("Jog Mode"), wxDefaultPosition, wxSize(-1, 10), 0 );
	itemBoxSizer399->Add(m_btnJogMode, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer402 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer398->Add(itemBoxSizer402, 0, wxGROW|wxALL, 5);
	m_JogInc = new wxStaticText( itemPanel370, wxID_STATIC, _("0.1000"), wxDefaultPosition, wxDefaultSize, 0 );
	m_JogInc->SetFont(wxFont(12, wxFONTFAMILY_SWISS, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD, false, wxNORMAL_FONT->GetFaceName()));
	itemBoxSizer402->Add(m_JogInc, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer404 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer402->Add(itemBoxSizer404, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);
	wxStaticText* itemStaticText405 = new wxStaticText( itemPanel370, wxID_STATIC, _("Cont."), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer404->Add(itemStaticText405, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT|wxTOP|wxBOTTOM, 2);

	m_ledJogCont = new wxLed( itemPanel370, ID_LED7, wxDefaultPosition, wxSize(20, 20) );
	itemBoxSizer404->Add(m_ledJogCont, 0, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	wxStaticText* itemStaticText407 = new wxStaticText( itemPanel370, wxID_STATIC, _("Step"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer404->Add(itemStaticText407, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledJogStep = new wxLed( itemPanel370, ID_LED8, wxDefaultPosition, wxSize(20, 20) );
	m_ledJogStep->Enable(false);
	itemBoxSizer404->Add(m_ledJogStep, 0, wxALIGN_CENTER_VERTICAL|wxALL, 0);

	m_jogfocusbutton = new wxButton( itemPanel370, ID_JOGFOCUSBUTTON, _("Keyboard Jog \nOff"), wxDefaultPosition, wxSize(10, 10), wxWANTS_CHARS );
	if (wxMachS::ShowToolTips())
		m_jogfocusbutton->SetToolTip(_("Press to enable keayboard jogging, Jogging is active when Green"));
	itemBoxSizer398->Add(m_jogfocusbutton, 1, wxGROW|wxALL, 5);

	itemNotebook314->AddPage(itemPanel370, _("Jogging"));

	itemBoxSizer306->Add(itemNotebook314, 2, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

	m_toolInfo = new wxStaticBox(itemPanel32, wxID_ANY, _("Tool Information"));
	m_toolInfoS = new wxStaticBoxSizer(m_toolInfo, wxVERTICAL);
	itemBoxSizer306->Add(m_toolInfoS, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer411 = new wxBoxSizer(wxHORIZONTAL);
	m_toolInfoS->Add(itemBoxSizer411, 0, wxALIGN_CENTER_HORIZONTAL, 5);

	wxStaticText* itemStaticText412 = new wxStaticText( m_toolInfoS->GetStaticBox(), wxID_STATIC, _("Tool:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer411->Add(itemStaticText412, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_tool_num = new wxTextCtrl( m_toolInfoS->GetStaticBox(), ID_TOOL_NUM, wxEmptyString, wxDefaultPosition, wxSize(30, -1), wxTE_PROCESS_ENTER );
	itemBoxSizer411->Add(m_tool_num, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText414 = new wxStaticText( m_toolInfoS->GetStaticBox(), wxID_STATIC, _("Change Tool"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer411->Add(itemStaticText414, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_ledToolChange = new wxLed( m_toolInfoS->GetStaticBox(), ID_LED4, wxDefaultPosition, wxSize(20, 20) );
	m_ledToolChange->Enable(false);
	itemBoxSizer411->Add(m_ledToolChange, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxFlexGridSizer* itemFlexGridSizer416 = new wxFlexGridSizer(2, 2, 0, 0);
	m_toolInfoS->Add(itemFlexGridSizer416, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticText* itemStaticText417 = new wxStaticText( m_toolInfoS->GetStaticBox(), wxID_STATIC, _("Diameter:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer416->Add(itemStaticText417, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_toolDiameter = new wxTextCtrl( m_toolInfoS->GetStaticBox(), ID_TEXTCTRL3, wxEmptyString, wxDefaultPosition, wxSize(50, -1), wxTE_READONLY );
	itemFlexGridSizer416->Add(m_toolDiameter, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxStaticText* itemStaticText419 = new wxStaticText( m_toolInfoS->GetStaticBox(), wxID_STATIC, _("Height:"), wxDefaultPosition, wxDefaultSize, 0 );
	itemFlexGridSizer416->Add(itemStaticText419, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	m_toolHeight = new wxTextCtrl( m_toolInfoS->GetStaticBox(), ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxSize(50, -1), wxTE_READONLY );
	itemFlexGridSizer416->Add(m_toolHeight, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxButton* itemButton421 = new wxButton( m_toolInfoS->GetStaticBox(), ID_BUTTON26, _("Auto Tool Zero"), wxDefaultPosition, wxDefaultSize, 0 );
	m_toolInfoS->Add(itemButton421, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer422 = new wxBoxSizer(wxHORIZONTAL);
	m_toolInfoS->Add(itemBoxSizer422, 0, wxALIGN_CENTER_HORIZONTAL, 5);

	wxButton* itemButton423 = new wxButton( m_toolInfoS->GetStaticBox(), ID_REMEMBER_BUTTON, _("Remember"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer422->Add(itemButton423, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxButton* itemButton424 = new wxButton( m_toolInfoS->GetStaticBox(), ID_RETURN_BUTTON, _("Return"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer422->Add(itemButton424, 0, wxALIGN_CENTER_VERTICAL|wxALL, 2);

#endif

	wxBoxSizer* itemBoxSizer425 = new wxBoxSizer(wxHORIZONTAL);
	m_toolInfoS->Add(itemBoxSizer425, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticText* itemStaticText426 = new wxStaticText( m_toolInfoS->GetStaticBox(), wxID_STATIC, _("Feed Hold"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer425->Add(itemStaticText426, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_ledFeedHold = new wxLed( m_toolInfoS->GetStaticBox(), ID_LED6, wxDefaultPosition, wxSize(20, 20) );
	m_ledFeedHold->Enable(false);
	itemBoxSizer425->Add(m_ledFeedHold, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxStaticBox* itemStaticBoxSizer428Static = new wxStaticBox(itemPanel32, wxID_ANY, _("Feed Rate"));
	wxStaticBoxSizer* itemStaticBoxSizer428 = new wxStaticBoxSizer(itemStaticBoxSizer428Static, wxHORIZONTAL);
	itemBoxSizer306->Add(itemStaticBoxSizer428, 1, wxGROW|wxALL, 2);

	wxBoxSizer* itemBoxSizer429 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer428->Add(itemBoxSizer429, 1, wxGROW|wxALL, 0);

	wxStaticText* itemStaticText430 = new wxStaticText( itemStaticBoxSizer428->GetStaticBox(), wxID_STATIC, _("Rapid FRO%"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer429->Add(itemStaticText430, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	m_RRO_Slider = new wxSlider( itemStaticBoxSizer428->GetStaticBox(), ID_SLIDER, 100, 0, 100, wxDefaultPosition, wxSize(-1, 100), wxSL_VERTICAL|wxSL_LABELS|wxSL_INVERSE );
	itemBoxSizer429->Add(m_RRO_Slider, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer432 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer428->Add(itemBoxSizer432, 1, wxGROW|wxALL, 0);

	wxStaticText* itemStaticText433 = new wxStaticText( itemStaticBoxSizer428->GetStaticBox(), wxID_STATIC, _("FRO%"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer432->Add(itemStaticText433, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	m_FRO_Slider = new wxSlider( itemStaticBoxSizer428->GetStaticBox(), ID_SLIDER1, 100, 0, 250, wxDefaultPosition, wxSize(-1, 100), wxSL_VERTICAL|wxSL_LABELS|wxSL_INVERSE );
	itemBoxSizer432->Add(m_FRO_Slider, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticBox* itemStaticBoxSizer435Static = new wxStaticBox(itemPanel32, wxID_ANY, _("Spindle"));
	wxStaticBoxSizer* itemStaticBoxSizer435 = new wxStaticBoxSizer(itemStaticBoxSizer435Static, wxHORIZONTAL);
	itemBoxSizer306->Add(itemStaticBoxSizer435, 1, wxGROW|wxALL, 2);

#if defined(MACHPRO)
	wxBoxSizer* itemBoxSizer436 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer435->Add(itemBoxSizer436, 0, wxGROW|wxALL, 0);

	wxStaticText* itemStaticText437 = new wxStaticText( itemStaticBoxSizer435->GetStaticBox(), wxID_STATIC, _("SRO%"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer436->Add(itemStaticText437, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	m_Spindle_Slider = new wxSlider( itemStaticBoxSizer435->GetStaticBox(), ID_SLIDER2, 100, 0, 250, wxDefaultPosition, wxDefaultSize, wxSL_VERTICAL|wxSL_LABELS|wxSL_INVERSE );
	itemBoxSizer436->Add(m_Spindle_Slider, 1, wxGROW|wxALL, 5);

#endif

	wxBoxSizer* itemBoxSizer439 = new wxBoxSizer(wxVERTICAL);
	itemStaticBoxSizer435->Add(itemBoxSizer439, 1, wxALIGN_CENTER_VERTICAL|wxALL, 2);

	wxBoxSizer* itemBoxSizer440 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer439->Add(itemBoxSizer440, 0, wxALIGN_CENTER_HORIZONTAL|wxBOTTOM, 2);

	m_spindleCW = new wxButton( itemStaticBoxSizer435->GetStaticBox(), ID_SPINDLE_CW, _("Spindle CW"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer440->Add(m_spindleCW, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	m_ledSpindleOn2 = new wxLed( itemStaticBoxSizer435->GetStaticBox(), ID_LED54, wxDefaultPosition, wxSize(20, 20) );
	m_ledSpindleOn2->Enable(false);
	itemBoxSizer440->Add(m_ledSpindleOn2, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 2);

	// Set validators
	m_line_number->SetValidator( wxTextValidator(wxFILTER_NUMERIC) );
	m_jogRateText->SetValidator( wxTextValidator(wxFILTER_NUMERIC) );
	m_tool_num->SetValidator( wxTextValidator(wxFILTER_NUMERIC) );
	// Connect events and objects
	itemPanel32->Connect(ID_PANEL, wxEVT_KEY_DOWN, wxKeyEventHandler(wxMachS::OnKeyDown), NULL, this);
	itemPanel32->Connect(ID_PANEL, wxEVT_KEY_UP, wxKeyEventHandler(wxMachS::OnKeyUp), NULL, this);
	m_opTabs->Connect(ID_NOTEBOOK, wxEVT_KEY_DOWN, wxKeyEventHandler(wxMachS::OnKeyDown), NULL, this);
	m_opTabs->Connect(ID_NOTEBOOK, wxEVT_KEY_UP, wxKeyEventHandler(wxMachS::OnKeyUp), NULL, this);
	m_btnLoadWizards->Connect(ID_BUTTON48, wxEVT_SIZE, wxSizeEventHandler(wxMachS::OnSize), NULL, this);
	m_runTP->Connect(ID_PANEL11, wxEVT_CREATE, wxWindowCreateEventHandler(wxMachS::Onm_runTPCreate), NULL, this);
	m_MdiCmds->Connect(ID_MDI_TEXT, wxEVT_CHAR, wxKeyEventHandler(wxMachS::OnMdiTextChar), NULL, this);
	itemButton310->Connect(ID_FEEDHOLD, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnFeedHoldClickDown), NULL, this);
#if defined(MACHPRO)
	itemButton374->Connect(ID_JOG_APOS, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownAPos), NULL, this);
	itemButton374->Connect(ID_JOG_APOS, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpAPos), NULL, this);
#endif
#if defined(MACHPRO)
	itemButton376->Connect(ID_JOG_ANEG, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownANeg), NULL, this);
	itemButton376->Connect(ID_JOG_ANEG, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpANeg), NULL, this);
#endif
	itemButton380->Connect(ID_JOG_YPOS, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownYPos), NULL, this);
	itemButton380->Connect(ID_JOG_YPOS, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpYPos), NULL, this);
	itemButton383->Connect(ID_JOG_XNEG, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownXNeg), NULL, this);
	itemButton383->Connect(ID_JOG_XNEG, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpXneg), NULL, this);
	itemButton384->Connect(ID_JOG_XPOS, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownXPos), NULL, this);
	itemButton384->Connect(ID_JOG_XPOS, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpXPos), NULL, this);
	itemButton387->Connect(ID_JOG_YNEG, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownYNeg), NULL, this);
	itemButton387->Connect(ID_JOG_YNEG, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpYNeg), NULL, this);
	itemButton390->Connect(ID_JOG_ZPOS, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownZPos), NULL, this);
	itemButton390->Connect(ID_JOG_ZPOS, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpZPos), NULL, this);
	itemButton392->Connect(ID_JOG_ZNEG, wxEVT_LEFT_DOWN, wxMouseEventHandler(wxMachS::OnLeftDownZNeg), NULL, this);
	itemButton392->Connect(ID_JOG_ZNEG, wxEVT_LEFT_UP, wxMouseEventHandler(wxMachS::OnLeftUpZNeg), NULL, this);
	m_jogRateText->Connect(ID_JOG_RATE_TEXT, wxEVT_KILL_FOCUS, wxFocusEventHandler(wxMachS::OnJogRateTextKillFocus), NULL, this);
	m_jogfocusbutton->Connect(ID_JOGFOCUSBUTTON, wxEVT_KEY_DOWN, wxKeyEventHandler(wxMachS::OnKeyDown), NULL, this);
	m_jogfocusbutton->Connect(ID_JOGFOCUSBUTTON, wxEVT_KEY_UP, wxKeyEventHandler(wxMachS::OnKeyUp), NULL, this);
	m_jogfocusbutton->Connect(ID_JOGFOCUSBUTTON, wxEVT_SET_FOCUS, wxFocusEventHandler(wxMachS::OnSetFocus), NULL, this);
	m_jogfocusbutton->Connect(ID_JOGFOCUSBUTTON, wxEVT_KILL_FOCUS, wxFocusEventHandler(wxMachS::OnKillFocus), NULL, this);
////@end wxMachS content construction

	// Log window
	m_log = new mcLog(this);
	
	m_RunDRO0->Connect(m_RunDRO0->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_RunDRO1->Connect(m_RunDRO1->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_RunDRO2->Connect(m_RunDRO2->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_mdiDRO0->Connect(m_mdiDRO0->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_mdiDRO1->Connect(m_mdiDRO1->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_mdiDRO2->Connect(m_mdiDRO2->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_tpDRO0->Connect(m_tpDRO0->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_tpDRO1->Connect(m_tpDRO1->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
	m_tpDRO2->Connect(m_tpDRO2->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEvent), NULL, this);
#ifdef MACHPRO
	m_RunDRO3->Connect(m_RunDRO3->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEventA), NULL, this);
	m_mdiDRO3->Connect(m_mdiDRO3->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEventA), NULL, this);
	m_tpDRO3->Connect(m_tpDRO3->GetId(), wxEVT_MCDRO_ENTER, mcDroEventHandler(wxMachS::OnDroEventA), NULL, this);
#endif

	// Keep DROs on MDI screen from conforming to the label length.
	m_mdiDRO0->SetMinSize(wxSize(160, 35));
	m_mdiDRO1->SetMinSize(wxSize(160, 35));
	m_mdiDRO2->SetMinSize(wxSize(160, 35));
#ifdef MACHPRO
	m_mdiDRO3->SetMinSize(wxSize(160, 35));
#endif

	// Don't allow to go smaller than this.
	SetMinSize(wxSize(1024, 768));
	
	wxSizeEvent evt;
	m_StatusBar->OnSize(evt);
	wxString prof = _("Profile: ") + m_profileName;
	m_StatusBar->SetStatusText(prof, 2);

	if (m_JogIndex >= NUMBJOGINCS) {
		m_JogIndex = 0;
	}
	
	m_KB_joggingEnabled = false;
#ifdef MACHPRO
	m_ledToolChange->Enable(false);
#endif
}

void wxMachS::OnInitDialog(wxInitDialogEvent &event)
{
	wxUnusedVar(event);
	Update();
	::wxSetCursor(wxCursor(wxCURSOR_WAIT));
	int rc = mcCntlInit(wxToChar(m_profileName), 0, MC_INITFLAGS_NONE, "");
	if (rc != MERROR_NOERROR) {
		m_apiInit = false;
		wxMessageBox(_("Error initializing the core!"), _("Error!"));
		Destroy();
		return;
	}

	m_apiInit = true;

	mcGuiSetCallback(0, &mcGUIMsg);
	doGetLicenseData();
	m_timer = new wxTimer(this, ID_TIMER);
	Connect(m_timer->GetId(), wxEVT_TIMER, wxTimerEventHandler(wxMachS::OnTimer), NULL, this);
	m_enableTimer = new wxTimer(this, ID_ENABLE_TIMER);
	Connect(m_enableTimer->GetId(), wxEVT_TIMER, wxTimerEventHandler(wxMachS::OnEnableTimer), NULL, this);
#if defined(MACHPRO)
	m_plcTimer = new wxTimer(this, wxID_ANY);
	Connect(m_plcTimer->GetId(), wxEVT_TIMER, wxTimerEventHandler(wxMachS::OnPlcTimer), NULL, this);
#endif

#ifdef __WXGTK__
	// We have to show the main frame in order to get a OpenGL context!!!
	this->Show();
#endif 

	// Make the title bar show the Mach version.
	unsigned long long i = 0;
	mcCntlGetLicenseModules(0, &i);

	int index = 0;
	long dataLen = 0;
	wxString customName;
	while (mcCntlGetLicenseDataLen(0, index, &dataLen) == MERROR_NOERROR) {
		char *dataBuf = (char *)malloc(dataLen + 1);
		mcCntlGetLicenseData(0, index, dataBuf, dataLen + 1);
		wxString dataItem = wxString::FromUTF8(dataBuf);
		if (dataItem.Left(15).Lower() == "oemproductname=") {
			dataItem.Replace(dataItem.Left(15), wxEmptyString, false);
			if (dataItem != wxEmptyString) {
				customName = dataItem;
			}
		}
		index++;
	}

	wxString SoftwareName = GetLabel();
	if (customName != wxEmptyString) {
		SoftwareName += " - ";
		SoftwareName += customName;
	} else if (i & MC_LIC_PRO) {
		SoftwareName += _(" - Pro");
	} else if (i & MC_LIC_LITE) {
		SoftwareName += _(" - Lite");
	} else if (i & MC_LIC_SIM_ONLY) {
		SoftwareName += _(" - Simulator");
	} else {
		SoftwareName += _(" - Demo");
	}

	SetLabel(SoftwareName);

	HMCREG hReg = 0;
	if (mcRegGetHandle(0, "core/global/GuiName", &hReg) == MERROR_NOERROR) {
		mcRegSetValueString(hReg, wxToChar(SoftwareName));
	}

	//CreatePluginMenu();
	CreateDiagMenu();
	GetJogIncs();
	GetDefaultModes();
	GetSpindleDelays();
	GetMRU();
	CreateMruMenu();
	mcCntlEnable(0, false);

	DisplayJogInc();

	char zstr[MAX_PATH];
	memset(zstr, 0, MAX_PATH);
	// Saved current increment
	mcProfileGetString(0, "Preferences", "LastWizard", zstr, sizeof(zstr), "");
	m_lastWizard = wxString::FromUTF8(zstr);

	// Operator Auto Calc
	long autoCalc = 0;
	mcProfileGetInt(0, "Preferences", "AutoCalc", &autoCalc, 0);
	this->SetAutoCalcEnable(autoCalc != 0 ? true : false);

	DoGetLastError();
#if 0
	HMCSIG hSig;
	HMCIO hIo;

	mcSignalGetHandle(0, ISIG_ACTIVATION1, &hSig);
	mcIoGetHandle(0, "Parallel0/Input1", &hIo);
	mcSignalMap(hSig, hIo);
	mcSignalEnable(hSig, true);

	mcSignalGetHandle(0, OSIG_OUTPUT1, &hSig);
	mcIoGetHandle(0, "Parallel0/Output1", &hIo);
	mcSignalMap(hSig, hIo);
	mcSignalEnable(hSig, true);
#endif 

#ifdef _WIN32
	bool trc = false;
	trc = m_runTP->Show();
	trc = m_mdiTP->Show();
	trc = m_tpTP->Show();
	//wxMessageBox(wxT("Connecting toolpath"));
	mcToolPathCreate(0, m_runTP->GetHWND());
	mcToolPathCreate(0, m_mdiTP->GetHWND());
	mcToolPathCreate(0, m_tpTP->GetHWND());
	//wxMessageBox(wxT("Connecting toolpathDone"));
#endif
#ifdef __WXGTK__
	//void *xid = GetXid(Panel1);
	mcToolPathCreate(0, m_runTP);
	mcToolPathCreate(0, m_mdiTP);
	mcToolPathCreate(0, m_tpTP);
#endif
	char buf[MAX_PATH];
	memset(buf, 0, MAX_PATH);
	mcCntlGetMachDir(0, buf, MAX_PATH - 1);
	m_machDir = wxString::FromUTF8(buf);
	wxString tableFile;
	
	tableFile = m_machDir + DIRSEP + wxT("Profiles") + DIRSEP + m_profileName + DIRSEP + wxT("ToolTables") + DIRSEP + wxT("tooltable.tls");
	memset(buf, 0, MAX_PATH);
	mcProfileGetString(0, "Preferences", "ToolTable", buf, MAX_PATH - 1, wxToChar(tableFile));
	mcToolLoadFile(0, buf);

	tableFile = m_machDir + DIRSEP + wxT("Profiles") + DIRSEP + m_profileName + DIRSEP + wxT("FixtureTables") + DIRSEP + wxT("fixturetable.tls");
	memset(buf, 0, MAX_PATH);
	mcProfileGetString(0, "Preferences", "FixtureTable", buf, MAX_PATH - 1, wxToChar(tableFile));
	mcFixtureLoadFile(0, buf);

	m_timer->Start(50);
	if (m_plcInterval != 0) {
		wxString plcScript = m_machDir + DIRSEP + wxT("Profiles") + DIRSEP + m_profileName + DIRSEP + wxT("MachPlc.mcs");
		if (ReadPlcScript(plcScript)) {
			m_plcTimer->Start(m_plcInterval, true);
		}
	}
	::wxSetCursor(wxNullCursor);


	char str_devname[80];
	rc = 0;
	mcProfileGetString(0, "Preferences", "MotionDevice", str_devname, 80, "");
	if (!strcmp(str_devname, "")) {
		SelDev *sel = new SelDev(this);
		rc = sel->ShowModal();
		sel->Destroy();
		if (rc == wxID_OK) {
			// Init motion dev here.
		}
	}
	mcProfileGetString(0, "Preferences", "MotionDevice", str_devname, 80, "");
	if (strcmp(str_devname, "")) {
		m_mdevSelected = true;
	}
}

/*
 * Should we show tooltips?
 */
bool wxMachS::ShowToolTips()
{
	return(true);
}

/*
 * Get bitmap resources
 */
wxBitmap wxMachS::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin wxMachS bitmap retrieval
	wxUnusedVar(name);
	if (name == wxT("up.xpm"))
	{
		wxBitmap bitmap(up_xpm);
		return bitmap;
	}
	else if (name == wxT("down.xpm"))
	{
		wxBitmap bitmap(down_xpm);
		return bitmap;
	}
	return wxNullBitmap;
////@end wxMachS bitmap retrieval
}

/*
 * Get icon resources
 */
wxIcon wxMachS::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin wxMachS icon retrieval
	wxUnusedVar(name);
	if (name == wxT("MachGroupLogoOnly-32.xpm"))
	{
		wxIcon icon(MachGroupLogoOnly_32_xpm);
		return icon;
	}
	return wxNullIcon;
////@end wxMachS icon retrieval
}

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM
 */
void wxMachS::OnFileExitClick(wxCommandEvent& WXUNUSED(event) )
{
	// Before editing this code, remove the block markers.
	if (Exit()) {
		Destroy();
	}
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_SINGLE_BLOCK
 */
void wxMachS::OnBtnSingleBlockClick( wxCommandEvent& event )
{
	event.Skip();
	wxUnusedVar(event);
	BOOL sb;
	m_ledSingleBlock->Enable(m_ledSingleBlock->IsEnabled() ? false : true);
	mcCntlGetSingleBlock(0, &sb);
	BOOL bsb = (sb != 0)  ? false : true;
	mcCntlSetSingleBlock(0, bsb);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON22
 */
void wxMachS::OnRecentFileClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	RecentFile *rf = new RecentFile(this);
	rf->SetFileList(m_recentFiles);
	int rc = rf->ShowModal();
	if (rc == wxID_OK) {
		wxString fp = rf->GetPath();
		if (fp != wxEmptyString) {
			DoFileClose();
			LoadGcodeFromPath(fp, 0);
		}
	}
	rf->Destroy();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON24
 */
void wxMachS::OnButtonLoadGcodeClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	DoFileOpen();
}

void wxMachS::DoFileOpen(void)
{
	wxString CWD = wxGetCwd();
	
	// Get Last Path
	char lastDir[MAX_PATH];
	memset(lastDir, 0, MAX_PATH);
	mcProfileGetString(0, "Preferences", "LastOpenDir", lastDir, MAX_PATH, wxToChar(CWD));
	CWD = wxString::FromUTF8(lastDir);

	wxString wildcard = _("G code files (") + m_fileExtensions + _(")|") + m_fileExtensions + _("|Text files (*.txt)|*.txt|All files (*)|*");
	m_fileDialog = new wxFileDialog(this, _("Select file"), CWD, wxEmptyString, wildcard, wxFD_DEFAULT_STYLE, wxDefaultPosition, wxDefaultSize, _T("wxFileDialog"));

	if (m_fileDialog->ShowModal() == wxID_CANCEL) {
		m_fileDialog->Destroy();
		return;
	}
	DoFileClose();
	wxString fn = m_fileDialog->GetPath();
	// Save last path.
	wxFileName tfn(fn);
	mcProfileWriteString(0, "Preferences", "LastOpenDir", wxToChar(tfn.GetPath()));

	// Begin MRU stuff.
	bool found = false;
	for (size_t idx = 0; idx < m_recentFiles.GetCount(); idx++) {
		if (m_recentFiles[idx] == fn) {
			found = true;
			break;
		}
	}
	if (!found) {
		if (m_recentFiles.GetCount() == 10) {
			m_recentFiles.RemoveAt(9);
		}
		m_recentFiles.Insert(fn, 0);
	}
	CreateMruMenu();
	// End MRU stuff.

	LoadGcodeFromPath(fn, 0);
	m_fileDialog->Destroy();
}

void wxMachS::LoadGcodeFromPath(wxString path, int mInst)
{
	int rc = 0;
	wxString emsg;
//	m_currentFile->SetLabel(path);
	rc = mcCntlLoadGcodeFile(mInst, wxToChar(path));
	if (rc != MERROR_NOERROR) {
		switch (rc) {
		case MERROR_FILE_EXCEPTION:
			emsg.Printf(_("A general failure occured while loading %s."), m_currentFile->GetLabel());
			break;
		case MERROR_FILE_EMPTY:
			emsg.Printf(_("The file %s is empty!"), m_currentFile->GetLabel());
			break;
		case MERROR_FILE_SHARING:
			emsg.Printf(_("A sharing violation occured while loading %s"), m_currentFile->GetLabel());
			break;
		case MERROR_FILE_INVALID:
			emsg.Printf(_("The file %s is invalid!"), m_currentFile->GetLabel());
			break;
		case MERROR_FILE_BADSIZE:
			emsg.Printf(_("Cannot determin the size of file %s."), m_currentFile->GetLabel());
			break;
		case MERROR_NOT_NOW:
			emsg.Printf(_("The control can't load a file at this time."));
			break;
		default:
			emsg.Printf(_("Error %d while loading file %s."), rc, m_currentFile->GetLabel());
		}
		wxMessageBox(emsg, _("Load Error"));
	} 
}

void DoSetJogInc(MINSTANCE inst, double inc)
{
	for (int axisId = 0; axisId < MC_MAX_COORD_AXES; axisId++) {
		mcJogSetInc(inst, axisId, inc);
	}
}

void wxMachS::DoToolPath(void)
{
	int returnValue = 0;
	ToolPathProgress *tpp = new ToolPathProgress(this);
	if (!tpp->dontShow) {
		returnValue = tpp->ShowModal();
	}
	wxUnusedVar(returnValue);
	tpp->Destroy();
}

void wxMachS::DoRunFromHere(void)
{
	int returnValue = 0;
	RunFromHere *rfh = new RunFromHere(this);
	returnValue = rfh->Show();
	wxUnusedVar(returnValue);
	//rfh->Destroy();
}

/*
 * wxEVT_CREATE event handler for ID_PANEL3
 */
void wxMachS::Onm_runTPCreate( wxWindowCreateEvent& event )
{
	wxUnusedVar(event);
	event.Skip();
}

void wxMachS::OnEnableTimer(wxTimerEvent& event)
{
	wxUnusedVar(event);
	static bool green = false;
	if (green) {
		m_enableControl->SetBackgroundColour(wxColor(wxT("#00FF00")));
	} else {
		m_enableControl->SetBackgroundColour(wxNullColour);
	}
	green = !green;
	m_enableControl->Refresh();
}

static char logbuf[2048];
#define G_CODE_MODES 15

wxString GetModals(MINSTANCE mInst)
{
	wxString modes;
	wxString tmp;
	double d;
	for (int idx = 0; idx < G_CODE_MODES; idx++) {
		mcCntlGetModalGroup(mInst, idx, &d);
		if (d != 0) {
			if (d == (int)d) {
				tmp.Printf(wxT("G%.0f "), d);
			} else {
				tmp.Printf(wxT("G%.1f "), d);
			}
			modes = modes + tmp;
		}
	}
	return(modes);
}

void wxMachS::OnTimer(wxTimerEvent& event)
{
	event.Skip();
	double droval;
	wxString drostr;
	wxUnusedVar(event);
	static size_t CurrentLine = 0;

	mcCntlGetState(0, &m_state);
	mcCntlGetStateName(0, m_state, logbuf, sizeof(logbuf) - 1);
	wxString stateName = wxString::FromUTF8(logbuf);
	if (m_machState->GetValue() != stateName) {
		m_machState->SetValue(stateName);
	}

	wxString modes = GetModals(0);
	if (m_modals->GetValue() != modes) {
		m_modals->SetValue(modes);
	}

#ifdef _WIN32
	if (m_runTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_runTP->GetHWND());
	}
	if (m_mdiTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_mdiTP->GetHWND());
	}
	if (m_tpTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_tpTP->GetHWND());
	}
#else
	if (m_runTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_runTP);
	}
	if (m_mdiTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_mdiTP);
	}
	if (m_tpTP->IsShownOnScreen()) {
		mcToolPathUpdate(0, m_tpTP);
	}
#endif
	wxMilliSleep(1);
	if (m_log->GetLogging()) {
		while (mcCntlGetLastLogMsg(0, logbuf, sizeof(logbuf) - 1) == MERROR_NOERROR) {
			m_log->Log(wxString::FromUTF8(logbuf));
		}
	}
	BOOL inCycle = 0;
	mcCntlIsInCycle(0, &inCycle);
	if (inCycle != 0) {
		long line = 0;
		mcCntlGetGcodeLineNbr(0, &line);
		if (line != -1) {
			if (CurrentLine != (size_t)line) {
				CurrentLine = (size_t)line;
				wxString tmp = wxString::Format(wxT("%d"), CurrentLine + 1);
				m_line_number->SetValue(tmp);
				// Program Run listbox
				m_PrListBox->SetSelection(-1);
				size_t linecnt = (m_PrListBox->GetVisibleEnd() - 1) - m_PrListBox->GetVisibleBegin();
				size_t midline = linecnt / 2;
				if (CurrentLine > midline) {
					m_PrListBox->ScrollToRow(CurrentLine - midline);
				}
				size_t cnt = m_PrListBox->GetItemCount();
				if (CurrentLine >= 0 && CurrentLine < cnt) {
					m_PrListBox->SetSelection((int)CurrentLine);
				}
				// Tool Path listbox
				m_TpListBox->SetSelection(-1);
				linecnt = (m_TpListBox->GetVisibleEnd() - 1) - m_TpListBox->GetVisibleBegin();
				midline = linecnt / 2;
				if (CurrentLine > midline) {
					m_TpListBox->ScrollToRow(CurrentLine - midline);
				}
				cnt = m_PrListBox->GetItemCount();
				if (CurrentLine >= 0 && CurrentLine < cnt) {
					m_TpListBox->SetSelection((int)CurrentLine);
				}
			}
		}
	} 
#if 0
	mcCntlGetGcodeLineNbr(0, &droval);
	drostr.Printf(wxT("%0.0f"), droval);
	m_line_number->SetValue(drostr);
#endif
	bool enabled = false;
	wxUnusedVar(enabled);
	if (m_ledDistToGO->IsEnabled()) {
		mcCntlGetDistToGo(0, 0, &droval);
		ConvertUnits(&droval);
	} else if (m_ledMachCoords->IsEnabled()) {
		mcAxisGetMachinePos(0, 0, &droval);
	} else {
		mcAxisGetPos(0, 0, &droval);
		ConvertUnits(&droval);
	}
	drostr.Printf(wxT("%0.4f"), droval);
	m_RunDRO0->SetLabel(drostr);
	m_mdiDRO0->SetLabel(drostr);
	m_tpDRO0->SetLabel(drostr);

	if (m_ledDistToGO->IsEnabled()) {
		mcCntlGetDistToGo(0, 1, &droval);
		ConvertUnits(&droval);
	} else if (m_ledMachCoords->IsEnabled()) {
		mcAxisGetMachinePos(0, 1, &droval);
	} else {
		mcAxisGetPos(0, 1, &droval);
		ConvertUnits(&droval);
	}
	drostr.Printf(wxT("%0.4f"), droval);

	m_RunDRO1->SetLabel(drostr);
	m_mdiDRO1->SetLabel(drostr);
	m_tpDRO1->SetLabel(drostr);

	if (m_ledDistToGO->IsEnabled()) {
		mcCntlGetDistToGo(0, 2, &droval);
		ConvertUnits(&droval);
	} else if (m_ledMachCoords->IsEnabled()) {
		mcAxisGetMachinePos(0, 2, &droval);
	} else {
		mcAxisGetPos(0, 2, &droval);
		ConvertUnits(&droval);
	}
	drostr.Printf(wxT("%0.4f"), droval);
	m_RunDRO2->SetLabel(drostr);
	m_mdiDRO2->SetLabel(drostr);
	m_tpDRO2->SetLabel(drostr);

	int r=0;
	if (m_ledDistToGO->IsEnabled()) {
		r = mcCntlGetDistToGo(0, 3, &droval);
	} else if (m_ledMachCoords->IsEnabled()) {
		r = mcAxisGetMachinePos(0, 3, &droval);
	} else {
		r = mcAxisGetPos(0, 3, &droval);
	}
	if(r != MERROR_NOERROR){
		droval = 0.0;
	}
	drostr.Printf(wxT("%0.4f"), droval);

#ifdef MACHPRO
	m_RunDRO3->SetLabel(drostr);
	m_mdiDRO3->SetLabel(drostr);
	m_tpDRO3->SetLabel(drostr);
#endif
	double vels[4] = {0,0,0,0};
	for (int i=0; i<4; i++) {
		mcAxisGetVel(0,i,&vels[i]);
	}
	double v = sqrt(pow(vels[0],2) + pow(vels[1],2)+
					pow(vels[2],2) + pow(vels[3],2));
	ConvertUnits(&v);

	drostr.Printf(_("Feed Rate: %.2f"), v);
	m_StatusBar->SetStatusText(drostr, 3);
	mcSpindleGetTrueRPM(0, &droval);
	drostr.Printf(_("RPM: %0.0f"), droval);
	if (m_StatusBar->GetStatusText(4) != drostr) {
		m_StatusBar->SetStatusText(drostr, 4);
	}

#ifdef MACHPRO
	int toolnum = 0;
	static long oldTool = -1;
	mcToolGetCurrent(0, &toolnum);
	if (oldTool != (long)toolnum) {
		m_tool_num->SetValue(wxString::Format(wxT("%d"), toolnum));
		oldTool = toolnum;
	}
#endif

	int range = 0;
	mcSpindleGetCurrentRange(0, &range);
	if (range != m_spinrange->GetValue()) {
		m_spinrange->SetValue(range);
	}

#if 0
	double rad = 0;
	double tdbl;
	mcCntlGetPoundVar(0, CUR_DIA_INDEX, &rad);
	m_toolDiameter->GetValue().ToDouble(&tdbl);
	if (tdbl != rad  || m_toolDiameter->GetValue().IsEmpty()) {
		m_toolDiameter->SetValue(wxString::Format(wxT("%.0f"), rad));
	}
	double length = 0;
	mcCntlGetPoundVar(0, CUR_LENGTH_INDEX, &length);
	m_toolHeight->GetValue().ToDouble(&tdbl);
	if (tdbl != rad || m_toolHeight->GetValue().IsEmpty()) {
		m_toolHeight->SetValue(wxString::Format(wxT("%.0f"), rad));
	}
#endif
	
}

/*
 * wxEVT_SIZE event handler for ID_BUTTON7
 */
void wxMachS::OnSize( wxSizeEvent& event )
{
	if (event.GetId() == ID_PANEL8) {
		int g = 0;
		wxUnusedVar(g);
	}
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON23
 */
void wxMachS::OnButtonCloseGcodeClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	DoFileClose();
}

void wxMachS::DoFileClose(void)
{
	mcCntlCloseGCodeFile(0);
	m_PrListBox->SetItemCount(0);
	m_TpListBox->SetItemCount(0);
	m_currentFile->SetLabel(wxEmptyString);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON43
 */
void wxMachS::OnRegenTpClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	DoToolPath();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON21
 */
void wxMachS::OnFloodClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	BOOL state = 0;
	HMCSIG hSig;
	mcSignalGetHandle(0, OSIG_COOLANTON, &hSig);
	mcSignalGetState(hSig, &state);
	mcSignalSetState(hSig, (state != 0) ? 0 : 1);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON20
 */
void wxMachS::OnButtonOptStopClick( wxCommandEvent& event )
{
	event.Skip();
	m_ledOptStop->Enable(m_ledOptStop->IsEnabled() ? false : true);
	mcCntlSetOptionalStop(0, (m_ledOptStop->IsEnabled() ? 1:0));
	
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON18
 */
#ifdef MACHPRO
void wxMachS::OnButtonRevRunClick( wxCommandEvent& event )
{
	m_ledRevRun->Enable(m_ledRevRun->IsEnabled() ? false : true);
	event.Skip();
}
#endif
/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON6
 */
void wxMachS::OnButtonJogModeClick( wxCommandEvent& event )
{
	HMCSIG hSig = 0;
	m_ledJogCont->Enable(m_ledJogCont->IsEnabled() ? false : true);
	m_ledJogStep->Enable(!m_ledJogCont->IsEnabled());
	mcSignalGetHandle(0, OSIG_JOG_CONT, &hSig);
	mcSignalSetState(hSig, m_ledJogCont->IsEnabled() ? 1 : 0);
	mcSignalGetHandle(0, OSIG_JOG_INC, &hSig);
	mcSignalSetState(hSig, m_ledJogStep->IsEnabled() ? 1 : 0);

	for (int axis = 0; axis < MC_MAX_COORD_AXES; axis ++) {
		mcJogSetType(0, axis, m_ledJogCont->IsEnabled() ? MC_JOG_TYPE_VEL : MC_JOG_TYPE_INC);
	}
	event.Skip();
}

/*
 * Transfer data to the window
 */
bool wxMachS::TransferDataToWindow()
{
	return (wxFrame::TransferDataToWindow());
}

/*
 * Transfer data from the window
 */
bool wxMachS::TransferDataFromWindow()
{
	return (wxFrame::TransferDataFromWindow());
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON12
 */
void wxMachS::OnCycleStartClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_estop) {
		wxString msg = _("E-Stop is in effect.  Clear the E-Stop condition.");
		mcCntlSetLastError(0, wxToChar(msg));
	} else {
		if (m_opTabs->GetSelection() == 1) {
			if (m_state == MC_STATE_MRUN_FH || m_state == MC_STATE_MRUN_MACROH) {
				mcCntlCycleStart(0);
			} else {
				ExecuteMdi();
			}
		} else {
			mcCntlCycleStart(0);
		}
	}
}

void wxMachS::ExecuteMdi(void)
{
	bool found = false;
	for (size_t index = 0; index < m_MdiCmdsArray.GetCount(); index++) {
		if (m_MdiCmdsArray[index] == m_MdiCmds->GetValue()) {
			found = true;
		}
	}
	if (!found) {
		m_MdiCmdsArray.Add(m_MdiCmds->GetValue());
	}
	int len = (int)m_MdiCmds->GetValue().Len();
	if (len > 0) {
#if 0
		char *str = (char *)malloc(len + 1);
		memset(str, 0, len + 1);
		strncpy(str, wxToChar(m_MdiCmds->GetValue()), len);
		mcCntlMdiExecute(0, str);
		free(str);
#else
		mcCntlMdiExecute(0, wxToChar(m_MdiCmds->GetValue()));
#endif
	}
}
/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON13
 */
void wxMachS::OnStop( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcCntlCycleStop(0);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON16
 */
void wxMachS::OnButtonRewindClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_PrListBox->GetItemCount() > 0) {
		m_PrListBox->SetSelection(0);
		m_TpListBox->SetSelection(0);
	}
	mcCntlRewindFile(0); 
}

/*
 * wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER1
 */
void wxMachS::OnSliderFROUpdated( wxCommandEvent& event )
{
	int val = m_FRO_Slider->GetValue();
	mcCntlSetFRO(0, (double)val);
	event.Skip();
}

/*
 * wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER
 */
void wxMachS::OnSliderRROUpdated( wxCommandEvent& event )
{
	mcCntlSetRRO(0, (double)(m_RRO_Slider->GetValue()) );
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_X_JOG_NEG
 */
void wxMachS::OnLeftDownXNeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 0, MC_JOG_NEG);
	} else {
		mcJogIncStart(0, 0, -m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_X_JOG_NEG
 */
void wxMachS::OnLeftUpXneg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 0);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_X_JOG_POS
 */
void wxMachS::OnLeftDownXPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 0, MC_JOG_POS);
	} else {
		mcJogIncStart(0, 0, m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_X_JOG_POS
 */
void wxMachS::OnLeftUpXPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 0);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_Y_JOG_POS
 */
void wxMachS::OnLeftDownYPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 1, MC_JOG_POS);
	} else {
		mcJogIncStart(0, 1, m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_Y_JOG_POS
 */
void wxMachS::OnLeftUpYPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 1);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_Y_JOG_NEG
 */
void wxMachS::OnLeftDownYNeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 1, MC_JOG_NEG);
	} else {
		mcJogIncStart(0, 1, -m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_Y_JOG_NEG
 */
void wxMachS::OnLeftUpYNeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 1);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_Z_JOG_NPOS
 */
void wxMachS::OnLeftDownZPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 2, MC_JOG_POS);
	} else {
		mcJogIncStart(0, 2, m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_Z_JOG_NPOS
 */
void wxMachS::OnLeftUpZPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 2);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_Z_JOG_NEG
 */
void wxMachS::OnLeftDownZNeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 2, MC_JOG_NEG);
	} else {
		mcJogIncStart(0, 2, -m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_UP event handler for ID_BTN_Z_JOG_NEG
 */
void wxMachS::OnLeftUpZNeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 2);
	}
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_A_JOG_POS
 */
#ifdef MACHPRO
void wxMachS::OnLeftDownAPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 3, MC_JOG_POS);
	} else {
		mcJogIncStart(0, 3, m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}
#endif
/*
 * wxEVT_LEFT_UP event handler for ID_BTN_A_JOG_POS
 */
#ifdef MACHPRO
void wxMachS::OnLeftUpAPos( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 3);
	}
	event.Skip();
}
#endif
/*
 * wxEVT_LEFT_DOWN event handler for ID_BTN_A_JOG_NEG
 */
#ifdef MACHPRO
void wxMachS::OnLeftDownANeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStart(0, 3, MC_JOG_NEG);
	} else {
		mcJogIncStart(0, 3, -m_JogIncArray[m_JogIndex]);
	}
	event.Skip();
}
#endif
/*
 * wxEVT_LEFT_UP event handler for ID_BTN_A_JOG_NEG
 */
#ifdef MACHPRO
void wxMachS::OnLeftUpANeg( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (m_ledJogCont->IsEnabled()) {
		mcJogVelocityStop(0, 3);
	}
	event.Skip();
}
#endif
/*
 * wxEVT_CLOSE_WINDOW event handler for ID_WXMACHS
 */
void wxMachS::OnCloseWindow( wxCloseEvent& event )
{
	wxUnusedVar(event);
	if (Exit()) {
		Destroy();
	}
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_JOG_FOLLOW
 */
void wxMachS::OnBtnJogFollowClick( wxCommandEvent& event )
{
	BOOL r = 0;
	mcToolPathGetFollowMode(0, &r);
	mcToolPathSetFollowMode(0 ,(r != 0 ? 0 : 1) );
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_CYCLE_JOG_STEP
 */
void wxMachS::OnBtnCycleJogStepClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_JogIndex++;
	if (m_JogIndex >= (int)m_JogIncArray.GetCount()) {
		m_JogIndex = 0;
	}
	DisplayJogInc();
	DoSetJogInc(0, m_JogIncArray[m_JogIndex]);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BITMAPBUTTON
 */
void wxMachS::OnMdiUpButtonClick( wxCommandEvent& event )
{
	if (m_MdiCmdsIndex > 1 && m_MdiCmdsArray.GetCount() > 0) {
		m_MdiCmdsIndex--;
	} else {
		m_MdiCmdsIndex = 0;
	}
	if (m_MdiCmdsIndex < m_MdiCmdsArray.GetCount()) {
		m_MdiCmds->SetValue(m_MdiCmdsArray[m_MdiCmdsIndex]);
	}
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BITMAPBUTTON1
 */
void wxMachS::OnMdiDownButtonClick( wxCommandEvent& event )
{
	m_MdiCmdsIndex++;
	if (m_MdiCmdsIndex < m_MdiCmdsArray.GetCount()) {
		m_MdiCmds->SetValue(m_MdiCmdsArray[m_MdiCmdsIndex]);
	} else {
		m_MdiCmdsIndex = m_MdiCmdsArray.GetCount() - 1;
	}
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON8
 */
void wxMachS::OnGotoZeroClick( wxCommandEvent& event )
{
	mcCntlGotoZero(0);
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON47
 */
void wxMachS::OnBtnZeroX( wxCommandEvent& event )
{
	mcAxisSetPos(0,0,0);
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON51
 */
void wxMachS::OnBtnZeroY( wxCommandEvent& event )
{
	mcAxisSetPos(0,1,0);
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON52
 */
void wxMachS::OnBtnZeroZ( wxCommandEvent& event )
{
	mcAxisSetPos(0,2,0);
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON53
 */
#ifdef MACHPRO
void wxMachS::OnBtnZeroA( wxCommandEvent& event )
{
	mcAxisSetPos(0,3,0);
	event.Skip();
}
#endif
/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON46
 */
void wxMachS::OnBtnRefAll( wxCommandEvent& event )
{
	wxUnusedVar(event);
#if 0
	mcMotorSetPos(0,0,0);
	mcMotorSetPos(0,1,0);
	mcMotorSetPos(0,2,0);
	mcMotorSetPos(0,3,0);
#else
	mcAxisHomeAll(0);
//	mcAxisHome(0, 2);  // Z first
//	mcAxisHome(0, 0);
//	mcAxisHome(0, 1);
//	mcAxisHome(0, 3);
#endif
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_DIST_TOGO
 */
void wxMachS::OnBtnDistTogoClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_ledMachCoords->Enable(false);
	m_ledMachCoords2->Enable(false);
	m_ledDistToGO->Enable(m_ledDistToGO->IsEnabled() ? false : true);
	m_ledDistToGO2->Enable(m_ledDistToGO->IsEnabled());
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_MACHINEPOS
 */
void wxMachS::OnBtnMachineposClick( wxCommandEvent& event )
{
	m_ledDistToGO->Enable(false);
	m_ledDistToGO2->Enable(false);
	m_ledMachCoords2->Enable(m_ledMachCoords2->IsEnabled() ? false : true);
	m_ledMachCoords->Enable(m_ledMachCoords2->IsEnabled());
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BTN_SOFTLIMIT
 */
void wxMachS::OnBtnSoftlimitClick( wxCommandEvent& event )
{
	m_ledSoftLimit->Enable(m_ledSoftLimit->IsEnabled() ? false : true);
	for (int i=0;i<3;i++) {
		mcSoftLimitSetState(0, i, (m_ledSoftLimit->IsEnabled() ? 1:0) );
	}
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON15
 */
void wxMachS::OnFeedHoldClick( wxCommandEvent& event )
{
	event.Skip();
}

/*
 * wxEVT_LEFT_DOWN event handler for ID_BUTTON15
 */
void wxMachS::OnFeedHoldClickDown( wxMouseEvent& event )
{
	mcCntlFeedHold(0);
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON17
 */
void wxMachS::OnBtnEditGcode( wxCommandEvent& event )
{
	wxUnusedVar(event);
	wxString s = m_currentFile->GetLabel();
	MINSTANCE mInst = 0;

	char zstr[MAX_PATH];
	mcCntlGetMachDir(mInst, zstr, sizeof(zstr));
	wxString editorPath = zstr;
	editorPath.Append(wxFILE_SEP_PATH);
	editorPath.Append(wxT("gcedit"));

	mcProfileGetString(mInst, "Preferences", "GcodeEditor", zstr, sizeof(zstr), wxToChar(editorPath));
	wxString editor = zstr;

	if(!s.IsEmpty()) {
		DoFileClose();
		wxProcess *p = new MyProcess(this, s, mInst);//wxProcess *process = new wxProcess(wxPROCESS_REDIRECT);
		wxString Cmd = wxString::Format("\"%s\" \"%s\"", editor, s);
		wxString msg = wxString::Format("Executing: %s", Cmd);
		mcLogMsg(mInst, wxToChar(msg), __FILE__, __LINE__);
		#if defined(_WIN32) || defined(_WIN64)
			wxExecute(Cmd, wxEXEC_ASYNC, p);
		#else
			wxExecute(Cmd, wxEXEC_ASYNC, p);
		#endif
	} else {
		wxProcess *p = new MyProcess(this, wxEmptyString, mInst);//wxProcess *process = new wxProcess(wxPROCESS_REDIRECT);
		wxString Cmd = wxString::Format("\"%s\"", editor);
		wxString msg = wxString::Format("Executing: %s", Cmd);
		mcLogMsg(mInst, wxToChar(msg), __FILE__, __LINE__);
		#if defined(_WIN32) || defined(_WIN64)
			wxExecute(Cmd, wxEXEC_ASYNC, p);
		#else
			wxExecute(Cmd, wxEXEC_ASYNC, p);
		#endif
	}
}

void MyProcess::OnTerminate(int pid, int status)
{
	wxUnusedVar(pid);
	wxUnusedVar(status);
	wxMachS *M4 = (wxMachS *)m_parent;
	if (M4 != NULL) {
		if (!m_cmd.IsEmpty()) {
			M4->LoadGcodeFromPath(m_cmd, m_Inst);
		}
	}
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON54
 */
void wxMachS::OnButton54Click( wxCommandEvent& event )
{
	event.Skip();
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON48
 */
void wxMachS::OnButtonLoadWizradsClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	LoadWizards * lw = new LoadWizards(this);
	int rc = lw->ShowModal();
	if (rc == wxID_OK) {
		wxString wizard = lw->GetPath();
		if (wizard != wxEmptyString) {
			m_lastWizard = wizard;
			m_wxlState.lua_PushInteger(0);
			m_wxlState.lua_SetGlobal("__MINSTANCE__");
			m_wxlState.RunFile(wizard);
		}
	}
	lw->Destroy();
	//mcCntlSetValue(0, CMD_EXECUTE_WIZARD, 0, 0);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON50
 */
void wxMachS::OnButtonLastWiszardClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_lastWizard != wxEmptyString) {
		m_wxlState.lua_PushInteger(0);
		m_wxlState.lua_SetGlobal("__MINSTANCE__");
		m_wxlState.RunFile(m_lastWizard);
	}
}

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM1
 */
void wxMachS::OnConfigureMach( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcCntlConfigStart(0);
	IoConfig* window = new IoConfig(0, this);
	int rc = window->ShowModal();
	//window->Destroy();
	mcCntlConfigStop(0);
	// Update the GUI with anything that may have changed in the config.
	if (rc == 0) {
		GetJogIncs();
		GetDefaultModes();
		GetSpindleDelays();
	}
}

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM4
 */
#ifdef MACHPRO
void wxMachS::OnOperatorEditScript( wxCommandEvent& event )
{
	wxUnusedVar(event);
	char exts_buf[1024];
	wxString retval = wxEmptyString;
	wxString CWD = wxGetCwd();
	wxString macroDir = CWD + DIRSEP + wxT("Profiles") + DIRSEP + m_profileName + DIRSEP + wxT("Macros");
	m_fileDialog = new wxFileDialog(NULL, _("Select file"), macroDir, wxEmptyString, _("*.*"), wxFD_DEFAULT_STYLE, wxDefaultPosition, wxDefaultSize, _T("wxFileDialog"));

	if (mcScriptGetExtensions(0, exts_buf, 1024) == MERROR_NOERROR) {
		wxString exts = wxString::FromUTF8(exts_buf);
		wxString wc;

		// eg: "BMP files (*.bmp)|*.bmp|GIF files (*.gif)|*.gif"
		wxStringTokenizer tkz(exts, wxT("|"));
		while (tkz.HasMoreTokens()) {
			wxString token = tkz.GetNextToken();
			wxString wctmp;
			wctmp.Printf(_("%s files (*.%s)|*.%s|"), token.Upper(), token, token);
			wc += wctmp;
		}
		if (wc.EndsWith(wxT("|"), NULL)) {
			wc.RemoveLast();
		}

		m_fileDialog->SetWildcard(wc);

		if (m_fileDialog->ShowModal() == wxID_CANCEL) {
			delete m_fileDialog;
			m_fileDialog = NULL;
			return;
		}
		wxString fn = m_fileDialog->GetPath();
		delete m_fileDialog;
		m_fileDialog = NULL;
		mcScriptDebug(0, wxToChar(fn));
	}
}
#endif
/*
 * wxEVT_COMMAND_TEXT_UPDATED event handler for ID_LINENUM_TEXT
 */
void wxMachS::OnLinenumTextTextUpdated( wxCommandEvent& event )
{
	event.Skip();
}

static char ebuf[2048];
void wxMachS::DoGetLastError(void)
{
	memset(ebuf, 0, sizeof(ebuf));
	while (mcCntlGetLastError(0, ebuf, sizeof(ebuf)) == MERROR_NOERROR) {
		wxString msg = wxString::FromUTF8(ebuf);
		m_StatusBar->SetStatusText(msg, 1);
		if (msg != wxEmptyString) {
			m_statusArray.Insert(msg, m_statusArray.GetCount());
		}
	}
}

void wxMachS::OnGuiMsg(wxGuiMsgEvent &event) 
{
	long msg = event.GetMsg();
	long param1 = event.GetParam1();
	long param2 = event.GetParam2();
	MINSTANCE inst = event.GetInst();
	wxUnusedVar(inst);
	long count = 0;

	switch (msg) {
	case MSG_GCODE_LINE:
//		if (param2) {  //  In cycle?
			m_PrListBox->SetSelection(param1);
			m_TpListBox->SetSelection(param1);
//		}
		m_line_number->SetValue(wxString::Format(wxT("%d"), param1 + 1));
		break;
	case MSG_GCODE_VAR_CHANGED:
		if (m_fixtureOffsets) {
			m_fixtureOffsets->UpdateParameter(param1);
		}
		break;
	case MSG_CYCLE_START:
		m_StatusBar->SetStatusText(wxEmptyString, 1);
		break;
	case MSG_GCODE_MESSAGE:
		DoGetLastError();
		break;
	case MSG_REWIND_FILE:
		if (m_PrListBox->GetItemCount() > 0) {
			m_PrListBox->SetSelection(0);
		}
		if (m_TpListBox->GetItemCount() > 0) {
			m_TpListBox->SetSelection(0);
		}
		break;
	case MSG_ENABLE:
		//m_enableControl->Enable(true);
		m_enabling = false;
		if (param1 == 0) {
			m_enableControl->SetLabel(_("Enable"));
			m_enableTimer->Start(500);
			m_enabled = false;
		} else {
			m_enableTimer->Stop();
			m_enableControl->SetLabel(_("Disable"));
			m_enableControl->SetBackgroundColour(wxColor(wxT("#FF0000")));
			m_enabled = true;
		}
		m_enableControl->Refresh();
		break;		
	case MSG_GCODE_LOADED:
		{
			char fn[MAX_PATH];
			mcCntlGetGcodeFileName(0, fn, MAX_PATH);
			m_currentFile->SetLabel(wxString::FromUTF8(fn));
			mcCntlGetGcodeLineCount(0, &count);
			m_PrListBox->SetItemCount((size_t)count + 1);
			m_PrListBox->Refresh();
			m_TpListBox->SetItemCount((size_t)count + 1);
			m_TpListBox->Refresh();
			m_PrListBox->SetSelection(0);
			m_TpListBox->SetSelection(0);
			mcCntlSetGcodeLineNbr(0, 0);
			DoToolPath();
		}
		break;
	case MSG_GCODE_FILE_CHANGED:
		{
			char fn[MAX_PATH];
			mcCntlGetGcodeFileName(0, fn, MAX_PATH);
			m_currentFile->SetLabel(wxString::FromUTF8(fn));
			mcCntlGetGcodeLineCount(0, &count);
			m_PrListBox->SetItemCount((size_t)count + 1);
			m_PrListBox->Refresh();
			m_TpListBox->SetItemCount((size_t)count + 1);
			m_TpListBox->Refresh();
			long line;
			mcCntlGetGcodeLineNbr(0, &line);
			if (line > 0) {
				m_PrListBox->SetSelection((int)line - 1);
				m_TpListBox->SetSelection((int)line - 1);
			}
		}
		break;
	case MSG_CHANGE_TOOL:
		m_ledToolChange->Enable(true);
		break;
	case MSG_CHANGE_TOOL_DONE:
		{
			m_ledToolChange->Enable(false);
			m_tool_num->SetValue(wxString::Format(wxT("%d"), param1));
			double toolRadius = 0;
			double toolHeight = 0;
			// Radius or Diameter?  We need to figure this out.
			mcToolGetData(0, MTOOL_MILL_RAD, (int)param1, &toolRadius);
			m_toolDiameter->SetValue(wxString::Format(wxT("%0.4f"), toolRadius * 2));
			mcToolGetData(0, MTOOL_MILL_HEIGHT, (int)param1, &toolHeight);
			m_toolHeight->SetValue(wxString::Format(wxT("%0.4f"), toolHeight));
		}
		break;
	case MSG_SIG_CHANGED:
		ProcessSignal(param1, param2);
		break;
	case MSG_DRYRUN_DONE:
		DoRunFromHere();
		break;
	case MSG_HOME_AXIS:
		break;
	case MSG_HOME_AXIS_DONE:
		break;
	}
}

void wxMachS::MoveToRFHStart()
{
	if(0){//RunFromHere) {//Only do this if we are in a run from here state
		double pos[6];
		double machpos[6];
		int r=0;
		int i=0;
		for(i=0; i<6; i++){
			mcAxisGetMachinePos(0, i, &machpos[i]);
			mcCntlGcodeInterpGetPos(0, i, &pos[i]);
		}
		wxString str;
		str.Printf(_("Would you like to move to machine position: \nX = %.4f\nY = %.4f\nZ = %.4f\nA = %.4f\nB = %.4f\nC = %.4f\n"), pos[0], pos[1], pos[2], pos[3], pos[4], pos[5]);
		r = wxMessageBox(str, _("Run From Here Prep Move"), wxYES_NO | wxICON_QUESTION);
		if(r == wxYES) {
			double MoveDist;
			//Get the machine position as soon as we have the machine position we can calc the move to the start point
			for(i=0; i<6; i++){
				if(i == 2) {
					continue;
				}
				MoveDist = pos[i] - machpos[i];//calc the inc move to the start position
				mcJogIncStart(0, i, MoveDist);
			}
			double dist=0;
			do{
				wxMilliSleep(100);
				dist=0;
				for(i=0; i<6; i++){
					mcAxisGetMachinePos(0, i, &machpos[i]);
					dist += (pos[i] - machpos[i]);
				}
			}while(fabs(dist) > .01);

			//Now move the Z axis into position
			mcAxisGetMachinePos(0, 2, &machpos[2]);
			MoveDist = pos[2] - machpos[2];//calc the inc move to the start position
			mcJogIncStart(0, 2, MoveDist);

		}
	}
}

void wxMachS::OnPluginConfigItem(wxCommandEvent& event)
{
	wxUnusedVar(event);
	int devId = event.GetId() - ID_CONFPLUGINS;
	mcPluginConfigure(0, devId);
}

void wxMachS::OnPluginDiagItem(wxCommandEvent& event)
{
	wxUnusedVar(event);
	int devId = event.GetId() - ID_DIAGPLUGINS;
#ifdef WIN32 
		void *hwnd = this->GetHandle();
		mcGuiSetWindowHandle(0, hwnd);
#else
		mcGuiSetWindowHandle(0, this);
#endif
	mcPluginDiagnostic(0, devId);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON27
 */

void wxMachS::OnButtonRunFromHere( wxCommandEvent& event )
{
	wxUnusedVar(event);
	event.Skip();
	long n = 0;
	m_line_number->GetValue().ToLong(&n);  // Base 1!
	mcCntlDryRunToLine(0, n - 1); // Base 0!
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM2
 */

void wxMachS::OnFileOpen( wxCommandEvent& event )
{
	wxUnusedVar(event);
	DoFileOpen();
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUITEM3
 */

void wxMachS::OnFileClose( wxCommandEvent& event )
{
	wxUnusedVar(event);
	DoFileClose();
}


/*
 * wxEVT_UPDATE_UI event handler for ID_MENUITEM3
 */

void wxMachS::OnFileCloseUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_PrListBox->GetItemCount() > 0);
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_SELDEV
 */

void wxMachS::OnConfigureSeldev( wxCommandEvent& event )
{
	char str_odevname[80];
	char str_ndevname[80];
	int rc = 0;
	wxUnusedVar(event);
	wxUnusedVar(rc);
	mcProfileGetString(0, "Preferences", "MotionDevice", str_odevname, 80, "");

	SelDev* window = new SelDev(this);
	int returnValue = window->ShowModal();
	//window->Destroy();
	if (returnValue == wxID_OK) {
		mcProfileGetString(0, "Preferences", "MotionDevice", str_ndevname, 80, "");
		this->m_mdevSelected = strcmp(str_ndevname, "") ? true : false;
		if (strcmp(str_odevname, str_ndevname) && strcmp(str_ndevname, "")) {
			wxMessageBox(_("A new motion device has been selected.  The control must be restarted."), _("New motion device selected!"));
			// Init Motion Dev
		}
	}
}


/*
 * wxEVT_UPDATE_UI event handler for ID_MENUITEM1
 */

void wxMachS::OnConfigureMachUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_mdevSelected && m_state == MC_STATE_IDLE && !m_enabled);
}


/*
 * wxEVT_CREATE event handler for ID_WXMACHS
 */

void wxMachS::OnCreate( wxWindowCreateEvent& event )
{
////@begin wxEVT_CREATE event handler for ID_WXMACHS in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_CREATE event handler for ID_WXMACHS in wxMachS. 
}


/*
 * wxEVT_UPDATE_UI event handler for ID_SELDEV
 */

void wxMachS::OnCofigureSeldevUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_state == MC_STATE_IDLE && !m_enabled);
}

void wxMachS::OnPluginConfigItemUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_state == MC_STATE_IDLE);
}

void wxMachS::OnPluginDiagItemUpdate( wxUpdateUIEvent& event )
{
	event.Enable(true);
}

/*
 * wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_SLIDER2
 */

#ifdef MACHPRO
void wxMachS::OnSpindleOverideSliderUpdated( wxCommandEvent& event )
{
	mcSpindleSetOverride(0, (double)(event.GetInt()/100.0));
	//wxString macro = wxT("C:\\src\\Mach\\Macros\\EagleMill\\spindlespeed.mcs");
	//mcScriptExecute(0, wxToChar(macro),1);
	//event.Skip();
}
#endif
/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON30
 */

void wxMachS::OnRefX( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcAxisHome(0, 0);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON31
 */

void wxMachS::OnRefY( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcAxisHome(0, 1);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON32
 */

void wxMachS::OnRefZ( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcAxisHome(0, 2);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON33
 */
#ifdef MACHPRO
void wxMachS::OnRefA( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcAxisHome(0, 3);
}
#endif

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_ABOUTMACH
 */

void wxMachS::OnAboutmachClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = 0;
	mcCntlGetValue(0, VAL_SCC, 0, &dval);  // Special VAL_ param to see if the security code has been compromised.
	bool compromised = (dval != 0) ? true : false;
	About *dlg = new About(0, this, compromised);
#ifdef OLD_ABOUT
	wxString SoftwareName;
	wxString Version = MC_VERSION;
	unsigned long long i = 0;
	mcCntlGetLicenseModules(0, &i);

	if (i & MC_LIC_M4HOBBY) {
		SoftwareName = _("Mach Hobby");
	} else if (i & MC_LIC_M4LITE) {
		SoftwareName = _("Mach Lite");
	} else if (i & MC_LIC_M4EXPERT) {
		SoftwareName = _("Mach Expert");
	} else if (i & MC_LIC_M4INDUSTRIAL) {
		SoftwareName = _("Mach Industrial");
	} else {
		SoftwareName = _("Mach Demo");
	}

	bool Licensed = (i != 0);
	char buff[4096];
	memset(buff, 0, 4096);
	mcCntlGetComputerID(0, buff, 4096);
	wxString PcId = wxString::FromUTF8(buff);
	wxBitmap *Logo = NULL;
#ifdef MACH_MOTION
	wxBitmap bit(Machmotion_xpm);
	Logo = &bit;
#endif

	dlg->SetLicenseData(SoftwareName, Version, Licensed, PcId, Logo);
#endif
	if ( dlg->ShowModal() == wxID_OK ){
	}
    dlg->Destroy();

#if 0
	wxUnusedVar(event);
	char buff[64];
	mcCntlGetComputerID(0,&buff[0],64);

	About *abt = new About(this);
	abt->m_id = wxString::FromUTF8(buff);
	abt->m_comp_id->SetLabel(abt->m_id);
	abt->ShowModal();
	abt->Destroy();
	//event.Skip();
#endif
}




/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON14
 */

void wxMachS::OnReset( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcCntlReset(0);
#if 0
	mcState state;

	mcCntlGetState(0, &state);
	if (state != MC_STATE_IDLE) {
		mcCntlCycleStop(0);
	}
	wxString code = wxEmptyString;
	for (size_t idx = 0; idx <	m_initStrings.GetCount(); idx++) {
		code.Append(m_initStrings[idx] + wxT("\n"));
	}
	mcCntlGcodeExecute(0, wxToChar(code));
	m_PrListBox->SetSelection(0);
	m_TpListBox->SetSelection(0);
	do {
		wxMilliSleep(100);
		mcCntlGetState(0, &state);
	} while (state != MC_STATE_IDLE);
	mcCntlRewindFile(0); 
#endif
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON35
 */

void wxMachS::OnDerefAll( wxCommandEvent& event )
{
	wxUnusedVar(event);
	mcAxisDerefAll(0);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON49
 */

void wxMachS::OnNFSWizardsClick( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON49 in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON49 in wxMachS. 
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON26
 */

void wxMachS::OnAutoToolZeroClick( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON26 in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON26 in wxMachS. 
}

#if defined(MACHPRO)

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON28
 */

void wxMachS::OnToolRememberClick( wxCommandEvent& event )
{
	int i=0;
	for(i=0; i<2; i++){
		mcAxisGetMachinePos(0, i, &m_remberpos[i]);
	}
	wxString msg;
	msg.Printf(_("Remember Position Set to: X%.4f Y%.4f"), m_remberpos[0], m_remberpos[1]);
	wxMessageBox(msg, _("Remember Position..."));
	event.Skip();
 
}
#endif

#if defined(MACHPRO)

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON29
 */

void wxMachS::OnToolReturnClick( wxCommandEvent& event )
{
	wxString msg;
	if(m_state != MC_STATE_IDLE){
		msg = _("Must be in idle state for this function");
		mcCntlSetLastError(0, wxToChar(msg));
		return;
	}
	msg.Printf(_("Would you like to move to remembered position : X%.4f Y%.4f"),m_remberpos[0],m_remberpos[1]);
	if(wxMessageBox(msg, _("Remember Position..."), wxYES_NO) == wxYES){
		int i;
		double m_machpos[2];
		for(i=0; i<2; i++){
			mcAxisGetMachinePos(0, i, &m_machpos[i]);
			mcJogIncStart(0, i, m_remberpos[i] - m_machpos[i]);	
		}
	
	}
	event.Skip();
}
#endif


/*
 * wxEVT_COMMAND_LISTBOX_SELECTED event handler for ID_GCODELIST11
 */

void wxMachS::OnGcodelistSelected( wxCommandEvent& event )
{
	wxUnusedVar(event);
	BOOL inCycle = 0;
	mcCntlIsInCycle(0, &inCycle);
	wxGcodeList *list = NULL;
	switch (event.GetId()) {
		case ID_PR_GCODELIST:
			list = m_PrListBox;
			break;
		case ID_TP_GCODELIST:
			list = m_TpListBox;
			break;
	}
	if (list) {
		if (inCycle == 0) {
			int Selection = list->GetSelection(); // Base 0!
			if (Selection < 0) {
				// Sanity check.
				Selection = 0;
			}
			mcCntlSetGcodeLineNbr(0, (double)Selection); // Base 0!
		}	
	}
}

void wxMachS::DisplayJogInc(void)
{
	wxString str;
	str.Printf(wxT("%f"), m_JogIncArray[m_JogIndex]);
	while (str.Right(1) == "0") {
		str.RemoveLast();
	}
	int places = str.After('.').Len();
	if (places <= 4) {
		str.Printf(wxT("%.4f"), m_JogIncArray[m_JogIndex]);
	} else if (places == 5) {
		str.Printf(wxT("%.5f"), m_JogIncArray[m_JogIndex]);
	} else if (places == 6) {
		str.Printf(wxT("%.6f"), m_JogIncArray[m_JogIndex]);
	}
	m_JogInc->SetLabel(str);
}

void wxMachS::GetJogIncs()
{
	char zstr[80];
	double incr;
	double currentIncr;
	// Saved current increment
	mcProfileGetString(0, "Preferences", "JogInc", zstr, sizeof(zstr), "");
	wxString::FromUTF8(zstr).ToDouble(&currentIncr);
	DoSetJogInc(0, currentIncr);
	// The increments.
	mcProfileGetString(0, "Preferences", "JogInc1", zstr, sizeof(zstr), "1");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc2", zstr, sizeof(zstr), "0.1");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc3", zstr, sizeof(zstr), "0.01");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc4", zstr, sizeof(zstr), "0.001");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc5", zstr, sizeof(zstr), "0.0001");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc6", zstr, sizeof(zstr), "1");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc7", zstr, sizeof(zstr), "0.1");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc8", zstr, sizeof(zstr), "0.01");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc9", zstr, sizeof(zstr), "0.001");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	mcProfileGetString(0, "Preferences", "JogInc10", zstr, sizeof(zstr), "0.0001");
	wxString::FromUTF8(zstr).ToDouble(&incr); if (incr > 0) m_JogIncArray.Add(incr);
	for (size_t idx = 0; idx < m_JogIncArray.GetCount(); idx++) {
		if (m_JogIncArray[idx] == currentIncr) {
			m_JogIndex = idx;
			break;
		}
	}

	if (m_JogIndex >= (int)m_JogIncArray.GetCount()) {
		m_JogIndex = 0;
	}
	
	DisplayJogInc();

	long rate = 0;
	mcProfileGetString(0, "Preferences", "JogRate", zstr, sizeof(zstr), "50.0");
	wxString tmp = wxString::FromUTF8(zstr);
	m_jogRateText->SetValue(tmp);
	double val;
	tmp.ToDouble(&val);
	rate = (int)val * 10;
	m_jogRate->SetValue(rate);
	DoJogRate(val);
}

void wxMachS::SetJogIncs()
{
	// Saved current increment
	mcProfileWriteString(0, "Preferences", "JogInc", wxToChar(m_JogInc->GetLabel()));
	mcProfileWriteString(0, "Preferences", "JogRate", wxToChar(wxString::Format(wxT("%0.1f"), (double)m_jogRate->GetValue()/10)));
}

void wxMachS::GetDefaultModes()
{
	char zstr[80];
	m_initStrings.Clear();
	m_initStrings.Add(wxT("G40")); // Always add G40 before G20 or G21!
	m_initStrings.Add(wxT("G80")); // Always add G80!
	mcProfileGetString(0, "DefaultMode", "UnitsMode", zstr, sizeof(zstr), "G20");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "TraverseMode", zstr, sizeof(zstr), "G0");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "MotionMode", zstr, sizeof(zstr), "G64");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "DistanceMode", zstr, sizeof(zstr), "G90");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "CenterMode", zstr, sizeof(zstr), "G91.1");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "FeedMode", zstr, sizeof(zstr), "G95");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "Plane", zstr, sizeof(zstr), "G17");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "CanedCycleRetract", zstr, sizeof(zstr), "G98");
	m_initStrings.Add(wxString::FromUTF8(zstr));
#ifdef MACHPRO	
	mcProfileGetString(0, "DefaultMode", "SpindleMode", zstr, sizeof(zstr), "G97");
	m_initStrings.Add(wxString::FromUTF8(zstr));
#endif
	mcProfileGetString(0, "DefaultMode", "UserDefaults1", zstr, sizeof(zstr), "");
	m_initStrings.Add(wxString::FromUTF8(zstr));
	mcProfileGetString(0, "DefaultMode", "UserDefaults2", zstr, sizeof(zstr), "");
	m_initStrings.Add(wxString::FromUTF8(zstr));

	// shoe horned in here for lack of a better place at the moment.
	char fileExtensions[1024];
	memset(fileExtensions, 0, 1024);
	mcProfileGetString(0, "Preferences", "FileExtensions", fileExtensions, 1023, "*.tap; *.nc");
	m_fileExtensions = wxString::FromUTF8(fileExtensions);
#ifdef MACHPRO
	mcProfileGetInt(0, "Preferences", "PlcInterval", &m_plcInterval, 100);
#endif

}

void wxMachS::GetSpindleDelays()
{
	char zstr[80];
	// Delays
#ifndef MACHPRO	
	mcProfileGetString(0, "Preferences", "SpindleDelay", zstr, sizeof(zstr), "1");
	wxString::FromUTF8(zstr).ToDouble(&m_spindleDelay);
	mcSpindleSetAccelTime(0, 0, m_spindleDelay);
	mcSpindleSetDecelTime(0, 0, m_spindleDelay);
#endif
	mcProfileGetString(0, "Preferences", "CoolantDelay", zstr, sizeof(zstr), "1");
	wxString::FromUTF8(zstr).ToDouble(&m_coolantDelay);
#ifdef MACHPRO	
	mcProfileGetString(0, "Preferences", "MistDelay", zstr, sizeof(zstr), "1");
	wxString::FromUTF8(zstr).ToDouble(&m_mistDelay);
#endif
	mcCntlSetCoolantDelay(0, m_coolantDelay);
#ifdef MACHPRO	
	mcCntlSetMistDelay(0, m_mistDelay);
#endif

	wxString code = wxEmptyString;
	for (size_t idx = 0; idx <	m_initStrings.GetCount(); idx++) {
		if (m_initStrings[idx] != wxEmptyString) {
			code.Append(m_initStrings[idx] + wxT("\n"));
		}
	}
	mcCntlSetResetCodes(0, wxToChar(code));

}

void wxMachS::GetMRU()
{
	char zstr[MAX_PATH];
	char key[80];
	wxString val;
	for (size_t idx = 0; idx < 10; idx++) {
		sprintf(key, "MRU%zu", idx + 1);
		mcProfileGetString(0, "Preferences", key, zstr, sizeof(zstr), "");
		val = wxString::FromUTF8(zstr);
		if (val != wxEmptyString) {
			m_recentFiles.Add(val);
		}
	}
}

void wxMachS::SetMRU()
{
	char key[80];
	wxString val;
	int tcount = (int)m_recentFiles.GetCount();
	for (int idx = 0; idx < 10; idx++) {
		sprintf(key, "MRU%d", idx + 1);
		if (idx < tcount) {
			mcProfileWriteString(0, "Preferences", key, wxToChar(m_recentFiles[idx]));
		} else {
			mcProfileWriteString(0, "Preferences", key, "");
		}
	}
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_ENABLE
 */

void wxMachS::OnEnable( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_enabling = true;
	mcCntlEnable(0, !m_enabled);
#if 0
	if (m_estop && state) {
		mcCntlSetLastError(0, "E-Stop is in effect.  Clear the E-Stop condition.");
		m_enableControl->Enable(true);
	} else {
		mcCntlEnable(0, !m_enabled);
	}
#endif
}


/*
 * wxEVT_KEY_DOWN event handler for ID_WXMACHS
 */

void wxMachS::OnKeyDown( wxKeyEvent& event )
{
	//event.Skip();
	if(!m_KB_joggingEnabled){
		return;
	}

	double rate=0;
	if(event.ShiftDown()){
		rate = 1;
	} else {
		rate = m_RRO_Slider->GetValue()/100.0;
	}
	wxChar r = event.GetKeyCode();

	bool Incj = false;
	if (event.ControlDown() || !m_ledJogCont->IsEnabled()) {
		Incj = true;
	}
	switch (r){
		case WXK_LEFT:
			if (!m_KBJog[0].jogging) {
				m_KBJog[0].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 0, -rate);
					m_KBJog[0].inc_move = false;
			} else {
				mcJogIncStart(0, 0, -m_JogIncArray[m_JogIndex]);
					m_KBJog[0].inc_move = true;
			}
			}
			break;
		case WXK_RIGHT:
			if (!m_KBJog[0].jogging) {
				m_KBJog[0].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 0, rate);
						m_KBJog[0].inc_move = false;
			} else {
				mcJogIncStart(0, 0, m_JogIncArray[m_JogIndex]);
					m_KBJog[0].inc_move = true;
			}
			}
			break;
		case WXK_UP:
			if (!m_KBJog[1].jogging) {
				m_KBJog[1].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 1, rate);
					m_KBJog[1].inc_move = false;
			} else {
				mcJogIncStart(0, 1, m_JogIncArray[m_JogIndex]);
					m_KBJog[1].inc_move = true;
			}
			}
			break;
		case WXK_DOWN:
			if (!m_KBJog[1].jogging) {
				m_KBJog[1].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 1, -rate);
					m_KBJog[1].inc_move = false;
			} else {
				mcJogIncStart(0, 1, -m_JogIncArray[m_JogIndex]);
					m_KBJog[1].inc_move = true;
			}
			}
			break;
		case WXK_PAGEUP:
			if (!m_KBJog[2].jogging) {
				m_KBJog[2].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 2, rate);
					m_KBJog[2].inc_move = false;
			} else {
				mcJogIncStart(0, 2, m_JogIncArray[m_JogIndex]);
					m_KBJog[2].inc_move = true;
			}
			}
			break;
		case WXK_PAGEDOWN:
			if (!m_KBJog[2].jogging) {
				m_KBJog[2].jogging = true;
				if (!Incj) {
					mcJogVelocityStart(0, 2, -rate);
					m_KBJog[2].inc_move = false;
			} else {
				mcJogIncStart(0, 2, -m_JogIncArray[m_JogIndex]);
					m_KBJog[2].inc_move = true;
			}
			}
			break;
		case WXK_SPACE:
			mcCntlFeedHold(0);
			break;
		case WXK_ESCAPE:
			break;
	}

}

/*
 * wxEVT_KEY_UP event handler for ID_WXMACHS
 */

void wxMachS::OnKeyUp( wxKeyEvent& event )
{
	//event.Skip();
	wxChar r = event.GetUnicodeKey();
	//if(r == NULL){
		r = event.GetKeyCode();
	//}
	switch (r){
		case WXK_LEFT:
		case WXK_RIGHT:
			if (m_KBJog[0].jogging && !m_KBJog[0].inc_move) {
				mcJogVelocityStop(0, 0);
			}
			m_KBJog[0].jogging=false;
			break;
		case WXK_UP:
		case WXK_DOWN:
			if (m_KBJog[1].jogging && !m_KBJog[1].inc_move) {
				mcJogVelocityStop(0, 1);
			}
			m_KBJog[1].jogging=false;
			break;
		case WXK_PAGEUP:
		case WXK_PAGEDOWN:
			if (m_KBJog[2].jogging && !m_KBJog[2].inc_move) {
				mcJogVelocityStop(0, 2);
			}
			m_KBJog[2].jogging=false;
			break;
	}

}


/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON12
 */

void wxMachS::OnButtonUpdate( wxUpdateUIEvent& event )
{
	int id = event.GetId();
	mcState state = m_state;
	bool enable = false;
	bool ena = false;
	switch(id) {
	case ID_CYCLESTART:
		ena = (state == MC_STATE_IDLE || state == MC_STATE_HOLD || state == MC_STATE_FRUN_SINGLE_BLOCK
			|| state == MC_STATE_FRUN_PROBE_FH || state == MC_STATE_FRUN_THREAD_FH
			|| state == MC_STATE_FRUN_MACROH || state == MC_STATE_MRUN_FH || state == MC_STATE_FRUN_FH 
			|| state == MC_STATE_MRUN_PROBE_FH || state == MC_STATE_MRUN_THREAD_FH || state == MC_STATE_MRUN_MACROH);
		enable = ena && m_enabled;
		event.Enable(enable);
		break;
	case ID_STOP:
		event.Enable((state != MC_STATE_IDLE) && m_enabled && state != MC_STATE_JOG);
		break;
	case ID_RESET:
		event.Enable(m_enabled);
		break;
	case ID_FEEDHOLD:
		event.Enable((state != MC_STATE_IDLE) && m_enabled && state != MC_STATE_JOG);
		break;
	default:
		event.Skip();
	}
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_JOGFOCUSBUTTON
 */

void wxMachS::OnJogfocusbuttonClick( wxCommandEvent& event )
{
	m_KB_joggingEnabled = !m_KB_joggingEnabled;
	if ( m_KB_joggingEnabled ){
		m_jogfocusbutton->SetLabel(_("Keyboard Jog On"));
		m_jogfocusbutton->SetBackgroundColour(wxColor(wxT("#00FF00")));
	} else {
		m_jogfocusbutton->SetLabel(_("Keyboard Jog Off"));
		m_jogfocusbutton->SetBackgroundColour(wxNullColour);
	}

	event.Skip();
}


/*
 * wxEVT_SET_FOCUS event handler for ID_JOGFOCUSBUTTON
 */

void wxMachS::OnSetFocus( wxFocusEvent& event )
{
	
	event.Skip();
}


/*
 * wxEVT_KILL_FOCUS event handler for ID_JOGFOCUSBUTTON
 */

void wxMachS::OnKillFocus( wxFocusEvent& event )
{
	m_jogfocusbutton->SetLabel(_("Keyboard Jog Off"));
	m_jogfocusbutton->SetBackgroundColour(wxNullColour);
	m_KB_joggingEnabled = false;
	event.Skip();
}

#if defined(MACHPRO)

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUEFIXTUREOFFSET
 */

void wxMachS::OnMenuefixtureoffsetClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_fixtureOffsets == NULL) {
		m_fixtureOffsets = new FixtureOffsets(this);
	}
	m_fixtureOffsets->SetInstance(0);
	m_fixtureOffsets->Show();
	m_fixtureOffsets->Raise();
}
#endif

#if defined(MACHPRO)

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_MENUTOOLOFFSETS
 */

void wxMachS::OnMenutooloffsetsClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_toolOffsets == NULL) {
		m_toolOffsets = new ToolOffsets(this);
	}
	m_toolOffsets->SetInstance(0);
	m_toolOffsets->Show();
	m_toolOffsets->Raise();
}
#endif


/*
 * wxEVT_COMMAND_SPINCTRL_UPDATED event handler for ID_SPINCTRL
 */

void wxMachS::OnSpinctrlUpdated( wxSpinEvent& event )
{
	int newrange = event.GetPosition();
	mcSpindleSetRange(0, newrange);
}


/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON46
 */

void wxMachS::OnBtnRefAllUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_enabled);
}

#if defined(MACHPRO)

/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON30
 */

void wxMachS::OnRefAUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_enabled);
}
#endif

/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON55
 */

void wxMachS::OnJogUpdateUI( wxUpdateUIEvent& event )
{
	int axis = -1;
	switch (event.GetId()) {
		case ID_JOG_XPOS:
		case ID_JOG_XNEG:
			axis = 0;
			break;
		case ID_JOG_YPOS:
		case ID_JOG_YNEG:
			axis = 1;
			break;
		case ID_JOG_ZPOS:
		case ID_JOG_ZNEG:
			axis = 2;
			break;
	}
	axisinfo_t ainf;
	mcAxisGetInfoStruct(0, axis, &ainf);
	event.Enable(m_enabled && ainf.Enabled);
}

#if defined(MACHPRO)

/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON58
 */

void wxMachS::OnJogUpdateUIPro( wxUpdateUIEvent& event )
{
	int axis = -1;
	switch (event.GetId()) {
		case ID_JOG_APOS:
		case ID_JOG_ANEG:
			axis = 3;
			break;
		default:
			axis = 0;
			break;
	}
	axisinfo_t ainf;
	mcAxisGetInfoStruct(0, axis, &ainf);
	event.Enable(m_enabled && ainf.Enabled);
}
#endif


/*
 * wxEVT_UPDATE_UI event handler for ID_BUTTON30
 */

void wxMachS::OnRefUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_enabled);
}


/*
 * wxEVT_UPDATE_UI event handler for ID_SPINDLE_CW
 */

void wxMachS::OnSpindleCwUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_enabled);
}

void wxMachS::OnLua( wxLuaEvent &event )
{
	wxUnusedVar(event);
	m_lastLuaError = event.GetString();
	m_lastLuaErrorCode = event.GetInt();
	if (event.GetEventType() == wxEVT_LUA_ERROR) {
		wxMessageBox(_("LUA Error code ") + wxString::Format(wxT("%d"), m_lastLuaErrorCode) + wxT("\n") + m_lastLuaError, _("LUA Error!"));
	}
//	DisplayMessage(event.GetString(), event.GetEventType() == wxEVT_LUA_ERROR, event.GetwxLuaState());
}


/*
 * wxEVT_COMMAND_TEXT_UPDATED event handler for ID_TOOL_NUM
 */

void wxMachS::OnToolNumTextUpdated( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_TEXT_UPDATED event handler for ID_TOOL_NUM in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_COMMAND_TEXT_UPDATED event handler for ID_TOOL_NUM in wxMachS. 
}


/*
 * wxEVT_COMMAND_TEXT_ENTER event handler for ID_TOOL_NUM
 */

void wxMachS::OnToolNumEnter( wxCommandEvent& event )
{
	wxUnusedVar(event);
	long toolNum = 0;
	m_tool_num->GetValue().ToLong(&toolNum);
	mcToolSetCurrent(0, (int)toolNum);
}


/*
 * wxEVT_COMMAND_LISTBOX_DOUBLECLICKED event handler for ID_PR_GCODELIST
 */

void wxMachS::OnGcodelistDoubleClicked( wxCommandEvent& event )
{
	wxGcodeList *list = NULL;
	switch (event.GetId()) {
		case ID_PR_GCODELIST:
			list = m_PrListBox;
			break;
		case ID_TP_GCODELIST:
			list = m_TpListBox;
			break;
	}
	if (list) {
		list->ShowLineNumbers(!list->IsShowingLineNumbers());
		list->RefreshAll();
	}
}


/*
 * wxEVT_COMMAND_SLIDER_UPDATED event handler for ID_JOG_RATE
 */

void wxMachS::OnJogRateUpdated( wxCommandEvent& event )
{
	DoJogRate((double)m_jogRate->GetValue()/10);
	m_jogRateText->SetValue(wxString::Format(wxT("%0.1f"), (double)m_jogRate->GetValue()/10));
	event.Skip();
}

void wxMachS::DoJogRate(double rate)
{
	for (int axis = 0; axis < MC_MAX_COORD_AXES; axis++) {
		mcJogSetRate(0, axis, rate);
	}
}

void wxMachS::DoJogRate(int rate)
{
	DoJogRate((double)rate);
}

/*
 * wxEVT_UPDATE_UI event handler for ID_JOG_RATE
 */

void wxMachS::OnJogRateUpdate( wxUpdateUIEvent& event )
{
////@begin wxEVT_UPDATE_UI event handler for ID_JOG_RATE in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_UPDATE_UI event handler for ID_JOG_RATE in wxMachS. 
}


/*
 * wxEVT_COMMAND_TEXT_UPDATED event handler for ID_JOG_RATE_TEXT
 */

void wxMachS::OnJogRateTextTextUpdated( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_TEXT_UPDATED event handler for ID_JOG_RATE_TEXT in wxMachS.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_COMMAND_TEXT_UPDATED event handler for ID_JOG_RATE_TEXT in wxMachS. 
}


/*
 * wxEVT_COMMAND_TEXT_ENTER event handler for ID_JOG_RATE_TEXT
 */

void wxMachS::OnJogRateTextEnter( wxCommandEvent& event )
{
	double val;
	m_jogRateText->GetValue().ToDouble(&val);
	m_jogRateText->SetValue(wxString::Format(wxT("%0.1f"), val));
	m_jogRateText->GetValue().ToDouble(&val);
	DoJogRate(val);
	m_jogRate->SetValue((int)(val * 10));
	event.Skip();
}


/*
 * wxEVT_KILL_FOCUS event handler for ID_JOGFOCUSBUTTON
 */

void wxMachS::OnJogRateTextKillFocus( wxFocusEvent& event )
{
	double val;
	m_jogRateText->GetValue().ToDouble(&val);
	m_jogRateText->SetValue(wxString::Format(wxT("%0.1f"), val));
	m_jogRateText->GetValue().ToDouble(&val);
	DoJogRate(val);
	m_jogRate->SetValue((int)(val * 10));
	event.Skip();
}

void wxMachS::OnDroEvent( mcDroEvent& event )
{
	int id = event.GetId();
	double val = 0;
	int axis = 0;
	MINSTANCE inst = event.GetInst();

	if (event.GetEventType() == wxEVT_MCDRO_ENTER) {
		val = event.GetDouble();
		switch(id) {
		case ID_RUN_DRO0:
		case ID_MDI_DRO0:
		case ID_TP_DRO0:
			axis = 0;
			break;
		case ID_RUN_DRO1:
		case ID_MDI_DRO1:
		case ID_TP_DRO1:
			axis = 1;
			break;
		case ID_RUN_DRO2:
		case ID_MDI_DRO2:
		case ID_TP_DRO2:
			axis = 2;
			break;
		}
		if (m_ledMachCoords->IsEnabled()) {
			mcAxisSetMachinePos(inst, axis, val);
		} else {
			mcAxisSetPos(inst, axis, val);
		}
		event.Skip();
		return;
	}
}

#ifdef MACHPRO
void wxMachS::OnDroEventA( mcDroEvent& event )
{
	int id = event.GetId();
	double val = 0;
	int axis = 0;
	MINSTANCE inst = event.GetInst();

	if (event.GetEventType() == wxEVT_MCDRO_ENTER) {
		val = event.GetDouble();
		switch(id) {
		case ID_RUN_DRO3:
		case ID_MDI_DRO3:
		case ID_TP_DRO3:
			axis = 3;
			break;
		}
		if (m_ledMachCoords->IsEnabled()) {
			mcAxisSetMachinePos(inst, axis, val);
		} else {
			mcAxisSetPos(inst, axis, val);
		}
		event.Skip();
		return;
	}
}
#endif


/*
 * wxEVT_COMMAND_TEXT_ENTER event handler for ID_LINENUM_TEXT
 */

void wxMachS::OnLinenumTextEnter( wxCommandEvent& event )
{
	if (m_state == MC_STATE_IDLE) {
		long line = 0;
		m_line_number->GetValue().ToLong(&line); // Base 1!
		if (line > 0) {
			mcCntlSetGcodeLineNbr(0, line - 1); // Base 0!
		}
	}
	event.Skip();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON
 */

void wxMachS::OnDisplayModeClick( wxCommandEvent& event )
{
	BOOL drawlimits = FALSE;
	mcToolPathGetDrawLimits(0, &drawlimits);
	mcToolPathSetDrawLimits(0, drawlimits != 0 ? 0 : 1);
	event.Skip();
}

/*
 * wxEVT_UPDATE_UI event handler for ID_REGEN_TP
 */

void wxMachS::OnRegenTpUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_currentFile->GetLabel() != wxEmptyString);
}

#if defined(MACHPRO)

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_LOG
 */

void wxMachS::OnOpLogClick( wxCommandEvent& event )
{
	m_log->Show();
	event.Skip();
}
#endif


/*
 * wxEVT_UPDATE_UI event handler for ID_ENABLE
 */

void wxMachS::OnEnableUpdate( wxUpdateUIEvent& event )
{
	wxString eText = m_enableControl->GetLabel();
	if (!m_enabled && eText == _("Enable") && !m_enabling) {
		// The control is in the disabled state.
		event.Enable(!m_estop);
		return;
	} else if (m_enabled && eText == _("Disable")){
		// The control is in the enabled state.
		event.Enable(true);
		return;
	}
	event.Enable(false);
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_CONFIG_EDIT_PLC
 */

#if defined(MACHPRO)
void wxMachS::OnConfigEditPlcClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_killPlcTimer = true;
	wxString plcScript = m_machDir + DIRSEP + wxT("Profiles") + DIRSEP + m_profileName + DIRSEP + wxT("MachPlc.mcs");
	if (!wxFile::Exists(plcScript)) {
		wxFile fp;
		fp.Create(plcScript);
		fp.Close();
	}

	wxString Cmd = m_machDir + DIRSEP + wxT("mcLuaEditor /o \"") + plcScript + wxT("\"");
	wxProcess *p = new wxProcess(this);
	wxExecute(Cmd, wxEXEC_SYNC, p);
	m_killPlcTimer = false;
	if (ReadPlcScript(plcScript)) {
		m_plcTimer->Start(m_plcInterval);
	}
}


/*
 * wxEVT_UPDATE_UI event handler for ID_CONFIG_EDIT_PLC
 */

void wxMachS::OnConfigEditPlcUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_state == MC_STATE_IDLE && !m_enabled);
}

void wxMachS::OnPlcTimer(wxTimerEvent& event)
{
	wxUnusedVar(event);
	m_plcScriptDone = false;
	// Set the instance.
	m_wxlState.lua_PushInteger((int)0);
	m_wxlState.lua_SetGlobal("__MINSTANCE__");

	m_wxlState.lua_GetGlobal("wxMachPlc");
	if (m_wxlState.lua_IsNil(-1)) {
		// No plc function found!
		return;
	}
	m_wxlState.lua_GetGlobal("wxMachPlc");
	int rc = m_wxlState.LuaPCall(0, 0);
	if (rc != 0) {
		m_plcTimer->Stop();
		wxString msg = m_lastLuaError;
		msg += _("\n The PLC is now disabled.  Correct the script error and restart.");
		wxMessageBox(msg, _("Script Error"));
		return;
	}

	if (!m_killPlcTimer) {
		m_plcTimer->Start(m_plcInterval, true);
	}
	m_plcScriptDone = true;
}
#endif // MACHPRO

bool wxMachS::ReadPlcScript(const wxString &filename)
{
	if (!wxFile::Exists(filename)) {
		m_luaPlcScript = wxEmptyString;
		wxFile fp;
		fp.Create(filename);
		fp.Write(wxT("local inst = mc.mcGetInstance()\n"));
		fp.Close();
	}
	wxString plcScript;
	wxFile fp(filename);
	bool ok = fp.ReadAll(&plcScript);
	fp.Close();
#ifdef __WXMSW__
	plcScript.Replace(wxT("\r"), wxEmptyString);
#endif
	if (ok) {
		m_luaPlcScript = wxT("function wxMachPlc()\r\n") + plcScript + wxT("\r\nend\r\n");
		int rc = m_wxlState.RunString(m_luaPlcScript);
		if (rc != 0) {
			return(false);
		}
		return(true);
	}
	return(false);
}


/*
 * wxEVT_CHAR event handler for ID_MDI_TEXT
 */

void wxMachS::OnMdiTextChar( wxKeyEvent& event )
{
	if (event.AltDown()) {
		wxCommandEvent evt;
		switch (event.GetKeyCode()) {
		case WXK_RETURN:
			ExecuteMdi();
			return;
		case WXK_UP:
			evt.SetEventType(wxEVT_COMMAND_BUTTON_CLICKED);
			evt.SetId(ID_MDI_UP);
			OnMdiUpButtonClick(evt);
			return;
		case WXK_DOWN:
			evt.SetEventType(wxEVT_COMMAND_BUTTON_CLICKED);
			evt.SetId(ID_MDI_DOWN);
			OnMdiDownButtonClick(evt);
			return;
		case WXK_DELETE:
			m_MdiCmds->SetValue(wxEmptyString);
			return;
		}
	}
    event.Skip();
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_CONF_PLUGINS
 */

void wxMachS::OnConfPluginsClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
#ifdef WIN32 
		void *hwnd = this->GetHandle();
		mcGuiSetWindowHandle(0, hwnd);
#else
		mcGuiSetWindowHandle(0, this);
#endif

#ifdef MACHPRO
	ConfigurePlugins *cp = new ConfigurePlugins(this);
	cp->SetInstance(0);
	cp->ShowModal();
	cp->Destroy();
#endif
}


/*
 * wxEVT_UPDATE_UI event handler for ID_CONF_PLUGINS
 */

void wxMachS::OnConfPluginsUpdate( wxUpdateUIEvent& event )
{
#ifdef MACHPRO
	event.Enable(m_state == MC_STATE_IDLE && !m_enabled);
#else
	event.Enable(false);
#endif
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_AUTO_CALC
 */

void wxMachS::OnOpAutoCalcClick( wxCommandEvent& event )
{
	m_autoCalcEnable = event.IsChecked();
}


/*
 * wxEVT_UPDATE_UI event handler for ID_OP_AUTO_CALC
 */

void wxMachS::OnOpAutoCalcUpdate( wxUpdateUIEvent& event )
{
	event.Check(this->m_autoCalcEnable);
}

// static function to find the wxMachS class from a child control
wxMachS *wxMachS::FindGui(wxWindow *parent)
{
	wxMachS *m4s = NULL;
	wxWindow *win = parent;
	do {
		m4s = dynamic_cast<wxMachS *>(win);
		if (m4s) break;
		win = win->GetParent();
		if (win == NULL) break;
	} while (m4s == NULL);
	return(m4s);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_SPINDLE_CW
 */

void wxMachS::OnSpindleToggle( wxCommandEvent& event )
{
	wxUnusedVar(event);
	static bool state = m_ledSpindleOn2->IsEnabled();
	state = !state;
	mcSpindleSetDirection(0, state ? 1 : 0);
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_INFO
 */

void wxMachS::OnInfoClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_infoWindow == NULL) {
		m_infoWindow = new mcInformation(this, ID_MCINFORMATION, "wxMach Information");
	}
	if (m_infoWindow) {
		m_infoWindow->Show();
	}
}

void wxMachS::ConfigRestoreWindowSize(wxWindow *window, const wxString &windowName)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/") + windowName);

	int w = m_config->Read(wxT("Width"), -1);
	int h = m_config->Read(wxT("Height"), -1);

	window->SetSize(-1, -1, w, h);
	m_config->SetPath(path);
}

void wxMachS::ConfigSaveWindowSize(wxWindow *window, const wxString &windowName)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/") + windowName);

	int w, h;
	window->GetSize(&w, &h);
	m_config->Write(wxT("Width"), w);
	m_config->Write(wxT("Height"), h);

	m_config->SetPath(path);
}

bool wxMachS::ConfigOpen(bool setRecordDefaults)
{
#if defined(_WIN32) || defined(_WIN64)
	m_config = new wxFileConfig(wxT("wxMach"), wxT("ArtSoft"));
#else
	m_config = new wxFileConfig(wxT("wxMach"), wxT("ArtSoft"), 
								wxEmptyString, wxEmptyString, 
								wxCONFIG_USE_LOCAL_FILE);
#endif
	if (m_config && setRecordDefaults) {
		m_config->SetRecordDefaults();
	}
	return(m_config != NULL ? true : false);
}

bool wxMachS::ConfigClose(void)
{
	if (m_config) {
		m_config->Flush();
		delete m_config;
		m_config = NULL;
		return(true);
	}
	return(false);
}

void wxMachS::ConfigRestoreFramePosition(wxFrame *window, const wxString &windowName)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/") + windowName);

	int s = m_config->Read(wxT("State"), 0L);
	wxUnusedVar(s);
	int x = m_config->Read(wxT("Left"), -1L);
	int y = m_config->Read(wxT("Top"), -1L);
	int w = m_config->Read(wxT("Width"), window->GetSize().GetWidth());
	int h = m_config->Read(wxT("Height"), window->GetSize().GetHeight());

	window->SetSize(x, y, w, h);

	m_config->SetPath(path);
}

void wxMachS::ConfigSaveFramePosition(wxFrame *window, const wxString &windowName)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/") + windowName);

	int s = 0;
	int w, h, x, y;
	window->GetSize(&w, &h);
	window->GetPosition(&x, &y);
	
	if (window->IsFullScreen()) {
		s = 3;
	} else if (window->IsIconized()) {
		s = 2;
	} else if (window->IsMaximized()) {
		s = 1;
	}

	m_config->Write(wxT("State"), s);

	if (s == 0) {
		m_config->Write(wxT("Left"), x);
		m_config->Write(wxT("Top"), y);
		m_config->Write(wxT("Width"), w);
		m_config->Write(wxT("Height"), h);
	}

	m_config->SetPath(path);
}

void wxMachS::ConfigGetExitDontAsk(void)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/Preferences"));

	m_exitDontAsk = m_config->Read(wxT("DontConfirmExit"), 0L) != 0 ? true : false;
	m_config->SetPath(path);
}

void wxMachS::ConfigSetExitDontAsk(void)
{
	if (!m_config) {
		return;
	}
	wxString path = m_config->GetPath();
	m_config->SetPath(wxT("/Preferences"));

	m_config->Write(wxT("DontConfirmExit"), m_exitDontAsk ? 1 : 0);
	m_config->SetPath(path);
}


/*
 * wxEVT_COMMAND_CHECKBOX_CLICKED event handler for ID_BSKIP0
 */

void wxMachS::OnBskipClick( wxCommandEvent& event )
{
	int id = event.GetId();
	wxToggleButton *bt = dynamic_cast<wxToggleButton *>(event.GetEventObject());
	if (!bt) {
		return;
	}
	int level = 0;
	switch(id) {
		case ID_BSKIP0: level = 0; break;
		case ID_BSKIP1: level = 1; break;
		case ID_BSKIP2: level = 2; break;
		case ID_BSKIP3: level = 3; break;
	}
	mcCntlSetBlockDelete(0, level, event.IsChecked() ? 1 : 0);
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_OP_SELECT_LANGUAGE
 */

void wxMachS::OnOpSelectLanguageClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
    if (wxGetApp().SelectLanguage()) {
		wxMessageBox(_("Please restart for the changes to take effect."), _("Information"));
		//wxGetApp().RestartGUI();
    }
}


/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_PACKAGE_PROFILE
 */

void wxMachS::OnPackageProfileClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	wxString profileName = m_profileName;
	ProfileTool pt(m_machDir, profileName);
	wxString msg = wxString::Format(_("Save profile package \"%s.m4prof\"."), profileName);
	wxFileDialog *fd = new wxFileDialog(this, msg, wxGetCwd(), profileName + ".m4prof", "Profile Packages (*.m4prof)|*.m4prof", wxFD_SAVE);
	if (fd->ShowModal() == wxID_CANCEL) {
		fd->Destroy();
		return;
	}
	wxString outPath = fd->GetPath();
	fd->Destroy();
	wxFileName fn(outPath);
	pt.SetDestinationDirectory(fn.GetPath());
	pt.SetZipFileName(fn.GetFullName());
	pt.Package(true);
}

#if defined(__WXMSW__)

/*
 * wxEVT_COMMAND_MENU_SELECTED event handler for ID_EMAIL_PROFILE
 */

void wxMachS::OnEmailProfileClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	wxString profileName = m_profileName;
	ProfileTool pt(m_machDir, profileName);
	pt.PackageAndEmail(m_supportEmail, true);
}
#endif

#if defined(__WXMSW__)

/*
 * wxEVT_UPDATE_UI event handler for ID_EMAIL_PROFILE
 */

void wxMachS::OnEmailProfileUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_supportEmail != wxEmptyString);
}
#endif

void wxMachS::doGetLicenseData(void)
{
	MINSTANCE m_inst = 0;
	int index = 0;
	long dataLen = 0;
	wxString support;
	while (mcCntlGetLicenseDataLen(m_inst, index, &dataLen) == MERROR_NOERROR) {
		char *dataBuf = (char *)malloc(dataLen + 1);
		mcCntlGetLicenseData(m_inst, index, dataBuf, dataLen + 1);
		wxString dataItem = wxString::FromUTF8(dataBuf);
		if (dataItem.Left(8) == "support=") {
			dataItem.Replace("support=", wxEmptyString, false);
			m_supportEmail = dataItem;
		} else if (dataItem.Left(4) == "url=") {
			dataItem.Replace("url=", wxEmptyString, false);
			m_supportHttp = dataItem;
		} else if (dataItem.Left(8).Lower() == "oemlogo=") {
			if (dataItem != wxEmptyString) {
				wxBitmap bmp = UnwrapImage(dataItem);
				if (bmp.IsOk()) {
					m_oemLogo = bmp;
				}
			}
		} else if (dataItem.Left(15).Lower() == "oemproductname=") {
			dataItem.Replace(dataItem.Left(15), wxEmptyString, false);
			if (dataItem != wxEmptyString) {
				m_oemProductName = dataItem;
			}
		} else if (dataItem.Left(15).Lower() == "oemcompanyname=") {
			dataItem.Replace(dataItem.Left(15), wxEmptyString, false);
			if (dataItem != wxEmptyString) {
				m_oemCompanyName = dataItem;
			}
		}
		index++;
	}
}
