/////////////////////////////////////////////////////////////////////////////
// Name:        mcstatusbar.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     05/10/2012 21:48:38
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _MCSTATUSBAR_H_
#define _MCSTATUSBAR_H_


/*!
 * Includes
 */

////@begin includes
#include "wx/statusbr.h"
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
class mcStatusBar;
////@end forward declarations
class wxMachS;

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_STATUSBAR 10016
#define ID_HIST 10017
#define ID_LISTBOX1 10018
#define SYMBOL_MCSTATUSBAR_STYLE wxST_SIZEGRIP|wxSIMPLE_BORDER
#define SYMBOL_MCSTATUSBAR_IDNAME ID_STATUSBAR
#define SYMBOL_MCSTATUSBAR_SIZE wxDefaultSize
#define SYMBOL_MCSTATUSBAR_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * mcStatusBar class declaration
 */

class mcStatusBar: public wxStatusBar
{    
	DECLARE_DYNAMIC_CLASS( mcStatusBar )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	mcStatusBar();
	mcStatusBar(wxWindow* parent, wxWindowID id = wxID_ANY, long style = wxST_SIZEGRIP);

	/// Creation
	bool Create(wxWindow* parent, wxWindowID id = wxID_ANY, long style = wxST_SIZEGRIP);

	/// Destructor
	~mcStatusBar();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

////@begin mcStatusBar event handler declarations

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_HIST
	void OnHistClick( wxCommandEvent& event );

////@end mcStatusBar event handler declarations

////@begin mcStatusBar member function declarations

	wxMachS * GetGui() const { return m_gui ; }
	void SetGui(wxMachS * value) { m_gui = value ; }

	int GetOldHeight() const { return m_oldHeight ; }
	void SetOldHeight(int value) { m_oldHeight = value ; }

	int GetOldWidth() const { return m_oldWidth ; }
	void SetOldWidth(int value) { m_oldWidth = value ; }

	wxArrayString GetStatusArray() const { return m_statusArray ; }
	void SetStatusArray(wxArrayString value) { m_statusArray = value ; }

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end mcStatusBar member function declarations
#if 0
	void SetStatusText(const wxString& text, int i = 0);
#endif
	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin mcStatusBar member variables
	wxButton* m_statusHist;
	wxListBox* m_statusList;
	int m_oldHeight;
	int m_oldWidth;
public:
	wxMachS * m_gui;
protected:
	wxArrayString m_statusArray;
////@end mcStatusBar member variables
public:
    void OnSize(wxSizeEvent& event);

};

#endif
	// _MCSTATUSBAR_H_
