/////////////////////////////////////////////////////////////////////////////
// Name:        mcstatusbar.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     05/10/2012 21:48:38
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
#include "StatusList.h"
////@end includes

#include "mcStatusbar.h"
#include "wxMachs.h"

////@begin XPM images
////@end XPM images


/*
 * mcStatusBar type definition
 */

IMPLEMENT_DYNAMIC_CLASS( mcStatusBar, wxStatusBar )


/*
 * mcStatusBar event table definition
 */

BEGIN_EVENT_TABLE( mcStatusBar, wxStatusBar )

////@begin mcStatusBar event table entries
	EVT_BUTTON( ID_HIST, mcStatusBar::OnHistClick )
////@end mcStatusBar event table entries
EVT_SIZE(mcStatusBar::OnSize)

END_EVENT_TABLE()

/*
 * mcStatusBar constructors
 */

mcStatusBar::mcStatusBar()
{
	Init();
}

mcStatusBar::mcStatusBar(wxWindow* parent, wxWindowID id, long style)
{
	Init();
	Create(parent, id, style);
}


/*
 * mcStatusBar creator
 */

bool mcStatusBar::Create(wxWindow* parent, wxWindowID id, long style)
{
////@begin mcStatusBar creation
	wxStatusBar::Create(parent, id, style);
	CreateControls();
////@end mcStatusBar creation
	m_gui = (wxMachS *)parent;

	return true;
}


/*
 * mcStatusBar destructor
 */

mcStatusBar::~mcStatusBar()
{
////@begin mcStatusBar destruction
////@end mcStatusBar destruction
}


/*
 * Member initialisation
 */

void mcStatusBar::Init()
{
////@begin mcStatusBar member initialisation
	m_statusHist = NULL;
	m_statusList = NULL;
////@end mcStatusBar member initialisation
	m_gui = NULL;
}


/*
 * Control creation for mcStatusBar
 */

void mcStatusBar::CreateControls()
{    
////@begin mcStatusBar content construction
	mcStatusBar* itemStatusBar1 = this;

	m_statusHist = new wxButton( itemStatusBar1, ID_HIST, _("History"), wxDefaultPosition, wxDefaultSize, 0 );

	wxArrayString m_statusListStrings;
	m_statusList = new wxListBox( itemStatusBar1, ID_LISTBOX1, wxDefaultPosition, wxDefaultSize, m_statusListStrings, wxLB_SINGLE );
	m_statusList->Show(false);

////@end mcStatusBar content construction
}


/*
 * Should we show tooltips?
 */

bool mcStatusBar::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap mcStatusBar::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin mcStatusBar bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end mcStatusBar bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon mcStatusBar::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin mcStatusBar icon retrieval
	wxUnusedVar(name);
	return wxNullIcon;
////@end mcStatusBar icon retrieval
}

void mcStatusBar::OnSize(wxSizeEvent& event)
{
    wxRect rect;
	if (GetFieldsCount() > 0) {
		GetFieldRect(0, rect);
		wxSize size = m_statusHist->GetSize();
		m_statusHist->Move(rect.x + (rect.width - size.x) / 2,
						rect.y + (rect.height - size.y) / 2);
	}
	event.Skip();	
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_HIST
 */

void mcStatusBar::OnHistClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	StatusList* window = new StatusList(m_gui);
	window->SetStatusArray(&m_gui->m_statusArray);
	window->ShowModal();
	window->Destroy();
}

#if 0
void mcStatusBar::SetStatusText(const wxString& text, int i)
{
	if (GetStatusText(i) != text) {
		PopStatusText(i);
		PushStatusText(text, i);
		if (i == 1) {
			m_gui->m_statusHistList->Insert(text, m_gui->m_statusHistList->GetCount());
		}
	}
}
#endif
