#ifndef __MCDROEVENT_H__
#define __MCDROEVENT_H__

#include <wx/event.h>

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE(wxEVT_MCDRO_ENTER, -1)
END_DECLARE_EVENT_TYPES()

class WXDLLIMPEXP_CORE mcDroEvent : public wxEvent
{
public:
    mcDroEvent(wxEventType commandType = wxEVT_MCDRO_ENTER, int winid = 0, double dval = 0.0, MINSTANCE inst = 0)
		: wxEvent(winid, commandType),
          m_inst(inst),
          m_dval(dval)
        { }

    mcDroEvent(const mcDroEvent& event)
        : wxEvent(event),
          m_inst(event.m_inst),
          m_dval(event.m_dval)
        { }

    // accessors
	void SetInst(MINSTANCE inst) {m_inst = inst;}
	void SetDouble(double dval) {m_dval = dval;}
	MINSTANCE GetInst(void) {return(m_inst);}
	double GetDouble(void) {return(m_dval);}

    virtual wxEvent *Clone() const { return new mcDroEvent(*this); }

protected:
	MINSTANCE    m_inst;
    double       m_dval;

private:
    DECLARE_DYNAMIC_CLASS_NO_ASSIGN(mcDroEvent)
};


typedef void (wxEvtHandler::*mcDroEventFunction)(mcDroEvent&);

#define mcDroEventHandler(func) \
    (wxObjectEventFunction)(wxEventFunction)wxStaticCastEvent(mcDroEventFunction, &func)

#define EVT_MCDRO_ENTER(id, fn) \
    DECLARE_EVENT_TABLE_ENTRY( wxEVT_MCDRO_ENTER, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) \
    wxStaticCastEvent( mcDroEventFunction, & fn ), (wxObject *) NULL ),

#endif // __MCDROEVENT_H__