/////////////////////////////////////////////////////////////////////////////
// Name:        mcDro.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     02/05/2014 16:48:42
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _MCDRO_H_
#define _MCDRO_H_

#include <wx/event.h>
#include "mcDroEvent.h"

/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
class mcDro;
class mcStaticText;
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_MCDRO 10158
#define SYMBOL_MCDRO_STYLE wxSUNKEN_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_MCDRO_IDNAME ID_MCDRO
#define SYMBOL_MCDRO_SIZE wxDefaultSize
#define SYMBOL_MCDRO_POSITION wxDefaultPosition
#define SYMBOL_MCSTATICTEXT_STYLE wxALIGN_RIGHT|wxST_NO_AUTORESIZE
#define SYMBOL_MCSTATICTEXT_IDNAME wxID_STATIC
#define SYMBOL_MCSTATICTEXT_SIZE wxDefaultSize
#define SYMBOL_MCSTATICTEXT_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * mcDro class declaration
 */

class mcDro: public wxPanel
{    
	DECLARE_DYNAMIC_CLASS( mcDro )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	mcDro();
	mcDro(wxWindow* parent, wxWindowID id = ID_MCDRO, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxSUNKEN_BORDER|wxTAB_TRAVERSAL);

	/// Creation
	bool Create(wxWindow* parent, wxWindowID id = ID_MCDRO, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxSUNKEN_BORDER|wxTAB_TRAVERSAL);

	/// Destructor
	~mcDro();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();
	
	wxTextCtrl *CreateTextBox(long style);
	void DestroyTextBox(void);
	void EndEdit(void);
	virtual void SetLabel(const wxString &label);
    virtual wxString GetLabel() const;

	void OnKillFocus( wxFocusEvent& event );
	void OnTextBoxEnter( wxCommandEvent& event );

	int  GetFontFamily(void) { return(m_fontFamily); }
	void SetFontFamily(int family) { m_fontFamily = family; }
	int  GetFontStyle(void) { return(m_fontStyle); }
	void SetFontStyle(int style) { m_fontStyle = style; }
	int  GetFontWeight(void) { return(m_fontWeight); }
	void SetFontWeight(int weight) { m_fontWeight = weight; }
	bool GetFontUnderlined(void) { return(m_fontUnderlined); }
	void SetFontUnderlined(bool underlined) { m_fontUnderlined = underlined; }
	virtual bool SetFont(const wxFont &font);
	virtual bool SetForegroundColour(const wxColor &color);
	virtual bool SetBackgroundColour(const wxColor &color);
	void ScaleFont(wxWindow *control, const wxString &str);

    wxFont *NewFont(const wxSize& pixelSize,
           int family,
           int style,
           int weight,
           bool underlined = false,
           const wxString& face = wxEmptyString,
           wxFontEncoding encoding = wxFONTENCODING_DEFAULT)
    {
		if (m_font) {
			delete m_font;
		}
		m_font = wxFont::New(pixelSize, (wxFontFamily)family, (wxFontStyle)style, (wxFontWeight)weight, underlined, face, encoding);
		return(m_font);
    }

////@begin mcDro event handler declarations

	/// wxEVT_SIZE event handler for ID_MCDRO
	void OnSize( wxSizeEvent& event );

	/// wxEVT_LEFT_DOWN event handler for wxID_STATIC
	void OnLeftDown( wxMouseEvent& event );

////@end mcDro event handler declarations

////@begin mcDro member function declarations

	wxTextCtrl * GetTextBox() const { return m_textBox ; }
	void SetTextBox(wxTextCtrl * value) { m_textBox = value ; }

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end mcDro member function declarations

	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin mcDro member variables
	mcStaticText* m_label;
private:
	wxTextCtrl * m_textBox;
////@end mcDro member variables
	bool m_editing;
	wxColor m_fgColor;
	wxColor m_bgColor;
	wxFont *m_font;
	int  m_fontFamily;
	int  m_fontStyle;
	int  m_fontWeight;
	bool m_fontUnderlined;
};

/*!
 * mcStaticText class declaration
 */

class mcStaticText: public wxStaticText
{    
	DECLARE_DYNAMIC_CLASS( mcStaticText )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	mcStaticText();
	mcStaticText(wxWindow* parent, wxWindowID id, const wxString& label, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0);

	/// Creation
	bool Create(wxWindow* parent, wxWindowID id, const wxString& label, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0);

	/// Destructor
	~mcStaticText();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

////@begin mcStaticText event handler declarations

////@end mcStaticText event handler declarations

////@begin mcStaticText member function declarations

////@end mcStaticText member function declarations

////@begin mcStaticText member variables
////@end mcStaticText member variables
protected:
	virtual wxSize DoGetBestClientSize(void);
	virtual wxSize DoGetBestSize(void);
	virtual wxSize GetEffectiveMinSize() const;

};

#endif
	// _MCDRO_H_
