/////////////////////////////////////////////////////////////////////////////
// Name:        mcDro.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     02/05/2014 16:48:42
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"
#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "mcDro.h"
#include "wxMachs.h"
#include "Keypad.h"

////@begin XPM images
////@end XPM images


/*
 * mcDro type definition
 */

IMPLEMENT_DYNAMIC_CLASS( mcDro, wxPanel )


/*
 * mcDro event table definition
 */

BEGIN_EVENT_TABLE( mcDro, wxPanel )

////@begin mcDro event table entries
	EVT_SIZE( mcDro::OnSize )
////@end mcDro event table entries

END_EVENT_TABLE()


/*
 * mcDro constructors
 */

mcDro::mcDro()
{
	Init();
}

mcDro::mcDro(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style)
{
	Init();
	Create(parent, id, pos, size, style);
}


/*
 * mcDro creator
 */

bool mcDro::Create(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style)
{
////@begin mcDro creation
	wxPanel::Create(parent, id, pos, size, style);
	CreateControls();
////@end mcDro creation
	return true;
}


/*
 * mcDro destructor
 */

mcDro::~mcDro()
{
////@begin mcDro destruction
////@end mcDro destruction
}


/*
 * Member initialisation
 */

void mcDro::Init()
{
////@begin mcDro member initialisation
	m_textBox = NULL;
	m_label = NULL;
////@end mcDro member initialisation
	m_editing = false;
	m_font = NULL;
}


/*
 * Control creation for mcDro
 */

void mcDro::CreateControls()
{    
////@begin mcDro content construction
	mcDro* itemPanel1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
	itemPanel1->SetSizer(itemBoxSizer2);

	m_label = new mcStaticText( itemPanel1, wxID_STATIC, _("+000.0000"), wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT|wxST_NO_AUTORESIZE );
	itemBoxSizer2->Add(m_label, 1, wxGROW|wxALL, 3);

////@end mcDro content construction
	m_label->Connect(wxID_STATIC, wxEVT_LEFT_DOWN, wxMouseEventHandler(mcDro::OnLeftDown), NULL, this);
	m_label->SetValidator( wxTextValidator(wxFILTER_NUMERIC) );
	
}

bool mcDro::SetForegroundColour(const wxColor &color)
{
	m_fgColor = color;
	m_label->SetForegroundColour(m_fgColor);
	return(wxPanel::SetForegroundColour(color));
}

bool mcDro::SetBackgroundColour(const wxColor &color)
{
	m_bgColor = color;
	m_label->SetBackgroundColour(m_bgColor);
	return(wxPanel::SetBackgroundColour(color));
}

wxTextCtrl *mcDro::CreateTextBox(long style)
{
	wxSize size = m_label->GetSize();
	wxPoint pos = m_label->GetPosition();
	wxColor fg = m_label->GetForegroundColour();
	if (!m_textBox) {
		m_textBox = new wxTextCtrl( this, wxID_ANY, wxEmptyString, pos, size, style | wxTE_PROCESS_ENTER | wxWANTS_CHARS);
		// Connect events and objects
		m_textBox->Connect(m_textBox->GetId(), wxEVT_KILL_FOCUS, wxFocusEventHandler(mcDro::OnKillFocus), NULL, this);
		m_textBox->Connect(m_textBox->GetId(), wxEVT_COMMAND_TEXT_ENTER, wxTextEventHandler(mcDro::OnTextBoxEnter), NULL, this);
		// Set validators
		m_textBox->SetValidator( wxTextValidator(wxFILTER_NUMERIC) );
	}
	m_textBox->SetForegroundColour(fg);
	m_textBox->SetBackgroundStyle(wxBG_STYLE_COLOUR);
	m_textBox->SetBackgroundColour(m_bgColor);
	m_textBox->SetFont(m_label->GetFont());
	m_textBox->SetValue(m_label->GetLabel());
	m_textBox->Show();
	m_textBox->SetFocus();
	m_textBox->SelectAll();
	return(m_textBox);
}

void mcDro::DestroyTextBox(void)
{
	if (m_textBox) {
		m_textBox->Hide();
	}
}

/*
 * Should we show tooltips?
 */

bool mcDro::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap mcDro::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin mcDro bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end mcDro bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon mcDro::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin mcDro icon retrieval
	wxUnusedVar(name);
	return wxNullIcon;
////@end mcDro icon retrieval
}

void mcDro::EndEdit(void)
{
	if (m_textBox) {
		m_label->SetLabel(m_textBox->GetValue());
		// We have edited the DRO.  Send a message back up to the GUI to 
		// propagate it to the core.
		double val;
		m_label->GetLabel().ToDouble(&val);
		mcDroEvent evt(wxEVT_MCDRO_ENTER, this->GetId(), val);
		GetEventHandler()->AddPendingEvent(evt);
	}
	m_editing = false;
}

void mcDro::SetLabel(const wxString &label)
{
	if (!m_editing) {
		if (m_label->GetLabel() != label) {
			m_label->SetLabel(label);
		}
	}
}

wxString mcDro::GetLabel() const
{
	if (m_label) {
		return(m_label->GetLabel());
	}
	return(wxEmptyString);
}


void mcDro::OnLeftDown( wxMouseEvent& event )
{
	wxUnusedVar(event);
	if (!m_editing) {
		m_editing = true; // mark so that we don't update from the core!
		bool keypad = false;
		wxMachS *gui = wxMachS::FindGui(GetParent());
		if (gui) {
			keypad = gui->GetAutoCalcEnable();
		}
		if (keypad) {
			wxRect m4Rect = gui->GetScreenRect();
			wxPoint kpos;
			wxRect kpRect;
			Keypad *kp = new Keypad(GetParent(), m_label, wxID_ANY);
			gui->ConfigRestoreWindowSize(kp, wxT("Keypad"));
			// Try orienting bottom and right
			kpos = m_label->GetScreenPosition();
			kpos.y += m_label->GetSize().GetHeight();
			kpRect.SetPosition(kpos);
			kpRect.SetSize(kp->GetSize());
			if (!m4Rect.Contains(kpRect)) {
				// Try orienting bottom and left
				kpos = m_label->GetScreenPosition();
				kpos.y += m_label->GetSize().GetHeight();
				kpos.x -= (kp->GetSize().GetWidth() - m_label->GetSize().GetWidth());
				kpRect.SetPosition(kpos);
				kpRect.SetSize(kp->GetSize());
			}
			if (!m4Rect.Contains(kpRect)) {
				// Try orienting top and right
				kpos = m_label->GetScreenPosition();
				kpos.y -= kp->GetSize().GetHeight();
				kpRect.SetPosition(kpos);
				kpRect.SetSize(kp->GetSize());
			}
			if (!m4Rect.Contains(kpRect)) {
				// Try orienting top and left
				kpos = m_label->GetScreenPosition();
				kpos.y -= kp->GetSize().GetHeight();
				kpos.x -= (kp->GetSize().GetWidth() - m_label->GetSize().GetWidth());
				kpRect.SetPosition(kpos);
				kpRect.SetSize(kp->GetSize());
			}
			if (!m4Rect.Contains(kpRect)) {
				// We lost!  Orient to (0,0) of Mach screen.
				kpos = m4Rect.GetPosition();
			}

			kp->SetPosition(kpos);
			kp->ShowModal();
			gui->ConfigSaveWindowSize(kp, wxT("Keypad"));
			delete kp;
			// We have edited the DRO.  Send a message back up to the GUI to 
			// propagate it to the core.
			double val;
			m_label->GetLabel().ToDouble(&val);
			mcDroEvent evt(wxEVT_MCDRO_ENTER, this->GetId(), val);
			GetEventHandler()->AddPendingEvent(evt);
			m_editing = false;
			return;
		} else {
			// Just edit In-place.
			m_textBox = CreateTextBox(m_label->GetWindowStyle());
		}
	}
}


/*
 * wxEVT_COMMAND_TEXT_ENTER event handler for ID_TEXT_BOX
 */

void mcDro::OnTextBoxEnter( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_editing) {
		if (m_textBox) {
			DestroyTextBox();
		}
	}
}


/*
 * wxEVT_KILL_FOCUS event handler for ID_TEXT_BOX
 */

void mcDro::OnKillFocus( wxFocusEvent& event )
{
	if (m_editing) {
		EndEdit();
	}
	if (m_textBox) {
		DestroyTextBox();
		return;
	}
	event.Skip();
}


/*
 * wxEVT_SIZE event handler for wxID_STATIC
 */

void mcDro::OnSize( wxSizeEvent& event )
{
	wxUnusedVar(event);
	
	if (m_label) {
		wxSize sz = event.GetSize();
		sz.x-=4;
		sz.y-=4;
		m_label->SetSize(sz);
//		ScaleFont(m_label, m_label->GetLabel());
#if 1
		int width, height;
		//m_label->SetSize(event.GetSize());
		m_label->GetClientSize(&width, &height);
		m_label->GetCharHeight();
		if(height > 2) {
			int testHeight = height;
			m_label->SetFont(wxNullFont);
			m_font = NewFont(wxSize(0, testHeight - 4), GetFontFamily(), 
				GetFontStyle(), GetFontWeight(), GetFontUnderlined());
			m_label->SetFont(*m_font);
			m_label->Update();
		}
#endif
	}
	if (m_textBox) {
		m_textBox->SetSize(event.GetSize());
	}
}

bool mcDro::SetFont(const wxFont &font)
{
	m_fontFamily = font.GetFamily();
	m_fontStyle = font.GetStyle();
	m_fontWeight = font.GetWeight();
	m_fontUnderlined = font.GetUnderlined();
	return(wxPanel::SetFont(font));
}

#define ANTI_CLIPPING_CONSTANT 35
void mcDro::ScaleFont(wxWindow *control, const wxString &str)
{
	wxClientDC dc(control);
	wxFont font = control->GetFont();
	font.SetPointSize(6);
	wxSize fsize = font.GetPixelSize();
	wxSize csize = control->GetSize();
	int w, y;
	dc.GetTextExtent(str, &w, &y, NULL, NULL, &font);
	wxSize tsize = wxSize(w, y);
	
	if (tsize.GetWidth() < csize.GetWidth() && tsize.GetHeight() < csize.GetHeight()) {
		while (tsize.GetWidth() < csize.GetWidth() && tsize.GetHeight() < csize.GetHeight()) {
			font.MakeLarger();
			dc.GetTextExtent(str, &w, &y, NULL, NULL, &font);
			tsize = wxSize(w, y);
		}
	}
	control->SetFont(font);
	control->Update();
}


/*
 * mcStaticText type definition
 */

IMPLEMENT_DYNAMIC_CLASS( mcStaticText, wxStaticText )


/*
 * mcStaticText event table definition
 */

BEGIN_EVENT_TABLE( mcStaticText, wxStaticText )

////@begin mcStaticText event table entries
////@end mcStaticText event table entries

END_EVENT_TABLE()


/*
 * mcStaticText constructors
 */

mcStaticText::mcStaticText()
{
	Init();
}

mcStaticText::mcStaticText(wxWindow* parent, wxWindowID id, const wxString& label, const wxPoint& pos, const wxSize& size, long style)
{
	Init();
	Create(parent, id, label, pos, size, style);
}


/*
 * mcStaticText creator
 */

bool mcStaticText::Create(wxWindow* parent, wxWindowID id, const wxString& label, const wxPoint& pos, const wxSize& size, long style)
{
////@begin mcStaticText creation
	wxStaticText::Create(parent, id, label, pos, size, style);
	CreateControls();
////@end mcStaticText creation
	return true;
}


/*
 * mcStaticText destructor
 */

mcStaticText::~mcStaticText()
{
////@begin mcStaticText destruction
////@end mcStaticText destruction
}


/*
 * Member initialisation
 */

void mcStaticText::Init()
{
////@begin mcStaticText member initialisation
////@end mcStaticText member initialisation
}


/*
 * Control creation for mcStaticText
 */

void mcStaticText::CreateControls()
{    
////@begin mcStaticText content construction
////@end mcStaticText content construction
}

wxSize mcStaticText::DoGetBestClientSize(void)
{
	return(wxSize(10, 10));
}

wxSize mcStaticText::DoGetBestSize(void)
{
	return(wxSize(10, 10));
}

wxSize mcStaticText::GetEffectiveMinSize() const
{
	return(wxSize(10, 10));
}




