/////////////////////////////////////////////////////////////////////////////
// Name:        led.h
// Purpose:
// Author:      Joachim Buermann
// Id:          $Id$
// Copyright:   (c) 2001 Joachim Buermann
/////////////////////////////////////////////////////////////////////////////

#ifndef __LED_H
#define __LED_H

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif


enum wxLedType {
    wxLED_NORMAL = 0,
    wxLED_BLINK
};

enum wxLedState {
    wxLED_ON = 0,
    wxLED_OFF
};

enum wxLedColor {
    wxLED_AMBER = 0,
	wxLED_BLUE,
	wxLED_GREEN,
	wxLED_RED,
	wxLED_PURPLE,
	wxLED_WHITE,
	wxLED_YELLOW
};


class BlinkTimer;

class wxLed : public wxWindow
{
protected:
    // bitmap for double buffering
    wxBitmap* m_bitmap;
    wxIcon* m_icons[2];
	wxLedType m_type;
    BlinkTimer* m_timer;
	wxLedColor m_color;
	wxWindow* m_parent;
	bool m_enabled;
	int m_blinkms;
    int m_blink;
    int m_x;
    int m_y;
protected:
    // protected member functions
    void DrawOnBitmap();
public:
    wxLed(wxWindow* parent,
		wxWindowID id,
		const wxPoint& pos = wxPoint(0,0),
		const wxSize& size = wxSize(16,16),
		// red LED is default
		wxLedColor color = wxLED_RED);
    ~wxLed();
    bool Create(wxWindow* parent, 
		wxWindowID id,
		const wxPoint& pos = wxPoint(0,0),
		const wxSize& size = wxSize(16,16),
		// red LED is default
		wxLedColor color = wxLED_RED);
    void Blink();
    void OnErase(wxEraseEvent& WXUNUSED(erase)) {
	   Redraw();
    };
    void OnPaint(wxPaintEvent& WXUNUSED(event));
    void OnSizeEvent(wxSizeEvent& event);
    void Redraw();
    void SetColor(wxLedColor color);
	wxLedColor GetColor();
	void SetType(wxLedType type);
	wxLedType GetType();
    bool Enable (bool enable = true);
	void SetBlinkRate(int ms);
	int GetBlinkRate(void);
    DECLARE_EVENT_TABLE()
};

class BlinkTimer : public wxTimer
{
protected:
    wxLed* m_led;
public:
    BlinkTimer(wxLed *led) : wxTimer() {
	   m_led = led;
    };
    void Notify() {
	   m_led->Blink();
    };
};

#endif
