/////////////////////////////////////////////////////////////////////////////
// Name:        led.cpp
// Purpose:
// Author:      Joachim Buermann
// Id:          $Id$
// Copyright:   (c) 2001 Joachim Buermann
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

#include "led.h"
#include "leds.xpm"

BEGIN_EVENT_TABLE(wxLed, wxWindow)
EVT_ERASE_BACKGROUND(wxLed::OnErase)
EVT_PAINT(wxLed::OnPaint)
EVT_SIZE(wxLed::OnSizeEvent)
END_EVENT_TABLE()

wxLed::wxLed(wxWindow* parent,
			   wxWindowID id,
			   const wxPoint& pos,
			   const wxSize& size,
			   wxLedColor color) :
wxWindow(parent, id, pos, size, wxNO_FULL_REPAINT_ON_RESIZE)
{
	m_type = wxLED_NORMAL;
	m_bitmap = new wxBitmap(16,16);
	m_timer = NULL;
	m_blink = 0;
	m_x = m_y = 0;

	m_icons[wxLED_ON] = NULL;
	m_icons[wxLED_OFF] = NULL;
	SetColor(color);

	m_timer = new BlinkTimer(this);
}

bool wxLed::Create(wxWindow* parent,
			   wxWindowID id,
			   const wxPoint& pos,
			   const wxSize& size,
			   wxLedColor color)
{
	wxWindow::Create(parent, id, pos, size, wxNO_FULL_REPAINT_ON_RESIZE);
	SetColor(color);
	this->InheritsBackgroundColour();
	return(true);
}

wxLed::~wxLed()
{
	if (m_timer) {
		m_timer->Stop();
		delete m_timer;
	}
	delete m_bitmap;
	delete m_icons[wxLED_OFF];
	delete m_icons[wxLED_ON];
}

void wxLed::Blink()
{
	m_blink ^= 1;
	Redraw();
}

void wxLed::Redraw() {
	wxClientDC dc(this);
	DrawOnBitmap();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
}

void wxLed::DrawOnBitmap()
{
	wxSize s = GetClientSize();
	int cw = s.GetWidth();
	int ch = s.GetHeight();
	if (ch < 1 || cw < 1) {
		return;
	}

	if ((m_bitmap->GetWidth() != cw) || (m_bitmap->GetHeight() != ch)) {
		m_bitmap->Create(s.x,s.y);
	}

	int w = m_icons[wxLED_ON]->GetWidth();
	int h = m_icons[wxLED_ON]->GetHeight();

	if ((cw > w) || (ch > h)) {
		m_x = (cw - w) / 2;
		m_y = (ch - h) / 2;
	}
#ifndef __WX_GTKZ__
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);

	wxColor color = this->GetParent()->GetBackgroundColour(); 
	wxBrush brush(color, wxBRUSHSTYLE_SOLID);
		
	dc.SetBackground(brush);
	dc.Clear();

	if (m_isEnabled) {
		if (m_type == wxLED_BLINK) {
			dc.DrawIcon(*m_icons[m_blink],m_x,m_y);
		} else {
			dc.DrawIcon(*m_icons[wxLED_ON],m_x,m_y);
		}
	} else {
		dc.DrawIcon(*m_icons[wxLED_OFF],m_x,m_y);
	}


	//dc.SelectObject(wxNullBitmap);
#endif
}

void wxLed::SetColor(wxLedColor color)
{

	m_color = color;

	if (m_icons[wxLED_ON])	delete m_icons[wxLED_ON];
	if (m_icons[wxLED_OFF]) delete m_icons[wxLED_OFF];

	switch (color) {
	case wxLED_AMBER:
		m_icons[wxLED_ON] = new wxIcon((const char **)amber_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)amber_off_16_xpm);
		break;
	case wxLED_BLUE:
		m_icons[wxLED_ON] = new wxIcon((const char **)blue_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)blue_off_16_xpm);
		break;
	case wxLED_GREEN:
		m_icons[wxLED_ON] = new wxIcon((const char **)green_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)green_off_16_xpm);
		break;
	case wxLED_RED:
		m_icons[wxLED_ON] = new wxIcon((const char **)red_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)red_off_16_xpm);
		break;
	case wxLED_PURPLE:
		m_icons[wxLED_ON] = new wxIcon((const char **)uv_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)uv_off_16_xpm);
		break;
	case wxLED_WHITE:
		m_icons[wxLED_ON] = new wxIcon((const char **)white_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)white_off_16_xpm);
		break;
	case wxLED_YELLOW:
		m_icons[wxLED_ON] = new wxIcon((const char **)yellow_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)yellow_off_16_xpm);
		break;
	default:
		m_icons[wxLED_ON] = new wxIcon((const char **)red_on_16_xpm);
		m_icons[wxLED_OFF] = new wxIcon((const char **)red_off_16_xpm);
		m_color = wxLED_RED;
		break;
	}

}

wxLedColor wxLed::GetColor(void)
{
	return(m_color);
}

void wxLed::SetType(wxLedType type)
{
	if (m_timer->IsRunning()) {
		m_timer->Stop();
	}

	switch (type) {
	case wxLED_BLINK:
		m_type = wxLED_BLINK;
		if (m_isEnabled) {
			m_timer->Start(m_blinkms);
		}
		break;
	case wxLED_NORMAL:
	default:
		m_type = wxLED_NORMAL;
		break;
	}
}

wxLedType wxLed::GetType()
{
	return(m_type);
}

void wxLed::SetBlinkRate(int ms)
{
	if (ms < 0) {
		m_blinkms = 0;
	} else {
		m_blinkms = ms;
	}

	if (m_timer->IsRunning()) {
		m_timer->Stop();
	}

	if (m_isEnabled && (m_type == wxLED_BLINK)) {
		m_timer->Start(m_blinkms);
	}
}

int wxLed::GetBlinkRate(void)
{
	return(m_blinkms);
}

bool wxLed::Enable(bool enable)
{
	bool status = wxWindow::Enable (enable);

	if (m_timer->IsRunning()) {
		m_timer->Stop();
	}

	if (m_isEnabled && (m_type == wxLED_BLINK)) {
		m_timer->Start(m_blinkms);
	}
	Redraw();
	return status;
}

void wxLed::OnSizeEvent(wxSizeEvent& event) {
   wxSize size = event.GetSize();
   m_x = (size.GetX() - m_icons[0]->GetWidth()) >> 1;
   m_y = (size.GetY() - m_icons[0]->GetHeight()) >> 1;
   if(m_x < 0) m_x = 0;
   if(m_y < 0) m_y = 0;
   DrawOnBitmap();
}

void wxLed::OnPaint(wxPaintEvent& WXUNUSED(event)) {
	wxPaintDC dc(this);
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
}
