#include "stdafx.h"
#include "Utils.h"
#include <wx/regex.h>

#define INT_REGX wxT("%[-+ 0#]*[0-9]*d+")
#define FLOAT_REGX wxT("%[-+ 0#]*[0-9]*[.]*[0-9]*f+")
static wxRegEx intRegEx(INT_REGX);
static wxRegEx floatRegEx(FLOAT_REGX);

#if defined(_WIN32) || defined(_WIN64)
#ifdef _DEBUG
	#ifndef DBG_NEW
		#define DBG_NEW new ( _NORMAL_BLOCK , __FILE__ , __LINE__ )
		#define new DBG_NEW
	#endif
#endif  // _DEBUG
#endif

bool SetWorkingDirectory(const char *dir)
{
#if !(defined(_WIN32) || defined(_WIN64))
    return(chdir(dir) == 0);
#else
#ifdef __WXWINCE__
    // No equivalent in WinCE
    wxUnusedVar(d);
    return false;
#else
    return((bool)(SetCurrentDirectoryA(dir) != 0));
#endif
#endif
}

char *GetCwd(char *buf, int sz)
{
    bool ok = false;

#if defined(_WIN32) || defined(_WIN64)
    ok = _getcwd(buf, sz) != NULL;
#else
	if (getcwd(buf , sz)) {
		ok = true;
	} else {
		ok = false ;
	}
#endif // platform

    if ( !ok ) {
        buf[0] = '\0';
    } 

    return(buf);
}

bool CheckIntFormat(const wxString &fmt)
{
	bool rc = false;
	if (intRegEx.IsValid()) {
		rc = intRegEx.Matches(fmt);
	}
	return(rc);
}

bool CheckFloatFormat(const wxString &fmt)
{
	bool rc = false;
	if (floatRegEx.IsValid()) {
		rc = floatRegEx.Matches(fmt);
	}
	return(rc);
}


bool CheckFomrmat(const wxString &fmt)
{
	return(CheckIntFormat(fmt) || CheckFloatFormat(fmt));
}

wxString ProfileGetString(MINSTANCE inst, const wxString &section, const wxString &key, const wxString &defval)
{
	char buf[1024];
	memset(buf, 0, sizeof(buf));
	mcProfileGetString(inst, wxToChar(section), wxToChar(key), buf, sizeof(buf) - 1, wxToChar(defval));
	wxString retval = wxString::FromUTF8(buf);
	return(retval);
}

double ProfileGetDouble(MINSTANCE inst, const wxString &section, const wxString &key, double defval)
{
	double retval = 0.0;
	mcProfileGetDouble(inst, wxToChar(section), wxToChar(key), &retval, defval);
	return(retval);
}

int ProfileGetInt(MINSTANCE inst, const wxString &section, const wxString &key, int defval)
{
	long retval = 0;
	mcProfileGetInt(inst, wxToChar(section), wxToChar(key), &retval, (long)defval);
	return((int)retval);
}

long ProfileGetLong(MINSTANCE inst, const wxString &section, const wxString &key, long defval)
{
	long retval = 0;
	mcProfileGetInt(inst, wxToChar(section), wxToChar(key), &retval, defval);
	return(retval);
}

bool ProfileGetBool(MINSTANCE inst, const wxString &section, const wxString &key, bool defval)
{
	bool retval = false;
	long val = 0;
	mcProfileGetInt(inst, wxToChar(section), wxToChar(key), &val, defval ? 1 : 0);
	retval = val != 0 ? true : false;
	return(retval);
}

void ProfileSetString(MINSTANCE inst, const wxString &section, const wxString &key, const wxString &val)
{
	mcProfileWriteString(inst, wxToChar(section), wxToChar(key), wxToChar(val));
}

void ProfileSetDouble(MINSTANCE inst, const wxString &section, const wxString &key, double val)
{
	mcProfileWriteDouble(inst, wxToChar(section), wxToChar(key), val);
}

void ProfileSetInt(MINSTANCE inst, const wxString &section, const wxString &key, int val)
{
	mcProfileWriteInt(inst, wxToChar(section), wxToChar(key), (long)val);
}

void ProfileSetLong(MINSTANCE inst, const wxString &section, const wxString &key, long val)
{
	mcProfileWriteInt(inst, wxToChar(section), wxToChar(key), val);
}

void ProfileSetBool(MINSTANCE inst, const wxString &section, const wxString &key, bool val)
{
	long rval = val ? 1 : 0;
	mcProfileWriteInt(inst, wxToChar(section), wxToChar(key), rval);
}
