/////////////////////////////////////////////////////////////////////////////
// Name:        ToolPathProgress.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     25/02/2012 17:58:26
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "ToolPathProgress.h"
#include "MachAPI.h"

////@begin XPM images
////@end XPM images


/*
 * ToolPathProgress type definition
 */

IMPLEMENT_DYNAMIC_CLASS( ToolPathProgress, wxDialog )


/*
 * ToolPathProgress event table definition
 */

BEGIN_EVENT_TABLE( ToolPathProgress, wxDialog )

////@begin ToolPathProgress event table entries
	EVT_CLOSE( ToolPathProgress::OnCloseWindow )
	EVT_IDLE( ToolPathProgress::OnIdle )
	EVT_BUTTON( ID_BUTTON43, ToolPathProgress::OnCancelButtonClick )
////@end ToolPathProgress event table entries

END_EVENT_TABLE()


/*
 * ToolPathProgress constructors
 */

ToolPathProgress::ToolPathProgress()
{
	Init();
}

ToolPathProgress::ToolPathProgress( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create(parent, id, caption, pos, size, style);
}


/*
 * ToolPathProgress creator
 */

bool ToolPathProgress::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin ToolPathProgress creation
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	wxDialog::Create( parent, id, caption, pos, size, style );

	CreateControls();
	if (GetSizer())
	{
		GetSizer()->SetSizeHints(this);
	}
	Centre();
////@end ToolPathProgress creation
	return true;
}


/*
 * ToolPathProgress destructor
 */

ToolPathProgress::~ToolPathProgress()
{
	if (m_timer) {
		delete m_timer;
		m_timer = NULL;
	}
}


/*
 * Member initialisation
 */

void ToolPathProgress::Init()
{
////@begin ToolPathProgress member initialisation
	m_gauge = NULL;
////@end ToolPathProgress member initialisation
	done = false;
	dontShow = false;
}


/*
 * Control creation for ToolPathProgress
 */

void ToolPathProgress::CreateControls()
{    
////@begin ToolPathProgress content construction
	ToolPathProgress* itemDialog1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemDialog1->SetSizer(itemBoxSizer2);

	wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	itemBoxSizer3->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	m_gauge = new wxGauge( itemDialog1, ID_GAUGE, 100, wxDefaultPosition, wxSize(300, -1), wxGA_HORIZONTAL );
	m_gauge->SetValue(0);
	m_gauge->SetName(wxT("m_gauge"));
	itemBoxSizer3->Add(m_gauge, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	itemBoxSizer3->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxBoxSizer* itemBoxSizer7 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer7, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxButton* itemButton8 = new wxButton( itemDialog1, ID_BUTTON43, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
	itemButton8->SetDefault();
	itemBoxSizer7->Add(itemButton8, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end ToolPathProgress content construction
    m_timer = new wxTimer(this, wxNewId());
	Connect(m_timer->GetId(), wxEVT_TIMER, wxTimerEventHandler(ToolPathProgress::OnTimer), NULL, this);

	if (mcToolPathGenerate(0) == MERROR_NOERROR) {
		m_timer->Start(100, true);
	} else {
		dontShow = true;
	}
}


/*
 * Should we show tooltips?
 */

bool ToolPathProgress::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap ToolPathProgress::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin ToolPathProgress bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end ToolPathProgress bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon ToolPathProgress::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin ToolPathProgress icon retrieval
	wxUnusedVar(name);
	return wxNullIcon;
////@end ToolPathProgress icon retrieval
}

void ToolPathProgress::OnTimer(wxTimerEvent& event)
{
	double percent = 0;
	static double oldpercent;
	wxUnusedVar(event);

	m_timer->Stop();
	mcToolPathGeneratedPercent(0, &percent);
	if (percent != oldpercent) {
		m_gauge->SetValue((int)percent);
	}
	if (percent != 100) {
		m_timer->Start(1, true);
	} else {
		if (!done) {
			done = true;
			this->EndModal(wxID_OK);
		}
	}	
}


/*
 * wxEVT_IDLE event handler for ID_TOOLPATHPROGRESS
 */

void ToolPathProgress::OnIdle( wxIdleEvent& event )
{
	wxUnusedVar(event);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON43
 */

void ToolPathProgress::OnCancelButtonClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_timer->Stop();
	mcToolPathGenerateAbort(0);
	this->EndModal(wxID_CANCEL);
}


/*
 * wxEVT_CLOSE_WINDOW event handler for ID_TOOLPATHPROGRESS
 */

void ToolPathProgress::OnCloseWindow( wxCloseEvent& event )
{
	wxUnusedVar(event);
	m_timer->Stop();
	mcToolPathGenerateAbort(0);
	this->EndModal(wxID_CANCEL);
}

