/////////////////////////////////////////////////////////////////////////////
// Name:        StatusList.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     09/10/2012 13:03:21
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _STATUSLIST_H_
#define _STATUSLIST_H_


/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_STATUSLIST 11000
#define ID_LISTBOX3 11001
#define ID_BUTTON35 11002
#define ID_BUTTON34 11003
#define ID_STATE_SAVE 11004
#define SYMBOL_STATUSLIST_STYLE wxRESIZE_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_STATUSLIST_TITLE _("Status History")
#define SYMBOL_STATUSLIST_IDNAME ID_STATUSLIST
#define SYMBOL_STATUSLIST_SIZE wxSize(400, 300)
#define SYMBOL_STATUSLIST_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * StatusList class declaration
 */

class StatusList: public wxDialog
{    
	DECLARE_DYNAMIC_CLASS( StatusList )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	StatusList();
	StatusList( wxWindow* parent, wxWindowID id = SYMBOL_STATUSLIST_IDNAME, const wxString& caption = SYMBOL_STATUSLIST_TITLE, const wxPoint& pos = SYMBOL_STATUSLIST_POSITION, const wxSize& size = SYMBOL_STATUSLIST_SIZE, long style = SYMBOL_STATUSLIST_STYLE );

	/// Creation
	bool Create( wxWindow* parent, wxWindowID id = SYMBOL_STATUSLIST_IDNAME, const wxString& caption = SYMBOL_STATUSLIST_TITLE, const wxPoint& pos = SYMBOL_STATUSLIST_POSITION, const wxSize& size = SYMBOL_STATUSLIST_SIZE, long style = SYMBOL_STATUSLIST_STYLE );

	/// Destructor
	~StatusList();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

////@begin StatusList event handler declarations

	/// wxEVT_INIT_DIALOG event handler for ID_STATUSLIST
	void OnInitDialog( wxInitDialogEvent& event );

	/// wxEVT_SET_FOCUS event handler for ID_STATUSLIST
	void OnSetFocus( wxFocusEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON35
	void OnClose( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON34
	void OnClear( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_STATE_SAVE
	void OnStateSaveClick( wxCommandEvent& event );

////@end StatusList event handler declarations

////@begin StatusList member function declarations

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end StatusList member function declarations

	/// Should we show tooltips?
	static bool ShowToolTips();
	void SetStatusArray(wxArrayString *value);
	int ShowModal(void);

////@begin StatusList member variables
	wxListBox* m_StatusList;
////@end StatusList member variables
private:
	wxArrayString *m_StatusArray;
};

#endif
	// _STATUSLIST_H_
