/////////////////////////////////////////////////////////////////////////////
// Name:        StatusList.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     09/10/2012 13:03:21
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "StatusList.h"

////@begin XPM images
#include "MachGroupLogoOnly-32.xpm"
////@end XPM images

/*
 * StatusList type definition
 */

IMPLEMENT_DYNAMIC_CLASS( StatusList, wxDialog )


/*
 * StatusList event table definition
 */

BEGIN_EVENT_TABLE( StatusList, wxDialog )

////@begin StatusList event table entries
	EVT_INIT_DIALOG( StatusList::OnInitDialog )
	EVT_SET_FOCUS( StatusList::OnSetFocus )
	EVT_BUTTON( ID_BUTTON35, StatusList::OnClose )
	EVT_BUTTON( ID_BUTTON34, StatusList::OnClear )
	EVT_BUTTON( ID_STATE_SAVE, StatusList::OnStateSaveClick )
////@end StatusList event table entries

END_EVENT_TABLE()


/*
 * StatusList constructors
 */

StatusList::StatusList()
{
	Init();
}

StatusList::StatusList( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create(parent, id, caption, pos, size, style);
}


/*
 * StatusList creator
 */

bool StatusList::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin StatusList creation
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	wxDialog::Create( parent, id, caption, pos, size, style );

	CreateControls();
	SetIcon(GetIconResource(wxT("MachGroupLogoOnly-32.xpm")));
	if (GetSizer())
	{
		GetSizer()->SetSizeHints(this);
	}
	Centre();
////@end StatusList creation
#ifdef INDUSTRIAL
	SetIcon(GetIconResource(wxT("art/Mach_Industrial-32.xpm")));
#endif
	return true;
}


/*
 * StatusList destructor
 */

StatusList::~StatusList()
{
////@begin StatusList destruction
////@end StatusList destruction
}


/*
 * Member initialisation
 */

void StatusList::Init()
{
////@begin StatusList member initialisation
	m_StatusList = NULL;
////@end StatusList member initialisation
	m_StatusArray = NULL;
}


/*
 * Control creation for StatusList
 */

void StatusList::CreateControls()
{    
////@begin StatusList content construction
	StatusList* itemDialog1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemDialog1->SetSizer(itemBoxSizer2);

	wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer3, 1, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxVERTICAL);
	itemBoxSizer3->Add(itemBoxSizer4, 0, wxGROW|wxALL, 2);

	wxStaticText* itemStaticText5 = new wxStaticText( itemDialog1, wxID_STATIC, _("Oldest"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer4->Add(itemStaticText5, 1, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticText* itemStaticText6 = new wxStaticText( itemDialog1, wxID_STATIC, _("Newest"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer4->Add(itemStaticText6, 0, wxGROW|wxALL, 5);

	wxArrayString m_StatusListStrings;
	m_StatusList = new wxListBox( itemDialog1, ID_LISTBOX3, wxDefaultPosition, wxSize(400, 200), m_StatusListStrings, wxLB_SINGLE );
	itemBoxSizer3->Add(m_StatusList, 1, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer8 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer8, 0, wxALIGN_LEFT|wxALL, 5);

	wxButton* itemButton9 = new wxButton( itemDialog1, ID_BUTTON35, _("&Close"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer8->Add(itemButton9, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxButton* itemButton10 = new wxButton( itemDialog1, ID_BUTTON34, _("Cl&ear"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer8->Add(itemButton10, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxButton* itemButton11 = new wxButton( itemDialog1, ID_STATE_SAVE, _("&Save"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer8->Add(itemButton11, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end StatusList content construction
}


/*
 * Should we show tooltips?
 */

bool StatusList::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap StatusList::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin StatusList bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end StatusList bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon StatusList::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin StatusList icon retrieval
	wxUnusedVar(name);
	if (name == wxT("MachGroupLogoOnly-32.xpm"))
	{
		wxIcon icon(MachGroupLogoOnly_32_xpm);
		return icon;
	}
	return wxNullIcon;
////@end StatusList icon retrieval
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON35
 */

void StatusList::OnClose( wxCommandEvent& event )
{
	wxUnusedVar(event);
	EndModal(wxID_OK);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON34
 */

void StatusList::OnClear( wxCommandEvent& event )
{
	wxUnusedVar(event);
	if (m_StatusArray != NULL) {
		m_StatusArray->Clear();
	}
	mcCntlSetLastError(0, " ");
	m_StatusList->Clear();
}


/*
 * wxEVT_INIT_DIALOG event handler for ID_STATUSLIST
 */

void StatusList::OnInitDialog( wxInitDialogEvent& event )
{
	wxUnusedVar(event);
}

void StatusList::SetStatusArray(wxArrayString *value)
{
	m_StatusArray = value;
	if (!m_StatusArray->IsEmpty()) {
		m_StatusList->InsertItems(*m_StatusArray, 0);
	}
	if (m_StatusArray != NULL) {
		if (m_StatusList->GetCount() > 0) {
			m_StatusList->EnsureVisible(m_StatusList->GetCount() - 1);
			m_StatusList->SetSelection(m_StatusList->GetCount() - 1);
		}
	}
}


/*
 * wxEVT_SET_FOCUS event handler for ID_STATUSLIST
 */

void StatusList::OnSetFocus( wxFocusEvent& event )
{
////@begin wxEVT_SET_FOCUS event handler for ID_STATUSLIST in StatusList.
	// Before editing this code, remove the block markers.
	event.Skip();
////@end wxEVT_SET_FOCUS event handler for ID_STATUSLIST in StatusList. 
}

int StatusList::ShowModal(void)
{
	if (m_StatusArray != NULL) {
		if (m_StatusList->GetCount() > 0) {
			m_StatusList->EnsureVisible(m_StatusList->GetCount() - 1);
			m_StatusList->SetSelection(m_StatusList->GetCount() - 1);
		}
	}
	return(wxDialog::ShowModal());
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_STATE_SAVE
 */

void StatusList::OnStateSaveClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	wxFileDialog *fd = new wxFileDialog(this, _("Save Status History As..."), wxGetCwd(), _("history.txt"), _("Text files (*.txt)|*.txt|All files (*)|*"), wxFD_SAVE);
	int rc = fd->ShowModal();
	if (rc == wxID_OK) {
		wxString fileName = fd->GetPath();
		int cnt = (int)m_StatusList->GetCount();
		m_StatusList->GetStrings();
		wxFile pf;
		pf.Create(fileName, true);
		pf.Close();
		pf.Open(fileName, wxFile::read_write);
		if (pf.IsOpened()) {
			for (int idx = 0; idx < cnt; idx++) {
				pf.Write(m_StatusList->GetString(idx));
			}
			pf.Close();
		} else {
			wxMessageBox(_("Error Openining\"") + fileName + _("\" for writing!"), _("File Error!"));
		}
	}
	fd->Destroy();
}

