/////////////////////////////////////////////////////////////////////////////
// Name:        Splash.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     07/09/2012 20:24:24
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _SPLASH_H_
#define _SPLASH_H_


/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_SPLASH 10190
#define SYMBOL_SPLASH_STYLE wxTAB_TRAVERSAL
#define SYMBOL_SPLASH_TITLE _("Splash")
#define SYMBOL_SPLASH_IDNAME ID_SPLASH
#define SYMBOL_SPLASH_SIZE wxSize(400, 300)
#define SYMBOL_SPLASH_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * Splash class declaration
 */

class Splash: public wxDialog
{    
	DECLARE_DYNAMIC_CLASS( Splash )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	Splash();
	Splash( wxWindow* parent, wxWindowID id = SYMBOL_SPLASH_IDNAME, const wxString& caption = SYMBOL_SPLASH_TITLE, const wxPoint& pos = SYMBOL_SPLASH_POSITION, const wxSize& size = SYMBOL_SPLASH_SIZE, long style = SYMBOL_SPLASH_STYLE );

	/// Creation
	bool Create( wxWindow* parent, wxWindowID id = SYMBOL_SPLASH_IDNAME, const wxString& caption = SYMBOL_SPLASH_TITLE, const wxPoint& pos = SYMBOL_SPLASH_POSITION, const wxSize& size = SYMBOL_SPLASH_SIZE, long style = SYMBOL_SPLASH_STYLE );

	/// Destructor
	~Splash();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();
	void OnTimer(wxTimerEvent& event);
	virtual int ShowModal(void);
	

////@begin Splash event handler declarations

////@end Splash event handler declarations

////@begin Splash member function declarations

	wxWindow * GetParent() const { return m_parent ; }
	void SetParent(wxWindow * value) { m_parent = value ; }

	wxTimer * GetTimer() const { return m_timer ; }
	void SetTimer(wxTimer * value) { m_timer = value ; }

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end Splash member function declarations

	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin Splash member variables
protected:
	wxWindow * m_parent;
	wxTimer * m_timer;
////@end Splash member variables
};

#endif
	// _SPLASH_H_
