/////////////////////////////////////////////////////////////////////////////
// Name:        Splash.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     07/09/2012 20:24:24
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "Splash.h"

////@begin XPM images
#include "splashgcode.xpm"
////@end XPM images


/*
 * Splash type definition
 */

IMPLEMENT_DYNAMIC_CLASS( Splash, wxDialog )


/*
 * Splash event table definition
 */

BEGIN_EVENT_TABLE( Splash, wxDialog )

////@begin Splash event table entries
////@end Splash event table entries

END_EVENT_TABLE()


/*
 * Splash constructors
 */

Splash::Splash()
{
	Init();
}

Splash::Splash( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create(parent, id, caption, pos, size, style);
}


/*
 * Splash creator
 */

bool Splash::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin Splash creation
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	wxDialog::Create( parent, id, caption, pos, size, style );

	CreateControls();
	if (GetSizer())
	{
		GetSizer()->SetSizeHints(this);
	}
	Centre();
////@end Splash creation
	m_parent = parent;
	return true;
}


/*
 * Splash destructor
 */

Splash::~Splash()
{
////@begin Splash destruction
////@end Splash destruction
}


/*
 * Member initialisation
 */

void Splash::Init()
{
////@begin Splash member initialisation
	m_parent = NULL;
	m_timer = NULL;
////@end Splash member initialisation
}


/*
 * Control creation for Splash
 */

void Splash::CreateControls()
{    
////@begin Splash content construction
	Splash* itemDialog1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemDialog1->SetSizer(itemBoxSizer2);

	wxStaticBitmap* itemStaticBitmap3 = new wxStaticBitmap( itemDialog1, wxID_STATIC, itemDialog1->GetBitmapResource(wxT("splashgcode.xpm")), wxDefaultPosition, wxSize(300, 200), 0 );
	itemBoxSizer2->Add(itemStaticBitmap3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

////@end Splash content construction
	m_timer = new wxTimer(this, 30000);
	Connect(m_timer->GetId(), wxEVT_TIMER, wxTimerEventHandler(Splash::OnTimer), NULL, this);
}


/*
 * Should we show tooltips?
 */

bool Splash::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap Splash::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin Splash bitmap retrieval
	wxUnusedVar(name);
	if (name == wxT("splashgcode.xpm"))
	{
		wxBitmap bitmap(spalshgcode_xpm);
		return bitmap;
	}
	return wxNullBitmap;
////@end Splash bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon Splash::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin Splash icon retrieval
	wxUnusedVar(name);
	return wxNullIcon;
////@end Splash icon retrieval
}

int Splash::ShowModal(void)
{
	m_timer->Start(5000, true);
	this->CenterOnScreen();
	return(wxDialog::ShowModal());
}

void Splash::OnTimer(wxTimerEvent& event)
{
	wxUnusedVar(event);
	this->EndModal(wxID_OK);
	if (m_parent != NULL) {
		m_parent->SetFocus();
	}
}
