/////////////////////////////////////////////////////////////////////////////
// Name:        SelDev.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     30/08/2012 12:18:03
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _SELDEV_H_
#define _SELDEV_H_


/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_SELECTDEV 10171
#define ID_MOTION_SEL_LIST 10168
#define SYMBOL_SELDEV_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX|wxTAB_TRAVERSAL
#define SYMBOL_SELDEV_TITLE _("Select Motion Device")
#define SYMBOL_SELDEV_IDNAME ID_SELECTDEV
#define SYMBOL_SELDEV_SIZE wxSize(400, 300)
#define SYMBOL_SELDEV_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * SelDev class declaration
 */

class SelDev: public wxDialog
{    
	DECLARE_DYNAMIC_CLASS( SelDev )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	SelDev();
	SelDev( wxWindow* parent, wxWindowID id = SYMBOL_SELDEV_IDNAME, const wxString& caption = SYMBOL_SELDEV_TITLE, const wxPoint& pos = SYMBOL_SELDEV_POSITION, const wxSize& size = SYMBOL_SELDEV_SIZE, long style = SYMBOL_SELDEV_STYLE );

	/// Creation
	bool Create( wxWindow* parent, wxWindowID id = SYMBOL_SELDEV_IDNAME, const wxString& caption = SYMBOL_SELDEV_TITLE, const wxPoint& pos = SYMBOL_SELDEV_POSITION, const wxSize& size = SYMBOL_SELDEV_SIZE, long style = SYMBOL_SELDEV_STYLE );

	/// Destructor
	~SelDev();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

	/// Transfer data to the window
	virtual bool TransferDataToWindow();

	/// Transfer data from the window
	virtual bool TransferDataFromWindow();

////@begin SelDev event handler declarations

	/// wxEVT_INIT_DIALOG event handler for ID_SELECTDEV
	void OnInitDialog( wxInitDialogEvent& event );

	/// wxEVT_CLOSE_WINDOW event handler for ID_SELECTDEV
	void OnCloseWindow( wxCloseEvent& event );

	/// wxEVT_COMMAND_CHECKLISTBOX_TOGGLED event handler for ID_MOTION_SEL_LIST
	void OnMotionSelListToggled( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
	void OnOkClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
	void OnCancelClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_APPLY
	void OnApplyClick( wxCommandEvent& event );

	/// wxEVT_UPDATE_UI event handler for wxID_APPLY
	void OnApplyUpdate( wxUpdateUIEvent& event );

////@end SelDev event handler declarations

	void SetInstance(MINSTANCE inst) { m_inst = inst; }

////@begin SelDev member function declarations

	wxString GetDevName() const { return m_devName ; }
	void SetDevName(wxString value) { m_devName = value ; }

	bool GetModified() const { return m_modified ; }
	void SetModified(bool value) { m_modified = value ; }

	int GetSelected() const { return m_selected ; }
	void SetSelected(int value) { m_selected = value ; }

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end SelDev member function declarations

	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin SelDev member variables
	wxCheckListBox* m_motionSelectList;
private:
	bool m_modified; // User interface update flag for the Apply button.
protected:
	wxString m_devName; // The current motion device name.
	int m_selected; // The current index of the selected device.
////@end SelDev member variables

	struct {
		wxArrayString motionDevName;
		wxArrayString motionDevDesc;
	} m_motionDeviceList;

	MINSTANCE m_inst;

};

#endif
	// _SELDEV_H_
