/////////////////////////////////////////////////////////////////////////////
// Name:        SelDev.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     30/08/2012 12:18:03
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "MachAPI.h"

#include "SelDev.h"

////@begin XPM images
#include "MachGroupLogoOnly-32.xpm"
////@end XPM images

/*
 * SelDev type definition
 */

IMPLEMENT_DYNAMIC_CLASS( SelDev, wxDialog )


/*
 * SelDev event table definition
 */

BEGIN_EVENT_TABLE( SelDev, wxDialog )

////@begin SelDev event table entries
	EVT_INIT_DIALOG( SelDev::OnInitDialog )
	EVT_CLOSE( SelDev::OnCloseWindow )
	EVT_CHECKLISTBOX( ID_MOTION_SEL_LIST, SelDev::OnMotionSelListToggled )
	EVT_BUTTON( wxID_OK, SelDev::OnOkClick )
	EVT_BUTTON( wxID_CANCEL, SelDev::OnCancelClick )
	EVT_BUTTON( wxID_APPLY, SelDev::OnApplyClick )
	EVT_UPDATE_UI( wxID_APPLY, SelDev::OnApplyUpdate )
////@end SelDev event table entries

END_EVENT_TABLE()


/*
 * SelDev constructors
 */

SelDev::SelDev()
{
	Init();
}

SelDev::SelDev( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create(parent, id, caption, pos, size, style);
}


/*
 * SelDev creator
 */

bool SelDev::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin SelDev creation
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	wxDialog::Create( parent, id, caption, pos, size, style );

	CreateControls();
	SetIcon(GetIconResource(wxT("MachGroupLogoOnly-32.xpm")));
	if (GetSizer())
	{
		GetSizer()->SetSizeHints(this);
	}
	Centre();
////@end SelDev creation
	return true;
}


/*
 * SelDev destructor
 */

SelDev::~SelDev()
{
////@begin SelDev destruction
////@end SelDev destruction
}


/*
 * Member initialisation
 */

void SelDev::Init()
{
////@begin SelDev member initialisation
	m_devName = wxT("");
	m_modified = false;
	m_selected = -1;
	m_motionSelectList = NULL;
////@end SelDev member initialisation
	m_inst = 0;
}


/*
 * Control creation for SelDev
 */

void SelDev::CreateControls()
{    
////@begin SelDev content construction
	SelDev* itemDialog1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemDialog1->SetSizer(itemBoxSizer2);

	wxStaticText* itemStaticText3 = new wxStaticText( itemDialog1, wxID_STATIC, _("Select the motion control device.\nWARNING!  \nChanging the motion control device will destroy any existing \naxis to motor mapping and motor tuning."), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE );
	itemBoxSizer2->Add(itemStaticText3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxArrayString m_motionSelectListStrings;
	m_motionSelectList = new wxCheckListBox( itemDialog1, ID_MOTION_SEL_LIST, wxDefaultPosition, wxSize(-1, 200), m_motionSelectListStrings, wxLB_SINGLE );
	itemBoxSizer2->Add(m_motionSelectList, 1, wxGROW|wxALL, 5);

	wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
	itemBoxSizer2->Add(itemBoxSizer5, 0, wxALIGN_RIGHT|wxALL, 5);

	wxButton* itemButton6 = new wxButton( itemDialog1, wxID_OK, _("OK"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer5->Add(itemButton6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxButton* itemButton7 = new wxButton( itemDialog1, wxID_CANCEL, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer5->Add(itemButton7, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

	wxButton* itemButton8 = new wxButton( itemDialog1, wxID_APPLY, _("&Apply"), wxDefaultPosition, wxDefaultSize, 0 );
	itemBoxSizer5->Add(itemButton8, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end SelDev content construction
}


/*
 * Should we show tooltips?
 */

bool SelDev::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap SelDev::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin SelDev bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end SelDev bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon SelDev::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin SelDev icon retrieval
	wxUnusedVar(name);
	if (name == wxT("MachGroupLogoOnly-32.xpm"))
	{
		wxIcon icon(MachGroupLogoOnly_32_xpm);
		return icon;
	}
	return wxNullIcon;
////@end SelDev icon retrieval
}


/*
 * wxEVT_INIT_DIALOG event handler for ID_SELDEV
 */

void SelDev::OnInitDialog( wxInitDialogEvent& event )
{
	wxUnusedVar(event);
	event.Skip();
}


/*
 * wxEVT_CLOSE_WINDOW event handler for ID_SELDEV
 */

void SelDev::OnCloseWindow( wxCloseEvent& event )
{
	wxUnusedVar(event);
	mcCntlStartMotionDev(m_inst);
	this->EndModal(-1);
}


/*
 * Transfer data to the window
 */

bool SelDev::TransferDataToWindow()
{
	// common stuff 

	HMCDEV hDev = 0;
	devinfo_t devinf;
	int rc = 0;
	mcCntlStopMotionDev(m_inst);
	// Motion Device Selection
	char str_devname[80];
	mcProfileGetString(m_inst, "Preferences", "MotionDevice", str_devname, 80, "");
	wxString seldevname = wxString::FromUTF8(str_devname);
	m_devName = seldevname;

	m_motionDeviceList.motionDevName.Clear();
	m_motionDeviceList.motionDevDesc.Clear();
	hDev = 0;
	int idx = 0;
	m_selected = -1;
	while (mcDeviceGetNextHandle(m_inst, DEV_TYPE_MOTION, hDev, &hDev) == MERROR_NOERROR) {
		rc = mcDeviceGetInfoStruct(hDev, &devinf);
		wxString devname = wxString::FromUTF8(devinf.devName);
		m_motionDeviceList.motionDevDesc.Add(wxString::FromUTF8(devinf.devDesc));
		m_motionDeviceList.motionDevName.Add(wxString::FromUTF8(devinf.devName));
		if (devname == seldevname) {
			m_selected = idx;
		}
		idx++;
	}
	m_motionSelectList->InsertItems(m_motionDeviceList.motionDevDesc, 0);
	if (m_selected != -1) {
		m_motionSelectList->Check((unsigned int)m_selected, true);
	}

	return wxDialog::TransferDataToWindow();
}

/*
 * Transfer data from the window
 */

bool SelDev::TransferDataFromWindow()
{
	bool checked = false;
	// Motion Device Selection
	for (unsigned int idx = 0; idx < m_motionSelectList->GetCount(); idx++) {
		if (m_motionSelectList->IsChecked(idx)) {
			mcProfileWriteString(m_inst, "Preferences", "MotionDevice", wxToChar(m_motionDeviceList.motionDevName[idx]));
			checked = true;
		}
	}

	if (!checked) {
		mcProfileWriteString(m_inst, "Preferences", "MotionDevice", "");
	}

	return wxDialog::TransferDataFromWindow();
}


/*
 * wxEVT_COMMAND_CHECKLISTBOX_TOGGLED event handler for ID_MOTION_SEL_LIST
 */

void SelDev::OnMotionSelListToggled( wxCommandEvent& event )
{
	int idx = 0;
	wxCheckListBox *list = (wxCheckListBox *)event.GetEventObject();
	if (list == this->m_motionSelectList) {
		idx = event.GetInt();
		bool checked = m_motionSelectList->IsChecked((unsigned int)idx);
		if (checked) {
			for (unsigned int index = 0; index < m_motionSelectList->GetCount(); index++) {
				if (index != (unsigned int)idx && m_motionSelectList->IsChecked(index)) {
					m_motionSelectList->Check(index, false);
				}
			}
		}
		m_modified = (this->m_devName != m_motionDeviceList.motionDevName[idx]) ? true : false;
	}

	m_selected = -1;
	for (unsigned int index = 0; index < m_motionSelectList->GetCount(); index++) {
		if (m_motionSelectList->IsChecked(index)) {
			m_selected = (int)index;
		}
	}

	event.Skip();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void SelDev::OnOkClick( wxCommandEvent& event )
{
	TransferDataFromWindow();
	mcCntlStartMotionDev(m_inst);
	wxUnusedVar(event);
	EndModal(wxID_OK);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void SelDev::OnCancelClick( wxCommandEvent& event )
{
	mcCntlStartMotionDev(m_inst);
	wxUnusedVar(event);
	EndModal(wxID_CANCEL);
}

/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_APPLY
 */

void SelDev::OnApplyClick( wxCommandEvent& event )
{
	if (m_selected != -1) {
		m_devName = m_motionDeviceList.motionDevName[m_selected];
		m_modified = false;
	}
	event.Skip();
}

/*
 * wxEVT_UPDATE_UI event handler for wxID_APPLY
 */

void SelDev::OnApplyUpdate( wxUpdateUIEvent& event )
{
	event.Enable(m_modified);
}

