/////////////////////////////////////////////////////////////////////////////
// Name:        RecentFile.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     10/10/2012 19:05:49
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _RECENTFILE_H_
#define _RECENTFILE_H_


/*!
 * Includes
 */

////@begin includes
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_RECENTFILE 10214
#define ID_LISTBOX2 10215
#define SYMBOL_RECENTFILE_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX|wxTAB_TRAVERSAL
#define SYMBOL_RECENTFILE_TITLE _("Open Recent File")
#define SYMBOL_RECENTFILE_IDNAME ID_RECENTFILE
#define SYMBOL_RECENTFILE_SIZE wxSize(400, 300)
#define SYMBOL_RECENTFILE_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * RecentFile class declaration
 */

class RecentFile: public wxDialog
{    
	DECLARE_DYNAMIC_CLASS( RecentFile )
	DECLARE_EVENT_TABLE()

public:
	/// Constructors
	RecentFile();
	RecentFile( wxWindow* parent, wxWindowID id = SYMBOL_RECENTFILE_IDNAME, const wxString& caption = SYMBOL_RECENTFILE_TITLE, const wxPoint& pos = SYMBOL_RECENTFILE_POSITION, const wxSize& size = SYMBOL_RECENTFILE_SIZE, long style = SYMBOL_RECENTFILE_STYLE );

	/// Creation
	bool Create( wxWindow* parent, wxWindowID id = SYMBOL_RECENTFILE_IDNAME, const wxString& caption = SYMBOL_RECENTFILE_TITLE, const wxPoint& pos = SYMBOL_RECENTFILE_POSITION, const wxSize& size = SYMBOL_RECENTFILE_SIZE, long style = SYMBOL_RECENTFILE_STYLE );

	/// Destructor
	~RecentFile();

	/// Initialises member variables
	void Init();

	/// Creates the controls and sizers
	void CreateControls();

////@begin RecentFile event handler declarations

	/// wxEVT_CLOSE_WINDOW event handler for ID_RECENTFILE
	void OnCloseWindow( wxCloseEvent& event );

	/// wxEVT_COMMAND_LISTBOX_DOUBLECLICKED event handler for ID_LISTBOX2
	void OnListboxDoubleClicked( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
	void OnOkClick( wxCommandEvent& event );

	/// wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
	void OnCancelClick( wxCommandEvent& event );

////@end RecentFile event handler declarations

////@begin RecentFile member function declarations

	/// Retrieves bitmap resources
	wxBitmap GetBitmapResource( const wxString& name );

	/// Retrieves icon resources
	wxIcon GetIconResource( const wxString& name );
////@end RecentFile member function declarations

	/// Should we show tooltips?
	static bool ShowToolTips();

////@begin RecentFile member variables
	wxListBox* m_recentFileList;
////@end RecentFile member variables
	wxString GetPath(void);
	void SetFileList(const wxArrayString &list);
};

#endif
	// _RECENTFILE_H_
