/////////////////////////////////////////////////////////////////////////////
// Name:        RecentFile.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     10/10/2012 19:05:49
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "RecentFile.h"

////@begin XPM images
#include "MachGroupLogoOnly-32.xpm"
////@end XPM images

/*
 * RecentFile type definition
 */

IMPLEMENT_DYNAMIC_CLASS( RecentFile, wxDialog )


/*
 * RecentFile event table definition
 */

BEGIN_EVENT_TABLE( RecentFile, wxDialog )

////@begin RecentFile event table entries
	EVT_CLOSE( RecentFile::OnCloseWindow )
	EVT_LISTBOX_DCLICK( ID_LISTBOX2, RecentFile::OnListboxDoubleClicked )
	EVT_BUTTON( wxID_OK, RecentFile::OnOkClick )
	EVT_BUTTON( wxID_CANCEL, RecentFile::OnCancelClick )
////@end RecentFile event table entries

END_EVENT_TABLE()


/*
 * RecentFile constructors
 */

RecentFile::RecentFile()
{
	Init();
}

RecentFile::RecentFile( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	Init();
	Create(parent, id, caption, pos, size, style);
}


/*
 * RecentFile creator
 */

bool RecentFile::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin RecentFile creation
	SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
	wxDialog::Create( parent, id, caption, pos, size, style );

	CreateControls();
	SetIcon(GetIconResource(wxT("MachGroupLogoOnly-32.xpm")));
	if (GetSizer())
	{
		GetSizer()->SetSizeHints(this);
	}
	Centre();
////@end RecentFile creation
#ifdef INDUSTRIAL
	SetIcon(GetIconResource(wxT("art/Mach_Industrial-32.xpm")));
#endif
	return true;
}


/*
 * RecentFile destructor
 */

RecentFile::~RecentFile()
{
////@begin RecentFile destruction
////@end RecentFile destruction
}


/*
 * Member initialisation
 */

void RecentFile::Init()
{
////@begin RecentFile member initialisation
	m_recentFileList = NULL;
////@end RecentFile member initialisation
}


/*
 * Control creation for RecentFile
 */

void RecentFile::CreateControls()
{    
////@begin RecentFile content construction
	RecentFile* itemDialog1 = this;

	wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
	itemDialog1->SetSizer(itemBoxSizer2);

	wxArrayString m_recentFileListStrings;
	m_recentFileList = new wxListBox( itemDialog1, ID_LISTBOX2, wxDefaultPosition, wxSize(300, 200), m_recentFileListStrings, wxLB_SINGLE );
	itemBoxSizer2->Add(m_recentFileList, 1, wxGROW|wxALL, 5);

	wxStdDialogButtonSizer* itemStdDialogButtonSizer4 = new wxStdDialogButtonSizer;

	itemBoxSizer2->Add(itemStdDialogButtonSizer4, 0, wxALIGN_LEFT|wxALL, 5);
	wxButton* itemButton5 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
	itemStdDialogButtonSizer4->AddButton(itemButton5);

	wxButton* itemButton6 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
	itemStdDialogButtonSizer4->AddButton(itemButton6);

	itemStdDialogButtonSizer4->Realize();

////@end RecentFile content construction
}


/*
 * Should we show tooltips?
 */

bool RecentFile::ShowToolTips()
{
	return true;
}

/*
 * Get bitmap resources
 */

wxBitmap RecentFile::GetBitmapResource( const wxString& name )
{
	// Bitmap retrieval
////@begin RecentFile bitmap retrieval
	wxUnusedVar(name);
	return wxNullBitmap;
////@end RecentFile bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon RecentFile::GetIconResource( const wxString& name )
{
	// Icon retrieval
////@begin RecentFile icon retrieval
	wxUnusedVar(name);
	if (name == wxT("MachGroupLogoOnly-32.xpm"))
	{
		wxIcon icon(MachGroupLogoOnly_32_xpm);
		return icon;
	}
	return wxNullIcon;
////@end RecentFile icon retrieval
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void RecentFile::OnOkClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	EndModal(wxID_OK);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void RecentFile::OnCancelClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	EndModal(wxID_CANCEL);
}

/*
 * wxEVT_CLOSE_WINDOW event handler for ID_RECENTFILE
 */

void RecentFile::OnCloseWindow( wxCloseEvent& event )
{
	wxUnusedVar(event);
	EndModal(wxID_CANCEL);
}

wxString RecentFile::GetPath(void)
{
	wxString retval = wxEmptyString;
	int selection = m_recentFileList->GetSelection();
	if (selection != -1) {
		retval = m_recentFileList->GetString(selection);
	}
	return(retval);
}

void RecentFile::SetFileList(const wxArrayString &list)
{
	m_recentFileList->Set(list);
}


/*
 * wxEVT_COMMAND_LISTBOX_DOUBLECLICKED event handler for ID_LISTBOX2
 */

void RecentFile::OnListboxDoubleClicked( wxCommandEvent& event )
{
	wxUnusedVar(event);
	EndModal(wxID_OK);
}

