/////////////////////////////////////////////////////////////////////////////
// Name:        KeypadEx.h
// Purpose:     
// Author:      Newfangled Solutions
// Modified by: 
// Created:     02/05/2014 14:10:21
// RCS-ID:      
// Copyright:   Copyright 2013
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _KEYPADEX_H_
#define _KEYPADEX_H_


/*!
 * Includes
 */

////@begin includes
////@end includes
#include "KeypadCommon.h"

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_KEYPADEX 10042
#define ID_EXT_PANEL 10028
#define ID_EX_SINE 10029
#define ID_EX_COSINE 10030
#define ID_EX_TANGENT 10031
#define ID_EX_TANGENTH 10032
#define ID_EX_FACTORIAL 10033
#define ID_EX_XPOWY 10034
#define ID_EX_LOG_NATURAL 10035
#define ID_EX_LOG 10036
#define ID_EX_SQUARE_ROOT 10037
#define ID_EX_MODULUS 10038
#define ID_EX_RECIPROCAL 10039
#define ID_EX_PI 10040
#define ID_EX_MEM_CLEAR 10023
#define ID_EX_MEM_RECALL 10024
#define ID_EX_MEM_STORE 10025
#define ID_EX_MEM_ADD 10041
#define ID_EX_MEM_SUB 10027
#define ID_EX_ESCAPE 10005
#define ID_EX_CLEAR_ERROR 10006
#define ID_EX_CLEAR 10007
#define ID_EX_PLUS_MINUS 10003
#define ID_EX_NUM7 10008
#define ID_EX_NUM8 10009
#define ID_EX_NUM9 10010
#define ID_EX_DIVIDE 10002
#define ID_EX_NUM4 10011
#define ID_EX_NUM5 10012
#define ID_EX_NUM6 10013
#define ID_EX_MULTIPLY 10001
#define ID_EX_NUM1 10014
#define ID_EX_NUM2 10015
#define ID_EX_NUM3 10016
#define ID_EX_MINUS 10000
#define ID_EX_NUM0 10020
#define ID_EX_DECIMAL 10021
#define ID_EX_PLUS 10022
#define ID_EX_BACK_SPACE 10017
#define ID_EX_EQUAL 10018
#define ID_EX_ENTER 10019
#define SYMBOL_KEYPADEX_STYLE wxRESIZE_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_KEYPADEX_TITLE _("KeypadEx")
#define SYMBOL_KEYPADEX_IDNAME ID_KEYPADEX
#define SYMBOL_KEYPADEX_SIZE wxSize(400, 300)
#define SYMBOL_KEYPADEX_POSITION wxDefaultPosition
////@end control identifiers

/*!
 * KeypadEx class declaration
 */

class KeypadEx: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( KeypadEx )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    KeypadEx();
    KeypadEx( wxWindow* parent, wxWindowID id = SYMBOL_KEYPADEX_IDNAME, const wxString& caption = SYMBOL_KEYPADEX_TITLE, const wxPoint& pos = SYMBOL_KEYPADEX_POSITION, const wxSize& size = SYMBOL_KEYPADEX_SIZE, long style = SYMBOL_KEYPADEX_STYLE );
    KeypadEx( wxWindow* parent, wxStaticText *staticText, wxWindowID id = SYMBOL_KEYPADEX_IDNAME, const wxString& caption = SYMBOL_KEYPADEX_TITLE, const wxPoint& pos = SYMBOL_KEYPADEX_POSITION, const wxSize& size = SYMBOL_KEYPADEX_SIZE, long style = SYMBOL_KEYPADEX_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_KEYPADEX_IDNAME, const wxString& caption = SYMBOL_KEYPADEX_TITLE, const wxPoint& pos = SYMBOL_KEYPADEX_POSITION, const wxSize& size = SYMBOL_KEYPADEX_SIZE, long style = SYMBOL_KEYPADEX_STYLE );

    /// Destructor
    ~KeypadEx();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin KeypadEx event handler declarations

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_SINE
    void OnSineClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_COSINE
    void OnCosineClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_TANGENT
    void OnTangentClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_TANGENTH
    void OnTangenthClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_FACTORIAL
    void OnFactorialClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_XPOWY
    void OnXpowyClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_LOG_NATURAL
    void OnLogNaturalClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_LOG
    void OnLogClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_SQUARE_ROOT
    void OnSquareRootClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MODULUS
    void OnModulusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_RECIPROCAL
    void OnReciprocalClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PI
    void OnPiClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_RECALL
    void OnMemRecallClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_STORE
    void OnMemStoreClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_ADD
    void OnMemAddClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_SUB
    void OnMemSubClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_ESCAPE
    void OnEscClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_CLEAR_ERROR
    void OnClearErrorClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_CLEAR
    void OnClearClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PLUS_MINUS
    void OnPlusMinusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_NUM7
    void OnNumberClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_DIVIDE
    void OnDivideClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MULTIPLY
    void OnMultiplyClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MINUS
    void OnMinusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PLUS
    void OnPlusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_BACK_SPACE
    void OnBackSpaceClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_EQUAL
    void OnEqualClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_ENTER
    void OnEnterClick( wxCommandEvent& event );

////@end KeypadEx event handler declarations
	double Calc(void);

////@begin KeypadEx member function declarations

    wxString GetOrgVal() const { return m_orgVal ; }
    void SetOrgVal(wxString value) { m_orgVal = value ; }

    wxStaticText * GetStaticText() const { return m_staticText ; }
    void SetStaticText(wxStaticText * value) { m_staticText = value ; }

    wxString GetValue() const { return m_value ; }
    void SetValue(wxString value) { m_value = value ; }

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end KeypadEx member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin KeypadEx member variables
    wxPanel* m_extPanel;
    wxStaticText * m_staticText;
private:
    wxString m_orgVal;
    wxString m_value;
////@end KeypadEx member variables

private:
	bool   m_init;
	Entries m_entries;
	double m_memory;
};

#endif
    // _KEYPADEX_H_
