/////////////////////////////////////////////////////////////////////////////
// Name:        KeypadEx.cpp
// Purpose:     
// Author:      Newfangled Solutions
// Modified by: 
// Created:     02/05/2014 14:10:21
// RCS-ID:      
// Copyright:   Copyright 2013
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "KeypadEx.h"

////@begin XPM images
////@end XPM images


/*
 * KeypadEx type definition
 */

IMPLEMENT_DYNAMIC_CLASS( KeypadEx, wxDialog )


/*
 * KeypadEx event table definition
 */

BEGIN_EVENT_TABLE( KeypadEx, wxDialog )

////@begin KeypadEx event table entries
    EVT_BUTTON( ID_EX_SINE, KeypadEx::OnSineClick )
    EVT_BUTTON( ID_EX_COSINE, KeypadEx::OnCosineClick )
    EVT_BUTTON( ID_EX_TANGENT, KeypadEx::OnTangentClick )
    EVT_BUTTON( ID_EX_TANGENTH, KeypadEx::OnTangenthClick )
    EVT_BUTTON( ID_EX_FACTORIAL, KeypadEx::OnFactorialClick )
    EVT_BUTTON( ID_EX_XPOWY, KeypadEx::OnXpowyClick )
    EVT_BUTTON( ID_EX_LOG_NATURAL, KeypadEx::OnLogNaturalClick )
    EVT_BUTTON( ID_EX_LOG, KeypadEx::OnLogClick )
    EVT_BUTTON( ID_EX_SQUARE_ROOT, KeypadEx::OnSquareRootClick )
    EVT_BUTTON( ID_EX_MODULUS, KeypadEx::OnModulusClick )
    EVT_BUTTON( ID_EX_RECIPROCAL, KeypadEx::OnReciprocalClick )
    EVT_BUTTON( ID_EX_PI, KeypadEx::OnPiClick )
    EVT_BUTTON( ID_EX_MEM_RECALL, KeypadEx::OnMemRecallClick )
    EVT_BUTTON( ID_EX_MEM_STORE, KeypadEx::OnMemStoreClick )
    EVT_BUTTON( ID_EX_MEM_ADD, KeypadEx::OnMemAddClick )
    EVT_BUTTON( ID_EX_MEM_SUB, KeypadEx::OnMemSubClick )
    EVT_BUTTON( ID_EX_ESCAPE, KeypadEx::OnEscClick )
    EVT_BUTTON( ID_EX_CLEAR_ERROR, KeypadEx::OnClearErrorClick )
    EVT_BUTTON( ID_EX_CLEAR, KeypadEx::OnClearClick )
    EVT_BUTTON( ID_EX_PLUS_MINUS, KeypadEx::OnPlusMinusClick )
    EVT_BUTTON( ID_EX_NUM7, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM8, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM9, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_DIVIDE, KeypadEx::OnDivideClick )
    EVT_BUTTON( ID_EX_NUM4, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM5, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM6, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_MULTIPLY, KeypadEx::OnMultiplyClick )
    EVT_BUTTON( ID_EX_NUM1, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM2, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_NUM3, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_MINUS, KeypadEx::OnMinusClick )
    EVT_BUTTON( ID_EX_NUM0, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_DECIMAL, KeypadEx::OnNumberClick )
    EVT_BUTTON( ID_EX_PLUS, KeypadEx::OnPlusClick )
    EVT_BUTTON( ID_EX_BACK_SPACE, KeypadEx::OnBackSpaceClick )
    EVT_BUTTON( ID_EX_EQUAL, KeypadEx::OnEqualClick )
    EVT_BUTTON( ID_EX_ENTER, KeypadEx::OnEnterClick )
////@end KeypadEx event table entries

END_EVENT_TABLE()


/*
 * KeypadEx constructors
 */

KeypadEx::KeypadEx()
{
    Init();
}

KeypadEx::KeypadEx( wxWindow* parent, wxStaticText *staticText, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	double dval;
    Init();
	m_staticText = staticText;
    Create(parent, id, caption, pos, size, style);
	m_orgVal = m_staticText->GetLabel();
	m_value.Clear();
	m_orgVal.ToDouble(&dval);
}

KeypadEx::KeypadEx( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Init();
    Create(parent, id, caption, pos, size, style);
}


/*
 * KeyPadEx creator
 */

bool KeypadEx::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin KeypadEx creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end KeypadEx creation
    return true;
}


/*
 * KeypadEx destructor
 */

KeypadEx::~KeypadEx()
{
////@begin KeypadEx destruction
////@end KeypadEx destruction
}


/*
 * Member initialisation
 */

void KeypadEx::Init()
{
////@begin KeypadEx member initialisation
    m_staticText = NULL;
    m_extPanel = NULL;
////@end KeypadEx member initialisation
	m_init = true;
}


/*
 * Control creation for KeyPadEx
 */

void KeypadEx::CreateControls()
{    
////@begin KeypadEx content construction
    KeypadEx* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 2, wxGROW|wxALL, 0);

    m_extPanel = new wxPanel( itemDialog1, ID_EXT_PANEL, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL );
    itemBoxSizer3->Add(m_extPanel, 1, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxVERTICAL);
    m_extPanel->SetSizer(itemBoxSizer5);

    wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer6, 1, wxGROW|wxALL, 0);

    wxButton* itemButton7 = new wxButton( m_extPanel, ID_EX_SINE, _("sin"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer6->Add(itemButton7, 1, wxGROW|wxALL, 2);

    wxButton* itemButton8 = new wxButton( m_extPanel, ID_EX_COSINE, _("cos"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer6->Add(itemButton8, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer9 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer9, 1, wxGROW|wxALL, 0);

    wxButton* itemButton10 = new wxButton( m_extPanel, ID_EX_TANGENT, _("tan"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer9->Add(itemButton10, 1, wxGROW|wxALL, 2);

    wxButton* itemButton11 = new wxButton( m_extPanel, ID_EX_TANGENTH, _("tanh"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer9->Add(itemButton11, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer12 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer12, 1, wxGROW|wxALL, 0);

    wxButton* itemButton13 = new wxButton( m_extPanel, ID_EX_FACTORIAL, _("n!"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer12->Add(itemButton13, 1, wxGROW|wxALL, 2);

    wxButton* itemButton14 = new wxButton( m_extPanel, ID_EX_XPOWY, _("x^y"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer12->Add(itemButton14, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer15, 1, wxGROW|wxALL, 0);

    wxButton* itemButton16 = new wxButton( m_extPanel, ID_EX_LOG_NATURAL, _("ln"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer15->Add(itemButton16, 1, wxGROW|wxALL, 2);

    wxButton* itemButton17 = new wxButton( m_extPanel, ID_EX_LOG, _("log"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer15->Add(itemButton17, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer18 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer18, 1, wxGROW|wxALL, 0);

    wxButton* itemButton19 = new wxButton( m_extPanel, ID_EX_SQUARE_ROOT, _("sqr"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer18->Add(itemButton19, 1, wxGROW|wxALL, 2);

    wxButton* itemButton20 = new wxButton( m_extPanel, ID_EX_MODULUS, _("mod"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer18->Add(itemButton20, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer21 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer21, 1, wxGROW|wxALL, 0);

    wxButton* itemButton22 = new wxButton( m_extPanel, ID_EX_RECIPROCAL, _("1/x"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton22, 1, wxGROW|wxALL, 2);

    wxButton* itemButton23 = new wxButton( m_extPanel, ID_EX_PI, _("Pi"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton23, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer24 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer24, 5, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer25 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer24->Add(itemBoxSizer25, 1, wxGROW|wxALL, 0);

    wxButton* itemButton26 = new wxButton( itemDialog1, ID_EX_MEM_CLEAR, _("MC"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer25->Add(itemButton26, 1, wxGROW|wxALL, 2);

    wxButton* itemButton27 = new wxButton( itemDialog1, ID_EX_MEM_RECALL, _("MR"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer25->Add(itemButton27, 1, wxGROW|wxALL, 2);

    wxButton* itemButton28 = new wxButton( itemDialog1, ID_EX_MEM_STORE, _("MS"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer25->Add(itemButton28, 1, wxGROW|wxALL, 2);

    wxButton* itemButton29 = new wxButton( itemDialog1, ID_EX_MEM_ADD, _("M+"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer25->Add(itemButton29, 1, wxGROW|wxALL, 2);

    wxButton* itemButton30 = new wxButton( itemDialog1, ID_EX_MEM_SUB, _("M-"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer25->Add(itemButton30, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer31 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer24->Add(itemBoxSizer31, 5, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer32 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer31->Add(itemBoxSizer32, 4, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer33 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer32->Add(itemBoxSizer33, 1, wxGROW|wxALL, 0);

    wxButton* itemButton34 = new wxButton( itemDialog1, ID_EX_ESCAPE, _("Esc"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemButton34->SetForegroundColour(wxColour(255, 0, 0));
    itemBoxSizer33->Add(itemButton34, 1, wxGROW|wxALL, 2);

    wxButton* itemButton35 = new wxButton( itemDialog1, ID_EX_CLEAR_ERROR, _("CE"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer33->Add(itemButton35, 1, wxGROW|wxALL, 2);

    wxButton* itemButton36 = new wxButton( itemDialog1, ID_EX_CLEAR, _("C"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer33->Add(itemButton36, 1, wxGROW|wxALL, 2);

    wxButton* itemButton37 = new wxButton( itemDialog1, ID_EX_PLUS_MINUS, wxGetTranslation(wxString() + (wxChar) 0x00B1), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer33->Add(itemButton37, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer38 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer32->Add(itemBoxSizer38, 1, wxGROW|wxALL, 0);

    wxButton* itemButton39 = new wxButton( itemDialog1, ID_EX_NUM7, _("7"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer38->Add(itemButton39, 1, wxGROW|wxALL, 2);

    wxButton* itemButton40 = new wxButton( itemDialog1, ID_EX_NUM8, _("8"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer38->Add(itemButton40, 1, wxGROW|wxALL, 2);

    wxButton* itemButton41 = new wxButton( itemDialog1, ID_EX_NUM9, _("9"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer38->Add(itemButton41, 1, wxGROW|wxALL, 2);

    wxButton* itemButton42 = new wxButton( itemDialog1, ID_EX_DIVIDE, _("/"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer38->Add(itemButton42, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer43 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer32->Add(itemBoxSizer43, 1, wxGROW|wxALL, 0);

    wxButton* itemButton44 = new wxButton( itemDialog1, ID_EX_NUM4, _("4"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer43->Add(itemButton44, 1, wxGROW|wxALL, 2);

    wxButton* itemButton45 = new wxButton( itemDialog1, ID_EX_NUM5, _("5"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer43->Add(itemButton45, 1, wxGROW|wxALL, 2);

    wxButton* itemButton46 = new wxButton( itemDialog1, ID_EX_NUM6, _("6"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer43->Add(itemButton46, 1, wxGROW|wxALL, 2);

    wxButton* itemButton47 = new wxButton( itemDialog1, ID_EX_MULTIPLY, _("*"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer43->Add(itemButton47, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer48 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer32->Add(itemBoxSizer48, 1, wxGROW|wxALL, 0);

    wxButton* itemButton49 = new wxButton( itemDialog1, ID_EX_NUM1, _("1"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer48->Add(itemButton49, 1, wxGROW|wxALL, 2);

    wxButton* itemButton50 = new wxButton( itemDialog1, ID_EX_NUM2, _("2"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer48->Add(itemButton50, 1, wxGROW|wxALL, 2);

    wxButton* itemButton51 = new wxButton( itemDialog1, ID_EX_NUM3, _("3"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer48->Add(itemButton51, 1, wxGROW|wxALL, 2);

    wxButton* itemButton52 = new wxButton( itemDialog1, ID_EX_MINUS, _("-"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer48->Add(itemButton52, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer53 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer32->Add(itemBoxSizer53, 1, wxGROW|wxALL, 0);

    wxButton* itemButton54 = new wxButton( itemDialog1, ID_EX_NUM0, _("0"), wxDefaultPosition, wxSize(50, 25), 0 );
    itemBoxSizer53->Add(itemButton54, 2, wxGROW|wxALL, 2);

    wxButton* itemButton55 = new wxButton( itemDialog1, ID_EX_DECIMAL, _("."), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer53->Add(itemButton55, 1, wxGROW|wxALL, 2);

    wxButton* itemButton56 = new wxButton( itemDialog1, ID_EX_PLUS, _("+"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer53->Add(itemButton56, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer57 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer31->Add(itemBoxSizer57, 1, wxGROW|wxALL, 0);

    wxButton* itemButton58 = new wxButton( itemDialog1, ID_EX_BACK_SPACE, _("<-"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer57->Add(itemButton58, 1, wxGROW|wxALL, 2);

    wxButton* itemButton59 = new wxButton( itemDialog1, ID_EX_EQUAL, _("="), wxDefaultPosition, wxSize(25, 50), 0 );
    itemBoxSizer57->Add(itemButton59, 2, wxGROW|wxALL, 2);

    wxButton* itemButton60 = new wxButton( itemDialog1, ID_EX_ENTER, _("Ent"), wxDefaultPosition, wxSize(25, 50), 0 );
    itemBoxSizer57->Add(itemButton60, 2, wxGROW|wxALL, 2);

////@end KeypadEx content construction
}

static wxString ToString(double val) 
{
	wxString value = wxString::Format(wxT("%f"), val);
	wxChar lastVal;

	while((value.Last() == wxT('0') || value.Last() == wxT('.')) && value != wxT("0")) {
		lastVal = value.Last();
		value.RemoveLast();
		if (lastVal == wxT('.')) {
			break;
		}
	}
	return(value);
}

static double ToDouble(const wxString &val) 
{
	double dval;
	val.ToDouble(&dval);
	return(dval);
}

/*
 * Should we show tooltips?
 */

bool KeypadEx::ShowToolTips()
{
    return true;
}

/*
 * Get bitmap resources
 */

wxBitmap KeypadEx::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin KeypadEx bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end KeypadEx bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon KeypadEx::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin KeypadEx icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end KeypadEx icon retrieval
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_SINE
 */

void KeypadEx::OnSineClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(sin(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_COSINE
 */

void KeypadEx::OnCosineClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(cos(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_TANGENT
 */

void KeypadEx::OnTangentClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(tan(dval * 3.141592 / 180.0)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_TANGENTH
 */

void KeypadEx::OnTangenthClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(tanh(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_FACTORIAL
 */
static double factorial(double n) 
{
	if (n == 0) {
       return 1;
	}
	if (n < 0) {
		return(n);
	}
    return(n * factorial(n - 1));
}

void KeypadEx::OnFactorialClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(factorial(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_XPOWY
 */

void KeypadEx::OnXpowyClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_PWR;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_LOG_NATURAL
 */

void KeypadEx::OnLogNaturalClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(log(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_LOG
 */

void KeypadEx::OnLogClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(log10(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_SQUARE_ROOT
 */

void KeypadEx::OnSquareRootClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_staticText->SetLabel(ToString(sqrt(dval)));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MODULUS
 */

void KeypadEx::OnModulusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_MOD;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_RECIPROCAL
 */

void KeypadEx::OnReciprocalClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	dval = 1 / dval;
	m_staticText->SetLabel(ToString(dval));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PI
 */

void KeypadEx::OnPiClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = 3.141592;
	m_staticText->SetLabel(ToString(dval));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_RECALL
 */

void KeypadEx::OnMemRecallClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(ToString(m_memory));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_STORE
 */

void KeypadEx::OnMemStoreClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_memory = ToDouble(m_staticText->GetLabel());
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_ADD
 */

void KeypadEx::OnMemAddClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_memory += dval;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MEM_SUB
 */

void KeypadEx::OnMemSubClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	m_memory -= dval;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_NUM0
 */

void KeypadEx::OnNumberClick( wxCommandEvent& event )
{
	wxButton *btn = dynamic_cast<wxButton *>(event.GetEventObject());
	if (btn) {
		if (m_init) {
			m_staticText->SetLabel(wxEmptyString);
		}
		m_value = m_staticText->GetLabel();
		m_value.Append(btn->GetLabel());
		m_staticText->SetLabel(m_value);
		m_value.Clear();
	}
	m_init = false;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_ENTER
 */

void KeypadEx::OnEnterClick( wxCommandEvent& event )
{
	OnEqualClick(event);
    EndModal(wxID_OK);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_EQUAL
 */

void KeypadEx::OnEqualClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_EQUAL;
	m_entries.push_back(e);
	Calc();
	m_entries.clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_BACK_SPACE
 */

void KeypadEx::OnBackSpaceClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_value = m_staticText->GetLabel();
	m_value.RemoveLast();
	m_staticText->SetLabel(m_value);
	m_value.Clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PLUS_MINUS
 */

void KeypadEx::OnPlusMinusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	dval *= -1;
	m_staticText->SetLabel(ToString(dval));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_DIVIDE
 */

void KeypadEx::OnDivideClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_DIV;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MULTIPLY
 */

void KeypadEx::OnMultiplyClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_MUL;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_MINUS
 */

void KeypadEx::OnMinusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_SUB;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_PLUS
 */

void KeypadEx::OnPlusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_ADD;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_CLEAR
 */

void KeypadEx::OnClearClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(m_orgVal);
	m_init = true;
	m_entries.clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_CLEAR_ERROR
 */

void KeypadEx::OnClearErrorClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(wxT("0"));
	m_init = true;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EX_ESCAPE
 */

void KeypadEx::OnEscClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(m_orgVal);
	EndModal(wxID_OK);
}

double KeypadEx::Calc(void)
{
	double total = 0;
	int lastAction = ACTION_ADD;
	for (Entries::iterator ei = m_entries.begin(); ei != m_entries.end(); ei++) {
		struct entry e = *ei;
		switch(lastAction) {
			case ACTION_ADD:
				total += e.value;
				break;
			case ACTION_SUB:
				total -= e.value;
				break;
			case ACTION_MUL:
				total *= e.value;
				break;
			case ACTION_DIV:
				total /= e.value;
				break;
			case ACTION_MOD:
				total = fmod(total, e.value);
				break;
			case ACTION_PWR:
				total = pow(total, e.value);
				break;
			case ACTION_NONE:
			default:
				break;
		}
		lastAction = e.action;
	}
	m_staticText->SetLabel(ToString(total));
	m_init = true;
	return(total);
}

