/////////////////////////////////////////////////////////////////////////////
// Name:        Keypad.h
// Purpose:     
// Author:      Newfangled Solutions
// Modified by: 
// Created:     28/04/2014 20:29:23
// RCS-ID:      
// Copyright:   Copyright 2013
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _KEYPAD_H_
#define _KEYPAD_H_


/*!
 * Includes
 */

////@begin includes
////@end includes
#include "KeypadCommon.h"

/*!
 * Forward declarations
 */

////@begin forward declarations
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_KEYPAD 10004
#define ID_ESCAPE 10005
#define ID_CLEAR_ERROR 10006
#define ID_CLEAR 10007
#define ID_PLUS_MINUS 10003
#define ID_NUM7 10008
#define ID_NUM8 10009
#define ID_NUM9 10010
#define ID_DIVIDE 10002
#define ID_NUM4 10011
#define ID_NUM5 10012
#define ID_NUM6 10013
#define ID_MULTIPLY 10001
#define ID_NUM1 10014
#define ID_NUM2 10015
#define ID_NUM3 10016
#define ID_MINUS 10000
#define ID_NUM0 10020
#define ID_DECIMAL 10021
#define ID_PLUS 10022
#define ID_BACK_SPACE 10017
#define ID_EQUAL 10018
#define ID_ENTER 10019
#define SYMBOL_KEYPAD_STYLE wxRESIZE_BORDER|wxTAB_TRAVERSAL
#define SYMBOL_KEYPAD_TITLE _("Keypad")
#define SYMBOL_KEYPAD_IDNAME ID_KEYPAD
#define SYMBOL_KEYPAD_SIZE wxDefaultSize
#define SYMBOL_KEYPAD_POSITION wxDefaultPosition
////@end control identifiers

/*!
 * Keypad class declaration
 */

class Keypad: public wxDialog
{    
    DECLARE_DYNAMIC_CLASS( Keypad )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    Keypad();
    Keypad( wxWindow* parent, wxWindowID id = SYMBOL_KEYPAD_IDNAME, const wxString& caption = SYMBOL_KEYPAD_TITLE, const wxPoint& pos = SYMBOL_KEYPAD_POSITION, const wxSize& size = SYMBOL_KEYPAD_SIZE, long style = SYMBOL_KEYPAD_STYLE );
    Keypad( wxWindow* parent, wxStaticText *staticText, wxWindowID id = SYMBOL_KEYPAD_IDNAME, const wxString& caption = SYMBOL_KEYPAD_TITLE, const wxPoint& pos = SYMBOL_KEYPAD_POSITION, const wxSize& size = SYMBOL_KEYPAD_SIZE, long style = SYMBOL_KEYPAD_STYLE );

    /// Creation
    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_KEYPAD_IDNAME, const wxString& caption = SYMBOL_KEYPAD_TITLE, const wxPoint& pos = SYMBOL_KEYPAD_POSITION, const wxSize& size = SYMBOL_KEYPAD_SIZE, long style = SYMBOL_KEYPAD_STYLE );

    /// Destructor
    ~Keypad();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin Keypad event handler declarations

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_ESCAPE
    void OnEscClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_CLEAR_ERROR
    void OnClearErrorClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_CLEAR
    void OnClearClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_PLUS_MINUS
    void OnPlusMinusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_NUM7
    void OnNumberClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_DIVIDE
    void OnDivideClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_MULTIPLY
    void OnMultiplyClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_MINUS
    void OnMinusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_PLUS
    void OnPlusClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BACK_SPACE
    void OnBackSpaceClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_EQUAL
    void OnEqualClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_ENTER
    void OnEnterClick( wxCommandEvent& event );

////@end Keypad event handler declarations

	double Calc(void);

////@begin Keypad member function declarations

    wxString GetOrgVal() const { return m_orgVal ; }
    void SetOrgVal(wxString value) { m_orgVal = value ; }

    wxStaticText * GetStaticText() const { return m_staticText ; }
    void SetStaticText(wxStaticText * value) { m_staticText = value ; }

    wxString GetValue() const { return m_value ; }
    void SetValue(wxString value) { m_value = value ; }

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end Keypad member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin Keypad member variables
private:
    wxString m_orgVal;
    wxStaticText * m_staticText;
    wxString m_value;
////@end Keypad member variables
	double m_memory;
	double m_lval[2];
	int    m_lvalIndex;
	bool   m_init;
	Entries m_entries;
};

#endif
    // _KEYPAD_H_
