/////////////////////////////////////////////////////////////////////////////
// Name:        Keypad.cpp
// Purpose:     
// Author:      Newfangled Solutions
// Modified by: 
// Created:     28/04/2014 20:29:23
// RCS-ID:      
// Copyright:   Copyright 2013
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "Keypad.h"

////@begin XPM images
////@end XPM images
#include <math.h>

/*
 * Keypad type definition
 */

IMPLEMENT_DYNAMIC_CLASS( Keypad, wxDialog )


/*
 * Keypad event table definition
 */

BEGIN_EVENT_TABLE( Keypad, wxDialog )

////@begin Keypad event table entries
    EVT_BUTTON( ID_ESCAPE, Keypad::OnEscClick )
    EVT_BUTTON( ID_CLEAR_ERROR, Keypad::OnClearErrorClick )
    EVT_BUTTON( ID_CLEAR, Keypad::OnClearClick )
    EVT_BUTTON( ID_PLUS_MINUS, Keypad::OnPlusMinusClick )
    EVT_BUTTON( ID_NUM7, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM8, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM9, Keypad::OnNumberClick )
    EVT_BUTTON( ID_DIVIDE, Keypad::OnDivideClick )
    EVT_BUTTON( ID_NUM4, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM5, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM6, Keypad::OnNumberClick )
    EVT_BUTTON( ID_MULTIPLY, Keypad::OnMultiplyClick )
    EVT_BUTTON( ID_NUM1, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM2, Keypad::OnNumberClick )
    EVT_BUTTON( ID_NUM3, Keypad::OnNumberClick )
    EVT_BUTTON( ID_MINUS, Keypad::OnMinusClick )
    EVT_BUTTON( ID_NUM0, Keypad::OnNumberClick )
    EVT_BUTTON( ID_DECIMAL, Keypad::OnNumberClick )
    EVT_BUTTON( ID_PLUS, Keypad::OnPlusClick )
    EVT_BUTTON( ID_BACK_SPACE, Keypad::OnBackSpaceClick )
    EVT_BUTTON( ID_EQUAL, Keypad::OnEqualClick )
    EVT_BUTTON( ID_ENTER, Keypad::OnEnterClick )
////@end Keypad event table entries

END_EVENT_TABLE()


/*
 * Keypad constructors
 */

Keypad::Keypad()
{
    Init();
}

Keypad::Keypad( wxWindow* parent, wxStaticText *staticText, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	double dval;
    Init();
	m_staticText = staticText;
    Create(parent, id, caption, pos, size, style);
	m_orgVal = m_staticText->GetLabel();
	m_value.Clear();
	m_orgVal.ToDouble(&dval);
}

Keypad::Keypad( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
    Init();
    Create(parent, id, caption, pos, size, style);
}


/*
 * Keypad creator
 */

bool Keypad::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin Keypad creation
    SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
////@end Keypad creation
    return true;
}


/*
 * Keypad destructor
 */

Keypad::~Keypad()
{
////@begin Keypad destruction
////@end Keypad destruction
}


/*
 * Member initialisation
 */

void Keypad::Init()
{
////@begin Keypad member initialisation
    m_staticText = NULL;
////@end Keypad member initialisation
	m_memory = 0;
	m_lval[0] = 0;
	m_lval[1] = 0;
	m_lvalIndex = 0;
	m_init = true;
}


/*
 * Control creation for Keypad
 */

void Keypad::CreateControls()
{    
////@begin Keypad content construction
    Keypad* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 5, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer3->Add(itemBoxSizer4, 5, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer5 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer4->Add(itemBoxSizer5, 4, wxGROW|wxALL, 0);

    wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer6, 1, wxGROW|wxALL, 0);

    wxButton* itemButton7 = new wxButton( itemDialog1, ID_ESCAPE, _("Esc"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemButton7->SetForegroundColour(wxColour(255, 0, 0));
    itemBoxSizer6->Add(itemButton7, 1, wxGROW|wxALL, 2);

    wxButton* itemButton8 = new wxButton( itemDialog1, ID_CLEAR_ERROR, _("CE"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer6->Add(itemButton8, 1, wxGROW|wxALL, 2);

    wxButton* itemButton9 = new wxButton( itemDialog1, ID_CLEAR, _("C"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer6->Add(itemButton9, 1, wxGROW|wxALL, 2);

    wxButton* itemButton10 = new wxButton( itemDialog1, ID_PLUS_MINUS, wxGetTranslation(wxString() + (wxChar) 0x00B1), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer6->Add(itemButton10, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer11 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer11, 1, wxGROW|wxALL, 0);

    wxButton* itemButton12 = new wxButton( itemDialog1, ID_NUM7, _("7"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer11->Add(itemButton12, 1, wxGROW|wxALL, 2);

    wxButton* itemButton13 = new wxButton( itemDialog1, ID_NUM8, _("8"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer11->Add(itemButton13, 1, wxGROW|wxALL, 2);

    wxButton* itemButton14 = new wxButton( itemDialog1, ID_NUM9, _("9"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer11->Add(itemButton14, 1, wxGROW|wxALL, 2);

    wxButton* itemButton15 = new wxButton( itemDialog1, ID_DIVIDE, _("/"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer11->Add(itemButton15, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer16 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer16, 1, wxGROW|wxALL, 0);

    wxButton* itemButton17 = new wxButton( itemDialog1, ID_NUM4, _("4"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer16->Add(itemButton17, 1, wxGROW|wxALL, 2);

    wxButton* itemButton18 = new wxButton( itemDialog1, ID_NUM5, _("5"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer16->Add(itemButton18, 1, wxGROW|wxALL, 2);

    wxButton* itemButton19 = new wxButton( itemDialog1, ID_NUM6, _("6"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer16->Add(itemButton19, 1, wxGROW|wxALL, 2);

    wxButton* itemButton20 = new wxButton( itemDialog1, ID_MULTIPLY, _("*"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer16->Add(itemButton20, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer21 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer21, 1, wxGROW|wxALL, 0);

    wxButton* itemButton22 = new wxButton( itemDialog1, ID_NUM1, _("1"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton22, 1, wxGROW|wxALL, 2);

    wxButton* itemButton23 = new wxButton( itemDialog1, ID_NUM2, _("2"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton23, 1, wxGROW|wxALL, 2);

    wxButton* itemButton24 = new wxButton( itemDialog1, ID_NUM3, _("3"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton24, 1, wxGROW|wxALL, 2);

    wxButton* itemButton25 = new wxButton( itemDialog1, ID_MINUS, _("-"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer21->Add(itemButton25, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer26 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer5->Add(itemBoxSizer26, 1, wxGROW|wxALL, 0);

    wxButton* itemButton27 = new wxButton( itemDialog1, ID_NUM0, _("0"), wxDefaultPosition, wxSize(50, 25), 0 );
    itemBoxSizer26->Add(itemButton27, 2, wxGROW|wxALL, 2);

    wxButton* itemButton28 = new wxButton( itemDialog1, ID_DECIMAL, _("."), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer26->Add(itemButton28, 1, wxGROW|wxALL, 2);

    wxButton* itemButton29 = new wxButton( itemDialog1, ID_PLUS, _("+"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer26->Add(itemButton29, 1, wxGROW|wxALL, 2);

    wxBoxSizer* itemBoxSizer30 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer4->Add(itemBoxSizer30, 1, wxGROW|wxALL, 0);

    wxButton* itemButton31 = new wxButton( itemDialog1, ID_BACK_SPACE, _("<-"), wxDefaultPosition, wxSize(25, 25), 0 );
    itemBoxSizer30->Add(itemButton31, 1, wxGROW|wxALL, 2);

    wxButton* itemButton32 = new wxButton( itemDialog1, ID_EQUAL, _("="), wxDefaultPosition, wxSize(25, 50), 0 );
    itemBoxSizer30->Add(itemButton32, 2, wxGROW|wxALL, 2);

    wxButton* itemButton33 = new wxButton( itemDialog1, ID_ENTER, _("Ent"), wxDefaultPosition, wxSize(25, 50), 0 );
    itemBoxSizer30->Add(itemButton33, 2, wxGROW|wxALL, 2);

////@end Keypad content construction
}

static wxString ToString(double val) 
{
	wxString value = wxString::Format(wxT("%f"), val);
	wxChar lastVal;

	while((value.Last() == wxT('0') || value.Last() == wxT('.')) && value != wxT("0")) {
		lastVal = value.Last();
		value.RemoveLast();
		if (lastVal == wxT('.')) {
			break;
		}
	}
	return(value);
}

static double ToDouble(const wxString &val) 
{
	double dval;
	val.ToDouble(&dval);
	return(dval);
}

/*
 * Should we show tooltips?
 */

bool Keypad::ShowToolTips()
{
    return true;
}

/*
 * Get bitmap resources
 */

wxBitmap Keypad::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin Keypad bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end Keypad bitmap retrieval
}

/*
 * Get icon resources
 */

wxIcon Keypad::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin Keypad icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end Keypad icon retrieval
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON4
 */

void Keypad::OnNumberClick( wxCommandEvent& event )
{
	wxButton *btn = dynamic_cast<wxButton *>(event.GetEventObject());
	if (btn) {
		if (m_init) {
			m_staticText->SetLabel(wxEmptyString);
		}
		m_value = m_staticText->GetLabel();
		m_value.Append(btn->GetLabel());
		m_staticText->SetLabel(m_value);
		m_value.Clear();
	}
	m_init = false;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON15
 */

void Keypad::OnEnterClick( wxCommandEvent& event )
{
	OnEqualClick(event);
    EndModal(wxID_OK);
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON14
 */

void Keypad::OnEqualClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_EQUAL;
	m_entries.push_back(e);
	Calc();
	m_entries.clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON13
 */

void Keypad::OnBackSpaceClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_value = m_staticText->GetLabel();
	m_value.RemoveLast();
	m_staticText->SetLabel(m_value);
	m_value.Clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON20
 */

void Keypad::OnPlusMinusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	double dval = ToDouble(m_staticText->GetLabel());
	dval *= -1;
	m_staticText->SetLabel(ToString(dval));
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON19
 */

void Keypad::OnDivideClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_DIV;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON18
 */

void Keypad::OnMultiplyClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_MUL;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON
 */

void Keypad::OnMinusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_SUB;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON21
 */

void Keypad::OnPlusClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	struct entry e;
	e.value = ToDouble(m_staticText->GetLabel());
	e.action = ACTION_ADD;
	m_entries.push_back(e);
	Calc();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON3
 */

void Keypad::OnClearClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(m_orgVal);
	m_init = true;
	m_entries.clear();
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON2
 */

void Keypad::OnClearErrorClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(wxT("0"));
	m_init = true;
}


/*
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON1
 */

void Keypad::OnEscClick( wxCommandEvent& event )
{
	wxUnusedVar(event);
	m_staticText->SetLabel(m_orgVal);
	EndModal(wxID_OK);
}

double Keypad::Calc(void)
{
	double total = 0;
	int lastAction = ACTION_ADD;
	for (Entries::iterator ei = m_entries.begin(); ei != m_entries.end(); ei++) {
		struct entry e = *ei;
		switch(lastAction) {
			case ACTION_ADD:
				total += e.value;
				break;
			case ACTION_SUB:
				total -= e.value;
				break;
			case ACTION_MUL:
				total *= e.value;
				break;
			case ACTION_DIV:
				total /= e.value;
				break;
			case ACTION_MOD:
				total = fmod(total, e.value);
				break;
			case ACTION_PWR:
				total = pow(total, e.value);
				break;
			case ACTION_NONE:
			default:
				break;
		}
		lastAction = e.action;
	}
	m_staticText->SetLabel(ToString(total));
	m_init = true;
	return(total);
}

