/////////////////////////////////////////////////////////////////////////////
// Name:        GridData.h
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     31/05/2012 13:04:11
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _INPUTDATA_H_
#define _INPUTDATA_H_
#include "MachAPI.h"
#include <vector>

typedef struct {
	wxString devName;
	wxArrayString iNames;
	wxArrayString oNames;
	wxArrayString oNamesUsed;
	wxArrayString oNamesUnused;
} DevIoNames; 

typedef std::vector<DevIoNames *> DevIoNamesArray;
typedef std::vector<DevIoNames *>::iterator DevIoNamesIterator;


/*!
 * GridData class declaration
 */

class GridData: public wxObject
{    
	DECLARE_DYNAMIC_CLASS( GridData )
public:
	/// Default constructor for GridData
	GridData();

	/// Copy constructor for GridData
	GridData(const GridData& data);

	/// Destructor for GridData
	~GridData();

	/// Assignment operator for GridData
	void operator=(const GridData& data);

	/// Equality operator for GridData
	bool operator==(const GridData& data) const;

	/// Copy function for GridData
	void Copy(const GridData& data);

	/// Initialises member variables
	void Init();

////@begin GridData member function declarations
	HMCSIG GethSig() const { return m_hSig ; }
	void SethSig(HMCSIG value) { m_hSig = value ; }

	bool GetEnabled() const { return m_enabled ; }
	void SetEnabled(bool value) { m_enabled = value ; }

	wxString GetSigName() const { return m_sigName ; }
	void SetSigName(wxString value) { m_sigName = value ; }

	wxString GetSigDesc() const { return m_sigDesc ; }
	void SetSigDesc(wxString value) { m_sigDesc = value ; }

	bool GetActiveLow() const { return m_activeLow ; }
	void SetActiveLow(bool value) { m_activeLow = value ; }

	bool GetEmulated() const { return m_emulated ; }
	void SetEmulated(bool value) { m_emulated = value ; }

	int GetHotkey() const { return m_hotkey ; }
	void SetHotkey(int value) { m_hotkey = value ; }

	wxString GetDevName() const { return m_devName ; }
	void SetDevName(wxString value) { m_devName = value ; }

	wxString GetDevDesc() const { return m_devDesc ; }
	void SetDevDesc(wxString value) { m_devDesc = value ; }

	HMCIO GethIO() const { return m_hIO ; }
	void SethIO(HMCIO value) { m_hIO = value ; }

	wxString GetIoName() const { return m_ioName ; }
	void SetIoName(wxString value) { m_ioName = value ; }

	wxString GetIoDesc() const { return m_ioDesc ; }
	void SetIoDesc(wxString value) { m_ioDesc = value ; }

////@end GridData member function declarations

////@begin GridData member variables
	HMCSIG m_hSig; // The signal handle
	bool m_enabled;
	wxString m_sigName;
	wxString m_sigDesc;
	bool m_activeLow;
	bool m_emulated;
	int m_hotkey;
	wxString m_devName;
	wxString m_devDesc;
	HMCIO m_hIO;
	wxString m_ioName;
	wxString m_ioDesc;
////@end GridData member variables
};

typedef std::vector<GridData *> GridDataArray;
typedef std::vector<GridData *>::iterator GridDataIterator;

#endif
	// _INPUTDATA_H_
