/////////////////////////////////////////////////////////////////////////////
// Name:        GridData.cpp
// Purpose:     
// Author:      Steve Murphree
// Modified by: 
// Created:     31/05/2012 13:04:11
// RCS-ID:      
// Copyright:   Copyright 2011
// Licence:     
/////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
#include "GridData.h"

////@end includes


/*
 * GridData type definition
 */

IMPLEMENT_DYNAMIC_CLASS( GridData, wxObject )

/*
 * Default constructor for GridData
 */

GridData::GridData()
{
	Init();
}

/*
 * Copy constructor for GridData
 */

GridData::GridData(const GridData& data)
{
	Init();
	Copy(data);
}

/*
 * Destructor for GridData
 */

GridData::~GridData()
{
}

/*
 * Assignment operator for GridData
 */

void GridData::operator=(const GridData& data)
{
	Copy(data);
}

/*
 * Equality operator for GridData
 */

bool GridData::operator==(const GridData& data) const
{
////@begin GridData equality operator
	 if (!(m_hSig == data.m_hSig)) return false;
	 if (!(m_enabled == data.m_enabled)) return false;
	 if (!(m_sigName == data.m_sigName)) return false;
	 if (!(m_sigDesc == data.m_sigDesc)) return false;
	 if (!(m_activeLow == data.m_activeLow)) return false;
	 if (!(m_emulated == data.m_emulated)) return false;
	 if (!(m_hotkey == data.m_hotkey)) return false;
	 if (!(m_devName == data.m_devName)) return false;
	 if (!(m_devDesc == data.m_devDesc)) return false;
	 if (!(m_hIO == data.m_hIO)) return false;
	 if (!(m_ioName == data.m_ioName)) return false;
	 if (!(m_ioDesc == data.m_ioDesc)) return false;
////@end GridData equality operator
	return true;
}

/*
 * Copy function for GridData
 */

void GridData::Copy(const GridData& data)
{
////@begin GridData copy function
	m_hSig = data.m_hSig;
	m_enabled = data.m_enabled;
	m_sigName = data.m_sigName;
	m_sigDesc = data.m_sigDesc;
	m_activeLow = data.m_activeLow;
	m_emulated = data.m_emulated;
	m_hotkey = data.m_hotkey;
	m_devName = data.m_devName;
	m_devDesc = data.m_devDesc;
	m_hIO = data.m_hIO;
	m_ioName = data.m_ioName;
	m_ioDesc = data.m_ioDesc;
////@end GridData copy function
}

/*
 * Member initialisation for GridData
 */

void GridData::Init()
{
////@begin GridData member initialisation
	m_hSig = 0;
	m_enabled = false;
	m_activeLow = false;
	m_emulated = false;
	m_hotkey = 0;
	m_hIO = 0;
////@end GridData member initialisation
}
